/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mysql.schema;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.mysql.Connection;
import inform.agent.db.connect.mysql.schema.Table;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import java.sql.DatabaseMetaData;

public class Scheme
extends DbScheme {
    public Scheme(String name, Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData, name);
    }

    @Override
    protected DbTable newTableObject(String name) {
        return new Table(name, this);
    }

    @Override
    public String ct2sql(DataType type, FieldDescriptor.BlobRawType brt, int size, boolean keyable) {
        switch (type) {
            case DIRECTORY: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return "BIGINT";
            }
            case FLOAT: 
            case INTERVAL: {
                return "DOUBLE";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BOOLEAN: {
                return "BIT";
            }
            case STRING: 
            case UNICODE: {
                return "VARCHAR(" + size + ")";
            }
            case DATE_TIME: {
                return "DATETIME";
            }
            case BLOB: {
                if (brt == FieldDescriptor.BlobRawType.TEXT) {
                    return "TEXT";
                }
                return "BLOB";
            }
            case FILE: {
                return "VARCHAR(256)";
            }
            case GEOMETRY: {
                return "GEOMETRY";
            }
        }
        return super.ct2sql(type, brt, size, keyable);
    }

    @Override
    protected String catalog() {
        return this.name;
    }

    @Override
    public String toCaseIfNeed(String name) {
        return name.toLowerCase();
    }

    @Override
    public String nameFromDb(String name) {
        return name.toLowerCase();
    }
}

