/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.odbc;

import inform.adt.InformException;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.odbc.PreparedStatement;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class Connection
extends DatabaseConnection {
    public Connection(DatabaseDescriptor descriptor) throws SQLException, InformException {
        super(descriptor);
    }

    @Override
    protected String connectionString() {
        return this.descriptor.getServer() + "@" + this.descriptor.getUserName();
    }

    @Override
    protected java.sql.Connection establishConnection() throws SQLException {
        String dsn = this.descriptor.getServer();
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(this.descriptor.getLogConnectionString(null), ex);
        }
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", this.descriptor.getUserName());
        connectionProperties.put("password", this.descriptor.getPassword());
        connectionProperties.put("charSet", "Cp1251");
        return DriverManager.getConnection("jdbc:odbc:" + dsn, connectionProperties);
    }

    @Override
    protected PreparedStatement newPreparedStatement(String comment, String sql) throws SQLException {
        return new PreparedStatement(comment, sql, this.connection.prepareStatement(sql), this);
    }
}

