/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle;

import inform.adt.DateTime;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.oracle.Geometry;
import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSet;
import oracle.sql.DATE;

public class ResultSet
extends inform.agent.db.connect.ResultSet {
    private final OracleResultSet rs;

    ResultSet(OracleResultSet result, AbstractStatement statement, long startTime) {
        super((java.sql.ResultSet)result, statement, startTime);
        this.rs = result;
    }

    @Override
    public byte[] getBlobBytes(int idx) throws SQLException {
        ResultSetMetaData metadata = this.getMetaData();
        switch (metadata.getColumnType(idx)) {
            case 2005: 
            case 2011: {
                String value = this.getString(idx);
                return value == null ? null : value.getBytes(TaggedWriter.ANSI);
            }
        }
        Blob blob = this.rs.getBlob(idx);
        return blob == null ? null : blob.getBytes(1L, (int)blob.length());
    }

    @Override
    public BlobStream getBlobStream(int idx) throws SQLException {
        ResultSetMetaData metadata = this.getMetaData();
        switch (metadata.getColumnType(idx)) {
            case 2005: 
            case 2011: {
                String value = this.getString(idx);
                if (value == null) {
                    return null;
                }
                return new BlobStream.Bytes(value.getBytes(TaggedWriter.ANSI));
            }
        }
        Blob blob = this.rs.getBlob(idx);
        return blob == null ? null : new inform.agent.db.connect.oracle.BlobStream(blob);
    }

    @Override
    public double getDateTime(int idx) throws SQLException {
        DATE date = this.rs.getDATE(idx);
        if (date == null) {
            return 0.0;
        }
        byte[] bytes = date.shareBytes();
        return DateTime.createDateTime(((bytes[0] & 0xFF) - 100) * 100 + (bytes[1] & 0xFF) - 100, bytes[2], bytes[3], bytes[4] - 1, bytes[5] - 1, bytes[6] - 1, 0);
    }

    @Override
    public Geometry getGeometry(int idx) throws SQLException {
        byte[] bytes = this.rs.getBytes(idx);
        return bytes == null || bytes.length == 0 ? null : new Geometry.New(bytes);
    }
}

