/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.oracle.Connection;
import inform.agent.db.connect.oracle.schema.Column;
import inform.agent.db.connect.oracle.schema.Table;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbColumnable;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class Scheme
extends DbScheme {
    public Scheme(String name, Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> fetchTablesNames(SSContext ssContext, String nameFilter) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        if (this.name == null) {
            sql.append("SELECT * FROM ");
            this.connection.getDescriptor().appendSystemTable("user_tables", sql);
        } else {
            sql.append("SELECT * FROM ");
            this.connection.getDescriptor().appendSystemTable("all_tables", sql);
            sql.append(" WHERE owner=?");
        }
        if (nameFilter != null) {
            if (this.name == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            sql.append("table_name=?");
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql.toString());){
            int idx = 1;
            if (this.name != null) {
                ps.setString(idx++, Strings.unquote(this.name));
            }
            if (nameFilter != null) {
                ps.setString(idx++, Strings.unquote(nameFilter));
            }
            try (ResultSet rs = ps.executeQuery(ssContext);){
                int ci = rs.findColumn("TABLE_NAME");
                while (rs.next()) {
                    result.add(this.nameFromDb(rs.getString(ci)));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> fetchViewsNames(SSContext ssContext, String nameFilter) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        if (this.name == null) {
            sql.append("SELECT * FROM ");
            this.connection.getDescriptor().appendSystemTable("user_views", sql);
        } else {
            sql.append("SELECT * FROM ");
            this.connection.getDescriptor().appendSystemTable("all_views", sql);
            sql.append(" WHERE owner=?");
        }
        if (nameFilter != null) {
            if (this.name == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            sql.append("view_name=?");
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql.toString());){
            int idx = 1;
            if (this.name != null) {
                ps.setString(idx++, Strings.unquote(this.name));
            }
            if (nameFilter != null) {
                ps.setString(idx++, Strings.unquote(nameFilter));
            }
            try (ResultSet rs = ps.executeQuery(ssContext);){
                int ci = rs.findColumn("VIEW_NAME");
                while (rs.next()) {
                    result.add(this.nameFromDb(rs.getString(ci)));
                }
            }
        }
        return result;
    }

    @Override
    protected DbTable newTableObject(String name) {
        return new Table(name, this);
    }

    @Override
    public String ct2sql(DataType type, FieldDescriptor.BlobRawType brt, int size, boolean keyable) {
        switch (type) {
            case FLOAT: 
            case INTERVAL: 
            case DIRECTORY: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return "NUMBER";
            }
            case INTEGER: 
            case BOOLEAN: {
                return "NUMBER(10,0)";
            }
            case STRING: {
                return "VARCHAR2(" + size + ")";
            }
            case UNICODE: {
                return "NVARCHAR2(" + size + ")";
            }
            case DATE_TIME: {
                return "DATE";
            }
            case BLOB: {
                if (brt == FieldDescriptor.BlobRawType.TEXT) {
                    return "CLOB";
                }
                return "BLOB";
            }
            case FILE: {
                return "VARCHAR2(256)";
            }
            case GEOMETRY: {
                return "SDO_GEOMETRY";
            }
        }
        return super.ct2sql(type, brt, size, keyable);
    }

    @Override
    public String nameFromDb(String name) {
        if (Strings.startsWith(name, '\"')) {
            return name;
        }
        if (Strings.containsLowerCaseLetters(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    @Override
    public String toCaseIfNeed(String name) {
        if (Strings.startsWith(name, '\"')) {
            return name;
        }
        return name.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DbColumn> getColumns(SSContext ssContext, DbScheme scheme, DbColumnable columnable) throws SQLException {
        ResultSet rs;
        int idx;
        boolean hasScheme;
        LinkedHashMap<String, DbColumn> columns = new LinkedHashMap<String, DbColumn>();
        DatabaseDescriptor database = scheme.getDescriptor();
        StringBuilder sql = new StringBuilder();
        if (Strings.isVoid(scheme.name())) {
            hasScheme = false;
            sql.append("select COLUMN_NAME, DATA_TYPE, NULLABLE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, DATA_DEFAULT from ");
            database.appendSystemTable("user_tab_columns", sql);
            sql.append(" where table_name=?");
        } else {
            hasScheme = true;
            sql.append("select COLUMN_NAME, DATA_TYPE, NULLABLE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, DATA_DEFAULT from ");
            database.appendSystemTable("all_tab_columns", sql);
            sql.append(" where table_name=?");
            sql.append(" and owner=?");
        }
        try (PreparedStatement ps = scheme.getConnection().prepareStatement(sql.toString());){
            idx = 1;
            ps.setString(idx++, Strings.unquote(columnable.name()));
            if (hasScheme) {
                ps.setString(idx++, Strings.unquote(scheme.name()));
            }
            rs = ps.executeQuery(ssContext);
            try {
                int cName = rs.findColumn("COLUMN_NAME");
                int cType = rs.findColumn("DATA_TYPE");
                int cLength = rs.findColumn("DATA_LENGTH");
                int cNull = rs.findColumn("NULLABLE");
                int cPrecision = rs.findColumn("DATA_PRECISION");
                int cScale = rs.findColumn("DATA_SCALE");
                int cDefVal = rs.findColumn("DATA_DEFAULT");
                while (rs.next()) {
                    String fieldName = rs.getString(cName);
                    String fieldType = rs.getString(cType);
                    int fieldSize = 0;
                    String nullable = rs.getString(cNull);
                    DataType dataType = DataType.NONE;
                    FieldDescriptor.BlobRawType blobRawType = FieldDescriptor.BlobRawType.BINARY;
                    if (fieldType.equalsIgnoreCase("BLOB")) {
                        dataType = DataType.BLOB;
                    } else if (fieldType.equalsIgnoreCase("CLOB")) {
                        dataType = DataType.BLOB;
                        blobRawType = FieldDescriptor.BlobRawType.TEXT;
                    } else if (fieldType.equalsIgnoreCase("DATE")) {
                        dataType = DataType.DATE_TIME;
                    } else if (fieldType.equalsIgnoreCase("FLOAT")) {
                        dataType = DataType.FLOAT;
                    } else if (fieldType.equalsIgnoreCase("NUMBER")) {
                        int precision = rs.getInt(cPrecision);
                        boolean wasNull = rs.wasNull();
                        int scale = rs.getInt(cScale);
                        boolean bl = wasNull = wasNull || rs.wasNull();
                        dataType = !wasNull && precision <= 10 && scale == 0 ? DataType.INTEGER : DataType.FLOAT;
                    } else if (fieldType.equalsIgnoreCase("NVARCHAR")) {
                        dataType = DataType.UNICODE;
                        fieldSize = rs.getInt(cLength);
                    } else if (fieldType.equalsIgnoreCase("NVARCHAR2")) {
                        dataType = DataType.UNICODE;
                        fieldSize = rs.getInt(cLength);
                    } else if (fieldType.equalsIgnoreCase("NCHAR")) {
                        dataType = DataType.UNICODE;
                        fieldSize = rs.getInt(cLength);
                    } else if (fieldType.equalsIgnoreCase("VARCHAR")) {
                        dataType = DataType.STRING;
                        fieldSize = rs.getInt(cLength);
                    } else if (fieldType.equalsIgnoreCase("VARCHAR2")) {
                        dataType = DataType.STRING;
                        fieldSize = rs.getInt(cLength);
                    } else if (fieldType.equalsIgnoreCase("CHAR")) {
                        dataType = DataType.STRING;
                        fieldSize = rs.getInt(cLength);
                    } else if (fieldType.equalsIgnoreCase("SDO_GEOMETRY")) {
                        dataType = DataType.GEOMETRY;
                    } else if (fieldType.equalsIgnoreCase("NCLOB")) {
                        dataType = DataType.BLOB;
                        blobRawType = FieldDescriptor.BlobRawType.TEXT;
                    }
                    String defValue = rs.getString(cDefVal);
                    Column column = new Column(columnable, fieldName, dataType, blobRawType, fieldSize, nullable.equalsIgnoreCase("Y"));
                    column.setDefValue(defValue);
                    columns.put(fieldName, column);
                }
            }
            finally {
                rs.close();
            }
        }
        sql = new StringBuilder();
        if (!hasScheme) {
            sql.append("select T.COLUMN_NAME, T.CONSTRAINT_NAME, D.TABLE_NAME from ");
            database.appendSystemTable("USER_CONS_COLUMNS", sql);
            sql.append(" T  left outer join USER_CONSTRAINTS TT on (T.CONSTRAINT_NAME = TT.CONSTRAINT_NAME)").append(" left outer join USER_CONSTRAINTS D on (TT.R_CONSTRAINT_NAME = D.CONSTRAINT_NAME and TT.CONSTRAINT_TYPE in ('P', 'U'))").append(" where TT.CONSTRAINT_TYPE = 'R' and T.TABLE_NAME = ?");
        } else {
            sql.append("select T.COLUMN_NAME, T.CONSTRAINT_NAME, D.TABLE_NAME from ");
            database.appendSystemTable("ALL_CONS_COLUMNS", sql);
            sql.append(" T left outer join ");
            database.appendSystemTable("ALL_CONSTRAINTS", sql);
            sql.append(" TT on (T.CONSTRAINT_NAME = TT.CONSTRAINT_NAME) left outer join ");
            database.appendSystemTable("ALL_CONSTRAINTS", sql);
            sql.append(" D on (TT.R_CONSTRAINT_NAME = D.CONSTRAINT_NAME)").append(" where TT.CONSTRAINT_TYPE = 'R' and T.TABLE_NAME = ? and T.OWNER = ? and TT.OWNER = ?");
        }
        ps = scheme.getConnection().prepareStatement(sql.toString());
        try {
            idx = 1;
            ps.setString(idx++, Strings.unquote(columnable.name()));
            if (hasScheme) {
                ps.setString(idx++, Strings.unquote(scheme.name()));
                ps.setString(idx++, Strings.unquote(scheme.name()));
            }
            rs = ps.executeQuery(ssContext);
            try {
                boolean cColName = true;
                int cConsName = 2;
                int cRefName = 3;
                while (rs.next()) {
                    String colName = rs.getString(1);
                    String consName = rs.getString(2);
                    String refName = rs.getString(3);
                    DbColumn c = (DbColumn)columns.get(colName);
                    if (c == null) continue;
                    c.setForeignKey(consName, refName);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        return columns;
    }
}

