/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.postgresql.schema;

import inform.adt.Collections;
import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.postgresql.Connection;
import inform.agent.db.connect.postgresql.schema.Table;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;

public class Scheme
extends DbScheme {
    private static final String[] TYPES_TABLE_PG = Collections.append(DbScheme.TYPES_TABLE, "FOREIGN TABLE");

    public Scheme(String name, Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData, name);
    }

    @Override
    protected Collection<String> fetchTablesNames(SSContext ssContext, String nameFilter) throws SQLException {
        return this.fetchNames(ssContext, nameFilter, TYPES_TABLE_PG);
    }

    @Override
    protected DbTable newTableObject(String name) {
        return new Table(name, this);
    }

    @Override
    public boolean getKeyableByType(int type) {
        return type == 8;
    }

    @Override
    public String ct2sql(DataType type, FieldDescriptor.BlobRawType brt, int size, boolean keyable) {
        switch (type) {
            case DIRECTORY: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return "double precision";
            }
            case FLOAT: {
                if (keyable) {
                    return "double precision";
                }
                return "numeric";
            }
            case INTERVAL: {
                return "numeric";
            }
            case INTEGER: {
                return "integer";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case STRING: 
            case UNICODE: {
                return "character varying(" + size + ")";
            }
            case DATE_TIME: {
                return "timestamp without time zone";
            }
            case BLOB: {
                if (brt == FieldDescriptor.BlobRawType.TEXT) {
                    return "text";
                }
                return "bytea";
            }
            case FILE: {
                return "character varying(256)";
            }
            case GEOMETRY: {
                return "geometry";
            }
        }
        return super.ct2sql(type, brt, size, keyable);
    }

    @Override
    public String ct2sql(FieldDescriptor fd) {
        switch (fd.getType()) {
            case DIRECTORY: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return "double precision";
            }
            case FLOAT: {
                if (fd.isRecordIdPresentation()) {
                    return "double precision";
                }
                return "numeric";
            }
            case INTERVAL: {
                return "numeric";
            }
            case INTEGER: {
                return "integer";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case STRING: 
            case UNICODE: {
                return "character varying(" + fd.getSize() + ")";
            }
            case DATE_TIME: {
                return "timestamp without time zone";
            }
            case BLOB: {
                if (fd.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) {
                    return "tsvector";
                }
                if (fd.getBlobRawType() == FieldDescriptor.BlobRawType.TEXT) {
                    return "text";
                }
                return "bytea";
            }
            case FILE: {
                return "character varying(256)";
            }
            case GEOMETRY: {
                return "geometry";
            }
        }
        return super.ct2sql(fd);
    }

    @Override
    public String toCaseIfNeed(String name) {
        if (Strings.startsWith(name, '\"')) {
            return name;
        }
        return name.toLowerCase();
    }

    @Override
    public String nameFromDb(String name) {
        if (Strings.startsWith(name, '\"')) {
            return name;
        }
        if (Strings.containsUpperCaseLetters(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }
}

