/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.postgresql.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.postgresql.schema.Column;
import inform.agent.db.connect.postgresql.schema.Index;
import inform.agent.db.connect.postgresql.schema.Scheme;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

class Table
extends DbTable {
    Table(String name, Scheme scheme) {
        super(name, scheme);
    }

    @Override
    protected DbColumn newColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException {
        Column result = new Column(name, type, brt, nullable, size, this);
        result.setSqlTypeName(this.scheme.ct2sql(fd));
        statement.execute(ssContext, String.format("ALTER TABLE %s ADD COLUMN %s %s %s", this.fullName(), this.scheme.enquoteIfNeed(result.name()), result.getSqlType(), nullable ? "" : " NOT NULL"));
        if (fd.isHasDefValue()) {
            statement.execute(ssContext, String.format("ALTER TABLE %s ALTER COLUMN %s %s", this.fullName(), this.scheme.enquoteIfNeed(result.name()), this.scheme.columnDefValue(fd, true)));
        }
        this.addForeignKey(ssContext, statement, result.name(), fd);
        return result;
    }

    @Override
    protected DbColumn newColumnObject(String name) {
        return new Column(name, DataType.NONE, FieldDescriptor.BlobRawType.BINARY, true, 0, this);
    }

    @Override
    protected DbIndex newIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException {
        String condition = id.getCondition();
        IndexDescriptor.Method method = id.getMethod();
        if (id.isSDOType() && method == IndexDescriptor.Method.DEFAULT) {
            method = IndexDescriptor.Method.GiST;
        }
        Index result = new Index(this.scheme.toCaseIfNeed(id.getRawName()), this, id.isUnique(), condition, method);
        String methodSql = "";
        String fieldOptions = "";
        switch (method) {
            case BTREE: {
                methodSql = "USING btree ";
                break;
            }
            case GiST: {
                methodSql = "USING gist ";
                break;
            }
            case SPGiST: {
                methodSql = "USING spgist ";
                break;
            }
            case GIN: {
                methodSql = "USING gin ";
                if (!id.isUseTGRM()) break;
                fieldOptions = "gin_trgm_ops";
                break;
            }
            case BRIN: {
                methodSql = "USING brin ";
                break;
            }
            case RUM: {
                methodSql = "USING rum ";
            }
        }
        Object sql = String.format("CREATE %s INDEX %s ON %s %s( %s )", id.isUnique() ? "UNIQUE" : "", result.name(), this.fullName(), methodSql, id.fieldsList(id.isStrongUnique(), this.scheme, fieldOptions));
        if (!Strings.isVoid(condition)) {
            sql = (String)sql + " where " + condition;
        }
        statement.execute(ssContext, (String)sql);
        return result;
    }

    @Override
    protected DbIndex newIndexObject(String name, int type, String condition) {
        return new Index(name, this, false, condition, IndexDescriptor.Method.DEFAULT);
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, String.format("ALTER TABLE %s RENAME TO %s", this.fullName(), this.scheme.enquoteIfNeed(to)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFieldsInfo(SSContext ssContext, Statement statement, TableDescriptor tableDescriptor) throws SQLException {
        DatabaseCaps databaseCaps = this.scheme.getDatabaseType().caps();
        String commentSql = "COMMENT ON COLUMN " + this.fullName() + ".";
        String sql = "SELECT a.attname FROM pg_class c, pg_attribute a WHERE c.oid = a.attrelid AND c.relname = '" + this.name + "'";
        try (PreparedStatement ps = statement.connection().prepareStatement(sql);
             ResultSet rs = ps.executeQuery(ssContext);){
            while (rs.next()) {
                String fieldName = rs.getString(1);
                FieldDescriptor field = tableDescriptor.getField(fieldName);
                if (field == null) continue;
                String comment = field.getCaption();
                if (comment == null) {
                    comment = "";
                }
                statement.execute(ssContext, commentSql + field.getRawName() + " IS " + databaseCaps.c_string2sql(comment));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, DbIndex> internalGetIndexes(SSContext ssContext) throws SQLException {
        HashMap<String, DbIndex> indexes = new HashMap<String, DbIndex>();
        DatabaseDescriptor database = this.scheme.getDescriptor();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ci.relname AS F_INDEX_NAME, i.indisunique AS F_IS_UNIQUE, am.amname as F_USING, (i.keys).n AS F_ORDINAL_POSITION, trim(both '\"' from pg_catalog.pg_get_indexdef(ci.oid, (i.keys).n, false)) AS F_COLUMN_NAME, pg_catalog.pg_get_expr(i.indpred, i.indrelid) AS F_FILTER_CONDITION");
        sql.append(" FROM  pg_catalog.pg_class ct");
        sql.append(" JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)");
        sql.append(" JOIN ( SELECT i.indexrelid, i.indrelid, i.indoption, i.indisunique, i.indisprimary, i.indisclustered, i.indpred, i.indexprs, information_schema._pg_expandarray(i.indkey) AS keys FROM pg_catalog.pg_index i) i  ON (ct.oid = i.indrelid)");
        sql.append(" JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) JOIN pg_catalog.pg_am am ON (ci.relam = am.oid)");
        sql.append(" WHERE n.nspname = ? AND ct.relname = ? AND NOT i.indisprimary  ORDER BY F_INDEX_NAME, F_ORDINAL_POSITION");
        try (PreparedStatement ps = this.scheme.getConnection().prepareStatement(sql.toString());){
            int idx = 1;
            ps.setString(idx++, this.scheme.name());
            ps.setString(idx++, Strings.unquote(this.name()));
            try (ResultSet rs = ps.executeQuery(ssContext);){
                boolean cName = true;
                int cUnique = 2;
                int cMethod = 3;
                int cColOrder = 4;
                int cColName = 5;
                int cFilter = 6;
                while (rs.next()) {
                    String fieldName = this.scheme.nameFromDb(rs.getString(1));
                    int colOrder = rs.getAsInteger(4) - 1;
                    String colName = this.scheme.nameFromDb(rs.getString(5));
                    DbIndex db_idx = indexes.get(fieldName);
                    if (db_idx == null) {
                        boolean isUnique = rs.getBoolean(2);
                        String methodName = rs.getString(3);
                        String filter = rs.getString(6);
                        IndexDescriptor.Method method = IndexDescriptor.Method.DEFAULT;
                        if ("btree".equalsIgnoreCase(methodName)) {
                            method = IndexDescriptor.Method.BTREE;
                        } else if ("gist".equalsIgnoreCase(methodName)) {
                            method = IndexDescriptor.Method.GiST;
                        } else if ("spgist".equalsIgnoreCase(methodName)) {
                            method = IndexDescriptor.Method.SPGiST;
                        } else if ("gin".equalsIgnoreCase(methodName)) {
                            method = IndexDescriptor.Method.GIN;
                        } else if ("brin".equalsIgnoreCase(methodName)) {
                            method = IndexDescriptor.Method.BRIN;
                        }
                        db_idx = new Index(fieldName, this, isUnique, filter, method);
                        indexes.put(db_idx.name(), db_idx);
                    }
                    db_idx.getColumns().add(colOrder, this.getColumns(ssContext).get(colName));
                    db_idx.getRawColumns().add(colOrder, Strings.unquote(colName));
                }
            }
        }
        return indexes;
    }
}

