/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.expr;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.expr.DVEvaluator;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.DirectoriesCollection;
import inform.agent.db.utils.FieldLocation;
import inform.agent.expr.FieldTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class DVFieldEvaliator
extends DVEvaluator {
    private FieldLocation field = null;
    private final int[] fieldIdPath;
    private final TableDescriptor table;
    private FieldDescriptor fieldDescriptor;
    private final ArrayList<FieldLocation> paramPath;

    public DVFieldEvaliator(FieldTerm term, TableDescriptor table, ArrayList<FieldLocation> path) {
        super(term);
        assert (!path.isEmpty());
        this.paramPath = path;
        this.fieldIdPath = term.getFieldIdPath();
        this.table = table;
    }

    @Override
    public void generate(StringBuilder sql, DatabaseCaps caps) throws Exception {
        if (this.fieldDescriptor.getType() == DataType.DATE_TIME) {
            this.table.getDatabaseDescriptor().getDatabaseType().caps().formatDateTime(this.fieldDescriptor.getFormat(), this.field.alias + "." + this.fieldDescriptor.getRawName(), sql);
        } else {
            sql.append(this.field.alias).append('.').append(this.fieldDescriptor.getRawName());
        }
    }

    @Override
    public boolean isStringType() throws Exception {
        return DVFieldEvaliator.isStringable(this.fieldDescriptor.getType());
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    private TableDescriptor addPath(ArrayList<FieldLocation> path, TableDescriptor table, int fieldId, String alias) {
        FieldLocation loc = new FieldLocation();
        loc.tableId = table.getNodeId();
        loc.fieldId = fieldId;
        loc.alias = alias;
        path.add(loc);
        this.fieldDescriptor = table.getValidFieldDescriptor(fieldId, null);
        if (this.fieldDescriptor.getType() == DataType.DIRECTORY) {
            return TableDescriptor.get(this.fieldDescriptor.getReferenceId());
        }
        return table;
    }

    @Override
    public void afterLoad(DirectoriesCollection collection) throws IOException {
        int fieldId;
        int[] fieldIdPath;
        TableDescriptor t;
        ArrayList<FieldLocation> path = new ArrayList<FieldLocation>();
        if (((FieldTerm)this.term).getDatasourceId() == -1) {
            t = this.table;
            FieldLocation fl = this.paramPath.get(0);
            FieldDescriptor fd = this.table.getFieldDescriptor(fl.fieldId);
            if (fd.getType() == DataType.DIRECTORY) {
                fieldIdPath = Arrays.copyOf(this.fieldIdPath, this.fieldIdPath.length);
                fieldIdPath[0] = fl.fieldId;
            } else {
                fieldIdPath = Arrays.copyOfRange(this.fieldIdPath, 1, this.fieldIdPath.length);
            }
        } else {
            t = this.table;
            fieldIdPath = this.fieldIdPath;
        }
        int[] nArray = fieldIdPath;
        int n = nArray.length;
        for (int i = 0; i < n && (t = this.addPath(path, t, fieldId = nArray[i], collection.newAlias())) != null; ++i) {
        }
        this.field = collection.add(path);
    }
}

