/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.expr;

import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.expr.DVEvaluator;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.DirectoriesCollection;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constant;
import inform.agent.scripts.ScriptableValue;
import inform.agent.web.utils.TypedValue;
import java.io.IOException;

public class DVValueEvaluator
extends DVEvaluator {
    private final DataType dataType;
    private final ScriptableValue value;

    public DVValueEvaluator(ValueTerm term) {
        super(term);
        this.dataType = term.getType();
        this.value = new TypedValue(this.dataType, term.getValue());
    }

    public DVValueEvaluator(ConstantTerm term) {
        super(term);
        Constant c = term.getConstant();
        this.dataType = c.getDataType();
        this.value = c;
    }

    @Override
    public void afterLoad(DirectoriesCollection collection) throws IOException {
    }

    @Override
    public void generate(StringBuilder sql, DatabaseCaps caps) throws Exception {
        switch (this.dataType) {
            case DIRECTORY: 
            case FLOAT: 
            case INTERVAL: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                sql.append(caps.c_float2sql(ValueCaster.toDouble(this.value.getRawValue())));
            }
            case DATE_TIME: {
                sql.append(caps.c_dateTime2sql(ValueCaster.toDouble(this.value.getRawValue())));
            }
            case BOOLEAN: {
                sql.append(caps.c_bool2sql(ValueCaster.toBoolean(this.value.getRawValue())));
            }
            case INTEGER: {
                sql.append(ValueCaster.toInt(this.value.getRawValue()));
            }
            case BIG_NUMBER: 
            case STRING: 
            case UNICODE: {
                sql.append(caps.c_string2sql(ValueCaster.toString(this.value.getRawValue())));
            }
        }
    }

    @Override
    public boolean isStringType() throws Exception {
        return DVValueEvaluator.isStringable(this.dataType);
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.value.getIsIgnored();
    }
}

