/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.filters;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.Rowset;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.filters.BoundFilter;
import inform.agent.db.filters.Range;
import inform.agent.db.filters.bounds.Complex;
import inform.agent.db.filters.bounds.ComplexRightPadded;
import inform.agent.db.filters.bounds.Null;
import inform.agent.db.filters.bounds.Numeric;
import inform.agent.db.types.ValueCaster;

public abstract class RowFilter {
    public static BoundFilter.Bound bound(DatabaseCaps caps, int nullSortKind, FieldDescriptor field, int direction, Object v) {
        if (v == null) {
            return new Null(caps, nullSortKind, field.getIndex(), direction);
        }
        if (field.getType().isNumeric()) {
            return new Numeric(caps, nullSortKind, field.getIndex(), direction, ValueCaster.toNumber(v).doubleValue());
        }
        if (field.isRightPadded()) {
            return new ComplexRightPadded(caps, nullSortKind, field.getIndex(), direction, ValueCaster.toString(v));
        }
        return new Complex(caps, nullSortKind, field.getIndex(), direction, (Comparable)ValueCaster.getCastedValue(field.getType(), v));
    }

    public static RowFilter create(Rowset rowset, int nullSortKind, FieldDescriptor field, Object v0, Object v1, boolean ascending) {
        DatabaseCaps caps = rowset.getTableDescriptor().getDatabaseDescriptor().getDatabaseType().caps();
        BoundFilter.Bound b0 = RowFilter.bound(caps, nullSortKind, field, 1, v0);
        BoundFilter.Bound b1 = RowFilter.bound(caps, nullSortKind, field, -1, v1);
        return new BoundFilter(b0, b1, ascending);
    }

    public abstract int locate0(Rowset var1, int var2, int var3);

    public abstract int locate1(Rowset var1, int var2, int var3);

    public abstract Range apply(Rowset var1, Range var2);

    public static class Window
    extends RowFilter {
        private final Range clamp;

        public Window(Range clamp) {
            this.clamp = clamp;
        }

        @Override
        public int locate0(Rowset rs, int r0, int r1) {
            return Math.max(r0, this.clamp.first);
        }

        @Override
        public int locate1(Rowset rs, int r0, int r1) {
            return Math.min(r1, this.clamp.last);
        }

        @Override
        public Range apply(Rowset rs, Range r) {
            return r.intersect(this.clamp);
        }
    }
}

