/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CheckDatabaseCompatibility
extends Request {
    private static final int TAG_CDC_ENTRY_ID = 1;
    private static final int TAG_CDC_NODE_ID = 2;
    private static final int TAG_CDC_ETALON_DB = 3;
    private static final int TAG_CDC_INCOMPATIBLE_DB = 4;
    private static final int TAG_CDC_INCOMPATIBLE_ENTRIES = 5;

    public CheckDatabaseCompatibility(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        DoubleHash<CheckDB> databases = new DoubleHash<CheckDB>();
        TaggedReader in = this.createRequestContentReader();
        double etalonDbId = 0.0;
        while (in.next()) {
            this.idle();
            switch (in.getCurrentTag()) {
                case 1: {
                    int entryId = in.getInt();
                    double nodeId = in.getDouble(2);
                    CheckEntry entry = new CheckEntry(entryId, nodeId);
                    CheckDB db = (CheckDB)databases.get(entry.databaseId);
                    if (db == null) {
                        db = new CheckDB(entry.databaseId);
                        databases.add(db);
                    }
                    db.entries.add(entry);
                    break;
                }
                case 3: {
                    etalonDbId = in.getDouble();
                }
            }
        }
        if (etalonDbId == 0.0) {
            return;
        }
        Node node = MtdEngine.getNode(etalonDbId);
        if (node == null || node.getType() != 10) {
            return;
        }
        this.idle();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        DatabaseDescriptor etalonDb = ((DatabaseNode)node).getDescriptor();
        for (CheckDB db : databases) {
            DatabaseDescriptor databaseDescriptor;
            if (etalonDbId == db.databaseId || (node = MtdEngine.getNode(db.databaseId)) == null || node.getType() != 10 || DatabaseDescriptor.isCompatible(etalonDb, databaseDescriptor = ((DatabaseNode)node).getDescriptor())) continue;
            out.putDouble(4, db.databaseId);
            int[] entries = new int[db.entries.size()];
            int index = 0;
            for (CheckEntry e : db.entries) {
                entries[index++] = e.entryId;
            }
            out.putIntArray(5, entries);
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    private static class CheckDB
    implements DoubleHash.Entry {
        final double databaseId;
        final ArrayList<CheckEntry> entries = new ArrayList();

        private CheckDB(double databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public double key() {
            return this.databaseId;
        }
    }

    private static class CheckEntry {
        int entryId;
        Node node;
        double databaseId = 0.0;

        private CheckEntry(int entryId, double nodeId) throws IOException {
            this.entryId = entryId;
            this.node = MtdEngine.getNode(nodeId);
            if (this.node == null) {
                return;
            }
            TableDescriptor tableDescriptor = null;
            switch (this.node.getType()) {
                case 12: {
                    tableDescriptor = ((TableNode)this.node).getDescriptor();
                    break;
                }
                case 19: 
                case 49: {
                    double tableId = 0.0;
                    TaggedReader reader = new TaggedReader(new ByteArrayInputStream(MtdEngine.getNodeContent(nodeId)));
                    while (reader.getNextTag() != 0) {
                        if (reader.getCurrentTag() != 1) continue;
                        tableId = reader.getNodeID();
                        break;
                    }
                    if (tableId == 0.0) break;
                    tableDescriptor = TableDescriptor.getIfExists(tableId);
                    break;
                }
                case 48: {
                    double tableId = 0.0;
                    TaggedReader reader = new TaggedReader(new ByteArrayInputStream(MtdEngine.getNodeContent(nodeId)));
                    while (reader.getNextTag() != 0) {
                        if (reader.getCurrentTag() != 6) continue;
                        tableId = reader.getNodeID();
                        break;
                    }
                    if (tableId == 0.0) break;
                    tableDescriptor = TableDescriptor.getIfExists(tableId);
                }
            }
            if (tableDescriptor != null) {
                this.databaseId = tableDescriptor.getDbId();
            }
        }
    }
}

