/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.DeleteEngineException;
import inform.agent.db.connect.ConnectionManager;

public class CheckDeleteRow
extends Request {
    private static final int TAG_CHECKING_TABLE_ID = 1;
    private static final int TAG_CHECKING_ROWS = 2;
    private static final int TAG_DELETED_ROWS = 3;
    private static final int TAG_FAIL_ROW = 4;
    private static final int TAG_FAIL_MESSAGE = 5;
    private static final int TAG_CHECK_REFERENCES_MESSAGE = 6;
    private static final int TAG_FAIL_DETAILING = 7;
    private double userNodeId;

    public CheckDeleteRow(RequestHeader rq) {
        super(rq, RequestDuration.LONG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        double tableId = in.getDouble(1);
        double[] checkingRows = LittleEndian.toDoubleArray(in.getRaw(2));
        String checkReferencesMessage = null;
        if (in.getNextTag() == 6) {
            checkReferencesMessage = in.getAnsi();
        }
        double[] checked = new double[checkingRows.length];
        int checkedLength = 0;
        this.userNodeId = this.getUserID();
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:CheckDeleteRow");
        try {
            DeleteEngine deleteEngine = new DeleteEngine(null, connectionManager, null, this.userNodeId, this);
            deleteEngine.setCheckReferencesMessage(checkReferencesMessage);
            for (double rowId : checkingRows) {
                try {
                    deleteEngine.checkDeleteRow(tableId, rowId);
                    checked[checkedLength++] = rowId;
                }
                catch (DeleteEngineException e) {
                    Core.logger.error(null, e);
                    StringBuilder details = new StringBuilder();
                    for (String s : e.details()) {
                        details.append("\n ").append(s);
                    }
                    out.putDouble(4, rowId);
                    out.putAnsi(7, details.toString());
                    out.putAnsi(5, e.getMessage());
                    break;
                }
            }
            out.putRaw(3, LittleEndian.doubleArrayToBinary(checked, checkedLength));
            out.flush();
            this.sendResult(result.internalBuffer(), result.size());
        }
        finally {
            connectionManager.release();
        }
    }
}

