/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.Restructure;
import inform.agent.mtd.nodes.TableNode;
import java.util.ArrayList;

public class CheckTableStructure
extends Request {
    private static final int TAG_CTS_LOG = 1;

    public CheckTableStructure(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        double tableId = this.getNodeID();
        TableNode node = this.getNode(tableId, TableNode.class);
        int mask = this.security().accessMask(node);
        if ((mask & 0x40000000) == 0) {
            this.throwNodeAccessDenied(tableId, 0x40000000);
        }
        this.checkAccess(node, 0x40000000);
        TableDescriptor descriptor = node.getDescriptor();
        final ArrayList log = new ArrayList();
        Restructure.RealLogger logger = new Restructure.RealLogger(){

            @Override
            public void log(TableDescriptor context, String line) {
                super.log(context, line);
                log.add(line);
            }
        };
        try (DatabaseConnection connection = descriptor.getDatabaseDescriptor().connect(this, "rq:CheckTableStructure");){
            DbScheme scheme = connection.openScheme();
            try (Statement statement = connection.createStatement();){
                Restructure.updateTable(null, scheme, statement, descriptor, descriptor, logger, Restructure.Strategy.UPDATE);
            }
            connection.commit();
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        if (log.isEmpty()) {
            writer.putAnsi(1, "\u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c");
        } else {
            for (String msg : log) {
                writer.putAnsi(1, msg);
            }
        }
        writer.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

