/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbTable;
import inform.agent.db.schema.Restructure;
import inform.agent.mtd.nodes.TableNode;

public class DropTable
extends Request {
    public DropTable(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        double tableId = this.getNodeID();
        TableNode node = this.getNode(tableId, TableNode.class);
        this.checkAccess(node, 0x800000);
        TableDescriptor td = node.getDescriptor();
        if (td.urawnamed()) {
            throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438");
        }
        DatabaseDescriptor dd = DatabaseDescriptor.getDatabase(td.getDbId());
        try (DatabaseConnection connection = dd.connect(this, "rq:DropTable");){
            DbTable table = connection.openScheme().getTable(null, td.getRawName());
            if (table == null) {
                throw new InformException(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 [%s] \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0411\u0414", td.getRawName()));
            }
            try (Statement statement = connection.createStatement();){
                String tableName = table.fullName();
                table.drop(null, statement);
                Restructure.DDL_LOGGER.log(td, "\u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0438\u0437 \u0411\u0414 %s", tableName);
            }
            TableDataAudit audit = new TableDataAudit(this.ssContext, connection, this.getUserID(), 0.0, 0.0, 0.0, this.getSessionID());
            audit.registrateModification(td, 0.0, AuditModification.DROP_TABLE);
            audit.flush();
            connection.commit();
        }
        Core.logger.info("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b (node: {} user: {})", (Object)NumberConverter.doubleToString(tableId), (Object)NumberConverter.doubleToString(this.getUserID()));
        this.sendResult();
    }
}

