/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class GetDatabaseDrivers
extends Request {
    static final int TAG_DRIVER_NAME = 1;

    public GetDatabaseDrivers(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        HashSet<String> classes = new HashSet<String>();
        GetDatabaseDrivers.scanFolder(new File(Ini.HomePath, "jdbc"), classes);
        GetDatabaseDrivers.scanFolder(new File(Ini.RootPath, "lib"), classes);
        for (String s : classes) {
            writer.putAnsi(1, s);
        }
        writer.flush();
        this.sendResult(result.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFolder(File dir, Collection<String> drivers) throws IOException {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files != null) {
            for (File f : files) {
                try (JarFile jf = new JarFile(f);){
                    JarEntry je = jf.getJarEntry("META-INF/services/java.sql.Driver");
                    if (je == null) continue;
                    try (InputStream in = jf.getInputStream(je);){
                        StringBuilder tmp = new StringBuilder();
                        int c = 0;
                        while ((c = in.read()) >= 0) {
                            tmp.append((char)c);
                        }
                        drivers.add(tmp.toString().trim());
                    }
                }
            }
        }
    }
}

