/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.SortField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.Geometry;
import inform.agent.files.BFS;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.scripts.libs.MessageDigestOutputStream;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QuerySortFieldList;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class GetMD5
extends Request {
    public static final byte[] NULL = new byte[]{-16, 0, 15};
    static final int TAG_DIGEST_TABLE = 1;
    static final int TAG_NFIELDS = 2;
    static final int TAG_DIGEST_FIELD_CAPTION = 3;
    static final int TAG_DIGEST_FIELD_VALUE = 4;
    static final int TAG_DIGEST_FIELD_ID = 5;
    static final int TAG_DIGEST_RECORD_COUNT = 6;
    static final int TAG_MD5_ROW = 7;

    public GetMD5(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    public static byte[] blobMD5digest(ResultSet resultSet, FieldDescriptor fieldDescriptor, int fieldIndex) throws SQLException, IOException, NoSuchAlgorithmException {
        boolean isNull;
        byte[] bytes;
        if (fieldDescriptor.getType() == DataType.FILE) {
            String bp = resultSet.getString(fieldIndex);
            bytes = bp == null ? null : BFS.getFileBytes(fieldDescriptor, bp);
        } else {
            switch (fieldDescriptor.getBlobRawType()) {
                case TEXT: {
                    String clob = resultSet.getString(fieldIndex);
                    boolean isNull2 = resultSet.wasNull();
                    if (!isNull2) {
                        MessageDigest md5 = MessageDigest.getInstance("md5");
                        md5.update(clob.getBytes(TaggedWriter.ANSI));
                        return md5.digest();
                    }
                    return null;
                }
            }
            bytes = resultSet.getBlobBytes(fieldIndex);
        }
        boolean bl = isNull = bytes == null || resultSet.wasNull();
        if (!isNull) {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            md5.update(bytes);
            return md5.digest();
        }
        return null;
    }

    public static boolean blobMD5(ResultSet resultSet, FieldDescriptor fieldDescriptor, int fieldIndex, OutputStream out) throws SQLException, IOException, NoSuchAlgorithmException {
        byte[] bytes = GetMD5.blobMD5digest(resultSet, fieldDescriptor, fieldIndex);
        if (bytes == null) {
            return true;
        }
        out.write(bytes);
        return false;
    }

    public static byte[] geometryMD5digest(ResultSet resultSet, FieldDescriptor fieldDescriptor, int fieldIndex) throws SQLException, IOException, NoSuchAlgorithmException {
        boolean isNull;
        Geometry geometry = resultSet.getGeometry(fieldIndex);
        boolean bl = isNull = geometry == null;
        if (!isNull) {
            ByteArrayOutputStream wkb = new ByteArrayOutputStream();
            geometry.serializeWkb(wkb);
            MessageDigest md5 = MessageDigest.getInstance("md5");
            md5.update(wkb.internalBuffer(), 0, wkb.size());
            return md5.digest();
        }
        return null;
    }

    public static boolean geometryMD5(ResultSet resultSet, FieldDescriptor fieldDescriptor, int fieldIndex, OutputStream out) throws SQLException, IOException, NoSuchAlgorithmException {
        byte[] bytes = GetMD5.geometryMD5digest(resultSet, fieldDescriptor, fieldIndex);
        if (bytes == null) {
            return true;
        }
        out.write(bytes);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        int i;
        FieldDescriptor[] rsFields;
        LittleEndianDataOutputStream[] mdStreams;
        MessageDigest[] mdFields;
        TableDescriptor table = this.getNode(this.rq.nodeId, TableNode.class).getDescriptor();
        Query query = new Query((ServerSideHost)this, 0);
        query.createParameterizedTable(table.getNodeId());
        query.setBlobReceiving(2);
        List<FieldDescriptor> sortingFields = table.getPrimaryKeyFields();
        if (sortingFields.isEmpty()) {
            sortingFields = table.getFields();
        }
        QuerySortFieldList sorting = new QuerySortFieldList();
        for (FieldDescriptor f : sortingFields) {
            SortField sf = new SortField();
            sf.addField(f.getId());
            sorting.fields().add(sf);
        }
        query.setSortFields(sorting);
        String sql = query.generateSqlText(null, null);
        int[] digestMap = new int[table.getFields().size() + 1];
        for (int i2 = 0; i2 < digestMap.length; ++i2) {
            digestMap[i2] = -1;
        }
        int rcount = 0;
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(this, "rq:GetMD5");
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery(null);){
            FieldDescriptor f;
            ResultSetMetaData rsm = rs.getMetaData();
            int col_count = rsm.getColumnCount();
            mdFields = new MessageDigest[col_count];
            mdStreams = new LittleEndianDataOutputStream[col_count];
            rsFields = new FieldDescriptor[col_count];
            FieldDescriptor pkField = table.getRecordIdField();
            for (i = 0; i < rsm.getColumnCount(); ++i) {
                f = table.getField(rsm.getColumnLabel(i + 1));
                if (f == null) continue;
                digestMap[f.getIndex() + 1] = i;
                mdFields[i] = MessageDigest.getInstance("md5");
                mdStreams[i] = new LittleEndianDataOutputStream(new MessageDigestOutputStream(mdFields[i]));
                rsFields[i] = f;
            }
            while (rs.next()) {
                block21: for (int ci = 1; ci <= col_count; ++ci) {
                    f = rsFields[ci - 1];
                    if (f == null) continue;
                    LittleEndianDataOutputStream mds = mdStreams[ci - 1];
                    assert (mds != null);
                    boolean isNull = false;
                    switch (f.getType()) {
                        case BOOLEAN: {
                            int intVal = rs.getAsInteger(ci);
                            isNull = rs.wasNull();
                            if (isNull) break;
                            mds.writeBoolean(intVal != 0);
                            break;
                        }
                        case INTEGER: {
                            int intVal = rs.getAsInteger(ci);
                            isNull = rs.wasNull();
                            if (isNull) break;
                            mds.writeInt(intVal);
                            break;
                        }
                        case PRIMARY_KEY: 
                        case FLOAT: 
                        case DATE_TIME: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: {
                            double doubleVal = rs.getAsDouble(ci);
                            isNull = rs.wasNull();
                            if (isNull) break;
                            mds.writeDouble(doubleVal);
                            break;
                        }
                        case STRING: 
                        case BIG_NUMBER: 
                        case UNICODE: {
                            String stringVal = rs.getString(ci);
                            isNull = rs.wasNull();
                            if (isNull) break;
                            mds.writeUTF8(stringVal);
                            break;
                        }
                        case BLOB: 
                        case FILE: {
                            isNull = GetMD5.blobMD5(rs, f, ci, mds);
                            break;
                        }
                        case GEOMETRY: {
                            isNull = GetMD5.geometryMD5(rs, f, ci, mds);
                            break;
                        }
                        default: {
                            mdFields[ci - 1] = null;
                            rsFields[ci - 1] = null;
                            continue block21;
                        }
                    }
                    if (!isNull) continue;
                    mds.write(NULL);
                }
                if ((++rcount & 0xFF) != 0) continue;
                this.putRequestStateText("\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + rcount);
            }
        }
        int fcnt = 0;
        MessageDigest mdTable = MessageDigest.getInstance("md5");
        byte[][] digests = new byte[mdFields.length][];
        for (int i3 = 0; i3 < digestMap.length; ++i3) {
            MessageDigest md;
            int index = digestMap[i3];
            if (index < 0 || (md = mdFields[index]) == null) continue;
            mdStreams[index].flush();
            digests[index] = md.digest();
            mdTable.update(digests[index]);
            ++fcnt;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putAnsi(1, Strings.bytes2hex(mdTable.digest()));
        out.putInt32(2, fcnt);
        out.putInt32(6, rcount);
        for (i = 0; i < digestMap.length; ++i) {
            FieldDescriptor f;
            int index = digestMap[i];
            if (index < 0 || (f = rsFields[index]) == null) continue;
            int fid = f.getId();
            out.putInt32(5, fid);
            Object fcap = f.getCaption();
            if (fcap == null) {
                fcap = fid == -1 ? "\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447" : "?" + fid;
            }
            out.putAnsi(3, (String)fcap);
            out.putAnsi(4, Strings.bytes2hex(digests[index]));
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

