/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.nodes.DatabaseNode;
import java.util.Map;

public class GetNonImportedTables
extends Request {
    public static final int TAG_TABLE_NAME = 1;
    public static final int TAG_DESCR_TABLE_DESCRIPTION = 2;
    public static final int TAG_DESCR_FIELD_HEADER = 3;
    public static final int TAG_DESCR_FIELD_NAME = 4;
    public static final int TAG_DESCR_FIELD_DESCRIPTION = 5;

    public GetNonImportedTables(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        DatabaseNode db = (DatabaseNode)this.getNode(this.rq.nodeId);
        try (DatabaseConnection connection = db.getDescriptor().connect(this, "rq:GetNonImportedTables");){
            DbScheme scheme = connection.openScheme();
            Map<String, DbTable> tables = scheme.getAllTables(null);
            try (DatabaseConnection meta_connection = DatabaseDescriptor.getMetabase().connect(this, "rq:GetNonImportedTables");){
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT ").append("RAW_CONTENT").append(" FROM ").append(MetadataNodeReader.mtdTreeTableName).append(" WHERE ").append("NODE_TYPE").append(" = ").append(12).append("   AND ").append("PARENT_ID").append(" <> ").append(1.0);
                try (PreparedStatement statement = meta_connection.prepareStatement(sql.toString());
                     ResultSet resultSet = statement.executeQuery(null);){
                    while (resultSet.next()) {
                        BlobStream blob = resultSet.getBlobStream(1);
                        if (blob == null) continue;
                        TaggedReader reader = new TaggedReader(blob);
                        while (reader.getNextTag() != 0) {
                            block4 : switch (reader.getCurrentTag()) {
                                case 23: {
                                    String raw_name = reader.getAnsi();
                                    for (String dt_name : tables.keySet()) {
                                        if (raw_name.compareToIgnoreCase(dt_name) != 0) continue;
                                        tables.remove(dt_name);
                                        break block4;
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            for (Map.Entry<String, DbTable> e : tables.entrySet()) {
                out.putAnsi(1, e.getKey().toUpperCase());
                for (DbColumn c : e.getValue().getColumns(null).values()) {
                    ByteArrayOutputStream _out = new ByteArrayOutputStream();
                    LittleEndianDataOutputStream los = new LittleEndianDataOutputStream(_out);
                    los.writeInt(c.getType().getTypeId());
                    los.writeInt(c.getSize());
                    los.writeInt(c.isNullable() ? 0 : 1);
                    los.writeInt(0);
                    los.flush();
                    out.putRaw(3, _out.toByteArray());
                    out.putAnsi(4, c.name());
                }
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

