/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.DateTime;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.connect.RequestMonitor;
import inform.agent.scripts.SSContext;

public class GetRequestMonitor
extends Request {
    public static final int TAG_SSRQM_FILTER_RQ_NO = 1;
    public static final int TAG_SSRQM_FILTER_RQ_TYPE = 2;
    public static final int TAG_SSRQM_FILTER_SESSION_ID = 3;
    public static final int TAG_SSRQM_FILTER_USER_ID = 4;
    public static final int TAG_SSRQM_FILTER_UID = 5;
    public static final int TAG_SSRQM_FILTER_START_TIME = 6;
    public static final int TAG_SSRQM_FILTER_END_TIME = 7;
    public static final int TAG_SSRQM_RESULT_ITEM = 8;
    public static final int TAG_SSRQM_FILTER_OWNER_ID = 9;
    public static final int TAG_SSRQM_FILTER_NODE_ID = 10;
    public static final int TAG_SSRQM_FILTER_CONTEXT_TYPE = 11;

    public GetRequestMonitor(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        RequestMonitor.Stat[] stats;
        IntegerSet rqNo = null;
        IntegerSet rqType = null;
        DoubleSet sessionId = null;
        DoubleSet userId = null;
        DoubleSet ownerId = null;
        DoubleSet nodeId = null;
        IntegerSet uid = null;
        double startTime = 0.0;
        double endTime = 0.0;
        boolean allStats = true;
        TaggedReader in = this.createRequestContentReader();
        boolean web = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    if (rqNo == null) {
                        rqNo = new IntegerSet();
                    }
                    rqNo.add(in.getInt());
                    allStats = false;
                    break;
                }
                case 2: {
                    if (rqType == null) {
                        rqType = new IntegerSet();
                    }
                    rqType.add(in.getInt());
                    allStats = false;
                    break;
                }
                case 3: {
                    if (sessionId == null) {
                        sessionId = new DoubleSet();
                    }
                    sessionId.add(in.getDouble());
                    allStats = false;
                    break;
                }
                case 4: {
                    if (userId == null) {
                        userId = new DoubleSet();
                    }
                    userId.add(in.getDouble());
                    allStats = false;
                    break;
                }
                case 5: {
                    if (uid == null) {
                        uid = new IntegerSet();
                    }
                    uid.add(in.getInt());
                    allStats = false;
                    break;
                }
                case 6: {
                    startTime = DateTime.toServerTime(in.getDouble(), this);
                    allStats = true;
                    break;
                }
                case 7: {
                    endTime = DateTime.toServerTime(in.getDouble(), this);
                    allStats = false;
                    break;
                }
                case 9: {
                    if (ownerId == null) {
                        ownerId = new DoubleSet();
                    }
                    ownerId.add(in.getDouble());
                    allStats = false;
                    break;
                }
                case 10: {
                    if (nodeId == null) {
                        nodeId = new DoubleSet();
                    }
                    nodeId.add(in.getDouble());
                    allStats = false;
                    break;
                }
                case 11: {
                    web = in.getInt() == 4;
                }
            }
        }
        RequestResult result = new RequestResult(this, 0x400000);
        TaggedWriter out = result.getWriter();
        for (RequestMonitor.Stat s : stats = RequestMonitor.getRequests()) {
            SSContext r;
            result.sendChunkIf(0x100000);
            if (allStats) {
                s.storeAs(8, out);
                continue;
            }
            if (s.context == null || (web ? (r = s.context.webContext()) == null || rqNo != null && !rqNo.contains(r.requestNo) || rqType != null && !rqType.contains(r.requestType) || sessionId != null && !sessionId.contains(r.sessionId) || userId != null && !userId.contains(r.userId) || uid != null && !uid.contains(r.uid) || startTime != 0.0 && startTime < r.createTime || endTime != 0.0 && endTime >= r.createTime || ownerId != null && r.ownerId != 0.0 && !ownerId.contains(r.ownerId) || nodeId != null && !nodeId.contains(r.nodeId) : (r = s.context.requestContext()) == null || rqNo != null && !rqNo.contains(((SSContext.Request)r).requestNo) || rqType != null && !rqType.contains(((SSContext.Request)r).requestType) || sessionId != null && !sessionId.contains(((SSContext.Request)r).sessionId) || userId != null && !userId.contains(((SSContext.Request)r).userId) || uid != null && !uid.contains(((SSContext.Request)r).uid) || startTime != 0.0 && startTime < ((SSContext.Request)r).createTime || endTime != 0.0 && endTime >= ((SSContext.Request)r).createTime || ownerId != null && !ownerId.contains(((SSContext.Request)r).ownerId) || nodeId != null && !nodeId.contains(((SSContext.Request)r).nodeId))) continue;
            s.storeAs(8, out);
        }
        result.sendResult();
    }
}

