/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.mtd.nodes.TableNode;

public class GetSqlForTable
extends Request {
    public GetSqlForTable(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        TableDescriptor td = null;
        double table = this.getNodeID();
        if (table != 0.0) {
            TableNode node = this.getNode(table, TableNode.class);
            td = node.getDescriptor();
        } else {
            td = new TableDescriptor(0.0, this.getRequestContent());
        }
        String sql = "";
        if (td.getKind() == TableDescriptor.Kind.VIEW) {
            sql = td.getSqlForView();
        } else {
            try (DatabaseConnection connection = td.getDatabaseDescriptor().connect(this, "rq:GetSqlForTable");){
                DbScheme scheme = connection.openScheme();
                sql = scheme.getSqlForTable(td, new DbTable(scheme.toCaseIfNeed(td.getRawName()), scheme));
            }
        }
        if (!sql.isEmpty()) {
            writer.putAnsi(25, sql);
        }
        writer.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

