/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import java.io.IOException;

public class LinksLookup
extends Request {
    public static final int LLK_LEFT = 0;
    public static final int LLK_RIGHT = 1;
    public static final String PHX_LINKED = "PHX_LINKED";
    public static final String PHX_ELEMENTS = "PHX_ELEMENTS";
    public static final String[] SYSTEM_TABLES = new String[]{"PHX_ELEMENTS", "PHX_LINKED"};
    public static final int TAG_LINKS_TABLE = 0;
    public static final int TAG_LINKS_L_TABLE_ID = 2;
    public static final int TAG_LINKS_L_ROW_ID = 3;
    public static final int TAG_LINKS_R_TABLE_ID = 4;
    public static final int TAG_LINKS_R_ROW_ID = 5;
    public static final int TAG_LINKS_TABLE_ID = 6;
    public static final int TAG_LINKS_ROW_ID = 7;
    public static final int TAG_LINKS_DATA_LINK = 8;
    public static final int TAG_LINKS_REL_FEILD_ID = 10;
    public static final int TAG_LINKS_MASTER_PRI_KEY = 11;
    public static final int TAG_LINKS_NULL_VAL = 12;
    public static final int TAG_LINKS_INTEGER_VAL = 13;
    public static final int TAG_LINKS_DOUBLE_VAL = 14;
    public static final int TAG_LINKS_STIRNG_VAL = 15;
    public static final int TAG_LINKS_DATETIME_VAL = 16;
    public static final int TAG_LINKS_RECORD_FIELDS = 17;
    private int kind;

    public LinksLookup(RequestHeader rq, int kind) {
        super(rq, RequestDuration.DATA_ACCESS);
        this.kind = kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:LinksLookup");
        try (DatabaseConnection connection = connectionManager.getConnection(this.getNodeID(), "rq:LinksLookup");){
            String sql = this.kind == 0 ? this.createLinksLookupParentsSQL(connection, in) : this.createLinksLookupChildsSQL(connection, in);
            try (PreparedStatement stmt = connection.prepareStatement(sql);
                 ResultSet resultSet = stmt.executeQuery(null);){
                while (resultSet.next()) {
                    writer.putDouble(6, resultSet.getDouble(1));
                    double row_id = 0.0;
                    if (resultSet.getMetaData().getColumnCount() == 2) {
                        row_id = resultSet.getDouble(2);
                    }
                    writer.putDouble(7, row_id);
                }
            }
        }
        writer.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    private String createLinksLookupParentsSQL(DatabaseConnection connection, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        Object result = "";
        int links_table = in.getInt(0);
        double lnk_table_id = in.getDouble(4);
        double lnk_row_id = in.getDouble(5);
        result = "select TABLE_ID,RECORD_ID from ";
        result = (String)result + connection.getDescriptor().getScheme() + "." + SYSTEM_TABLES[links_table];
        result = (String)result + " where LNK_TABLE_ID=" + lnk_table_id + " and LNK_RECORD_ID=" + lnk_row_id;
        return result;
    }

    private String createLinksLookupChildsSQL(DatabaseConnection connection, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        double element_table_id;
        TableDescriptor tDesc;
        Object result = "";
        int links_table = in.getInt(0);
        double table_id = in.getDouble(2);
        double row_id = in.getDouble(3);
        if (in.getCurrentTag() == 4 && (tDesc = new TableDescriptor(element_table_id = in.getDouble(), false)).hasStandartPrimaryKey()) {
            result = "select distinct L.LNK_TABLE_ID from ";
            result = (String)result + connection.getDescriptor().getScheme() + "." + SYSTEM_TABLES[links_table];
            result = (String)result + String.format(" L, %s T where L.TABLE_ID=%s and L.RECORD_ID=%s  and T.%s=L.LNK_RECORD_ID ", tDesc.getRawName(), table_id, row_id, tDesc.getPrimaryKeyFields().get(0).getRawName());
            return result;
        }
        result = "select distinct LNK_TABLE_ID from ";
        result = (String)result + connection.getDescriptor().getScheme() + "." + SYSTEM_TABLES[links_table];
        result = (String)result + " where TABLE_ID=" + table_id + " and RECORD_ID=" + row_id;
        return result;
    }
}

