/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;
import java.util.ArrayList;

public class PivotConf
extends Request {
    public static final int TAG_PCR_GET_CONFIG = 1;
    public static final int TAG_PCR_SET_CONFIG = 2;
    public static final int TAG_PCR_DEL_CONFIG = 3;
    public static final int TAG_PCR_CONFIG = 4;
    public static final int TAG_PCR_DISABLED = 5;
    public static final int TAG_PCR_RENAME_CONFIG = 7;
    public static final int TAG_PCR_NEW_NAME = 8;
    public static final int TAG_PCR_RESORT = 9;
    public static final int TAG_PCR_DEF_CONF = 10;
    public static final int TAG_PF_CONF_ID = 1;
    public static final int TAG_PF_USER_ID = 2;
    public static final int TAG_PF_OWNER_ID = 3;
    public static final int TAG_PF_CONTROL_ID = 4;
    public static final int TAG_PF_NAME = 5;
    public static final int TAG_PF_CONTENT = 6;
    public static final int TAG_PF_SORT = 7;
    public static final int TAG_PF_DEF_CONF = 8;

    public PivotConf(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        AuditJournal pivotConf = AuditJournal.createPivotConfJournal();
        if (!pivotConf.isEnabled()) {
            out.putEmpty(5);
        } else {
            TaggedReader in = this.createRequestContentReader();
            block24: while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        TaggedReader stream = in.getStreamReader();
                        AuditJournal.PivotConfParam param = new AuditJournal.PivotConfParam();
                        param.userId = this.getUserID();
                        while (stream.next()) {
                            switch (stream.getCurrentTag()) {
                                case 1: {
                                    param.configId = stream.getDouble();
                                    break;
                                }
                                case 2: {
                                    param.userId = stream.getDouble();
                                    break;
                                }
                                case 3: {
                                    param.formId = stream.getDouble();
                                    break;
                                }
                                case 4: {
                                    param.controlId = stream.getDouble();
                                }
                            }
                        }
                        Object config = pivotConf.readPivotConfig(this.ssContext, param);
                        if (!pivotConf.isEnabled()) break;
                        if (config == null) continue block24;
                        for (Object f : config) {
                            ByteArrayOutputStream r = new ByteArrayOutputStream();
                            TaggedWriter s = new TaggedWriter(r);
                            s.putDouble(1, ((AuditJournal.PivotConf)f).recordID);
                            s.putDouble(2, ((AuditJournal.PivotConf)f).userId);
                            s.putDouble(3, ((AuditJournal.PivotConf)f).formId);
                            s.putDouble(4, ((AuditJournal.PivotConf)f).controlId);
                            s.putString(5, ((AuditJournal.PivotConf)f).name);
                            s.putRaw(6, ((AuditJournal.PivotConf)f).content);
                            s.putDouble(7, ((AuditJournal.PivotConf)f).sort);
                            s.putBool(8, ((AuditJournal.PivotConf)f).defConf);
                            s.flush();
                            out.putRaw(4, r.internalBuffer(), r.size());
                        }
                        break;
                    }
                    case 2: {
                        TaggedReader stream = in.getStreamReader();
                        AuditJournal.PivotConf f = new AuditJournal.PivotConf();
                        f.userId = this.getUserID();
                        while (stream.next()) {
                            switch (stream.getCurrentTag()) {
                                case 1: {
                                    f.recordID = stream.getDouble();
                                    break;
                                }
                                case 2: {
                                    f.userId = stream.getDouble();
                                    break;
                                }
                                case 3: {
                                    f.formId = stream.getDouble();
                                    break;
                                }
                                case 4: {
                                    f.controlId = stream.getDouble();
                                    break;
                                }
                                case 5: {
                                    f.name = stream.getString();
                                    break;
                                }
                                case 6: {
                                    f.content = stream.getRaw();
                                    break;
                                }
                                case 7: {
                                    f.sort = stream.getDouble();
                                    break;
                                }
                                case 8: {
                                    f.defConf = stream.getBoolean();
                                }
                            }
                        }
                        pivotConf.storePivotConf(this.ssContext, f, this);
                        break;
                    }
                    case 3: {
                        Object config = LittleEndian.toDoubleArray(in.getRaw());
                        pivotConf.deletePivotConfig(this.ssContext, (double[])config, this);
                        break;
                    }
                    case 7: {
                        double recordID = in.getDouble();
                        String name = in.getString(8);
                        pivotConf.renamePivotConf(this.ssContext, recordID, name, this);
                        break;
                    }
                    case 9: {
                        Object config = new ArrayList();
                        TaggedReader stream = in.getStreamReader();
                        while (stream.next()) {
                            AuditJournal.PivotConf f = new AuditJournal.PivotConf();
                            f.recordID = stream.getDouble(1);
                            f.sort = stream.getDouble(7);
                            ((ArrayList)config).add(f);
                        }
                        AuditJournal.PivotConf[] pivotConfig = new AuditJournal.PivotConf[((ArrayList)config).size()];
                        pivotConf.updatePivotConfigSorting(this.ssContext, ((ArrayList)config).toArray(pivotConfig), this);
                        break;
                    }
                    case 10: {
                        AuditJournal.PivotConf f;
                        TaggedReader stream = in.getStreamReader();
                        while (stream.next()) {
                            f = new AuditJournal.PivotConf();
                            double recordID = stream.getDouble(1);
                            boolean defConf = stream.getBoolean(8);
                            pivotConf.setDefPivotConf(this.ssContext, recordID, defConf);
                        }
                        break;
                    }
                }
                if (pivotConf.isEnabled()) continue;
                out.putEmpty(5);
                break;
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

