/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.nodes.DatabaseNode;

public class QuickDBIndicesCheck
extends Request {
    public QuickDBIndicesCheck(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        DatabaseNode db = (DatabaseNode)this.getNode(this.getNodeID());
        DatabaseDescriptor dd = db.getDescriptor();
        try (DatabaseConnection conn = dd.connect(this, "rq:QuickDBIndicesCheck");){
            DatabaseCaps caps = db.getDescriptor().getDatabaseType().caps();
            try (PreparedStatement stmt = conn.prepareStatement(caps.getIndexesValidationSql());){
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                try (ResultSet rs = stmt.executeQuery(null);){
                    String oldT_name = "";
                    TaggedWriter writer = new TaggedWriter(result);
                    while (rs.next()) {
                        String i_name = rs.getString(1);
                        String t_name = rs.getString(2);
                        if (!t_name.equals(oldT_name)) {
                            writer.putAnsi(23, t_name);
                            oldT_name = t_name;
                        }
                        writer.putAnsi(5, i_name);
                    }
                    writer.flush();
                }
                this.sendResult(result.internalBuffer(), result.size());
            }
        }
    }
}

