/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.DBConf;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.Security;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;

public class SetDBContentWithDBConf
extends Request {
    private static final int TAG_DBCONTENT_CONF_DISPOSIBLE_KEY = 1;
    private static final int TAG_DBCONTENT_CONF_SALT = 2;
    private static final int TAG_DBCONTENT_CONF_HASH = 3;
    long contentStamp;
    byte[] verifiedContent;
    byte[] salt;
    byte[] hash;
    byte[] disposibleKey;

    public SetDBContentWithDBConf(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    @Override
    public void execute() throws Throwable {
        double nodeId = this.getNodeID();
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", nodeId);
        }
        if (!(node instanceof DatabaseNode)) {
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", nodeId);
        }
        this.checkAccess(node, 0x40000000);
        node.lockBarrier(this.getSessionID());
        ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
        TaggedWriter conttentWriter = new TaggedWriter(contentStream);
        TaggedReader in = this.createRequestContentReader();
        String confName = null;
        boolean verified = false;
        this.contentStamp = 0L;
        block9: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 17: {
                    confName = in.getString();
                    conttentWriter.putString(17, confName);
                    continue block9;
                }
                case 18: {
                    verified = true;
                    continue block9;
                }
                case 19: {
                    this.contentStamp = in.getLong();
                    continue block9;
                }
            }
            in.transferTag(conttentWriter);
        }
        if (Strings.isVoid(confName)) {
            MtdEngine.setNodeContent(this.getSSContext(), this, this.getNodeID(), this.contentStamp, this.getRequestContent(), null, this.getUserID(), this.getSessionID(), this.security());
            this.sendResult();
            return;
        }
        this.idle();
        in = new TaggedReader(MtdEngine.getNodeContent(nodeId));
        String dbConfName = null;
        boolean dbVerified = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 17: {
                    dbConfName = in.getString();
                    break;
                }
                case 18: {
                    dbVerified = true;
                }
            }
        }
        if (!dbVerified) {
            verified = false;
        }
        if (!Strings.equals(confName, dbConfName)) {
            verified = false;
        }
        if (verified) {
            MtdEngine.setNodeContent(this.getSSContext(), this, this.getNodeID(), this.contentStamp, this.getRequestContent(), null, this.getUserID(), this.getSessionID(), this.security());
            this.sendResult();
            return;
        }
        this.idle();
        DBConf conf = new DBConf(confName);
        this.idle();
        this.disposibleKey = Security.generateSalt();
        this.salt = Security.generateSalt();
        this.hash = Security.calculateH1(confName.toUpperCase(), conf.password, this.salt);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putRaw(1, this.disposibleKey);
        out.putRaw(2, this.salt);
        out.flush();
        this.idle();
        conttentWriter.putEmpty(18);
        conttentWriter.flush();
        this.verifiedContent = contentStream.toByteArray();
        this.idle();
        this.setChunkedInput();
        this.sendChunk(result.internalBuffer(), result.size());
        this.idle();
        this.processChunkedInput();
    }

    @Override
    protected void processInputChunk(byte[] chunk) throws Throwable {
        TaggedReader in = new TaggedReader(chunk);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 3: {
                    byte[] clientHash = in.getRaw();
                    byte[] calcHash = Security.calculateH2(this.hash, this.disposibleKey);
                    if (!Security.isHashEquals(calcHash, clientHash)) {
                        throw new InformException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                    }
                    MtdEngine.setNodeContent(this.getSSContext(), this, this.getNodeID(), this.contentStamp, this.verifiedContent, null, this.getUserID(), this.getSessionID(), this.security());
                    this.sendResult();
                }
            }
        }
    }
}

