/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SqlGenerator;
import inform.agent.db.sql.QueryTokenizer;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.GetQueryNodeSql;

public class SqlRepresentation
extends Request {
    public SqlRepresentation(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double tableNodeId = 0.0;
        boolean inlineParams = false;
        String sqlText = "";
        double databaseId = 0.0;
        SqlGenerator.Method method = SqlGenerator.Method.DEFAULT;
        int databaseTypeId = -500;
        int generatorType = 0;
        ByteArrayOutputStream searchContent = new ByteArrayOutputStream();
        TaggedWriter searchWriter = new TaggedWriter(searchContent);
        block8: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 5: {
                    tableNodeId = in.getDouble();
                    searchWriter.putDouble(5, tableNodeId);
                    continue block8;
                }
                case 30: {
                    inlineParams = true;
                    searchWriter.putEmpty(30);
                    continue block8;
                }
                case 52: {
                    method = SqlGenerator.Method.fromInt(in.getInt());
                    continue block8;
                }
                case 53: {
                    generatorType = in.getInt();
                    continue block8;
                }
                case 54: {
                    databaseId = in.getDouble();
                    continue block8;
                }
                case 55: {
                    databaseTypeId = in.getInt();
                    continue block8;
                }
            }
            in.transferTag(searchWriter);
        }
        if (generatorType == 0) {
            this.sendResult();
            return;
        }
        searchWriter.flush();
        if (generatorType == 506) {
            GetQueryNodeSql gqns = new GetQueryNodeSql(this.getNodeID(), this.client());
            gqns.setRequestContent(searchContent.toByteArray());
            gqns.execute();
            sqlText = QueryTokenizer.formatInsensitiveText(gqns.getSql());
        } else {
            GeneratedSql sql;
            Object node = this.getNode(tableNodeId);
            if (AccessMask.accessDenied(0x4000000, this.security().accessMask((Node)node))) {
                this.sendResult();
                return;
            }
            SqlGenerator sqlGenerator = new SqlGenerator(this, this);
            sqlGenerator.setTableId(tableNodeId);
            if (databaseId != 0.0) {
                sqlGenerator.setDatabaseId(databaseId);
            }
            if ((sql = sqlGenerator.getGeneratedSql(method, databaseTypeId, searchContent.toByteArray())).isHasError()) {
                throw new InformException(sql.getError()).detail(sql.getErrorDetailing());
            }
            sqlText = sql.formatInsensitiveSql(inlineParams);
        }
        ByteArrayOutputStream resultContent = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(resultContent);
        out.putAnsi(25, sqlText);
        out.flush();
        this.sendResult(resultContent.internalBuffer(), resultContent.size());
    }
}

