/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.SqlGenerator;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;

public class TransformToQuery
extends Request {
    private static final int TAG_TRANS_FIND_ID = 1;
    private static final int TAG_TRANS_NODE_ID = 2;

    public TransformToQuery(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        TaggedReader in = this.createRequestContentReader();
        double searchId = 0.0;
        double queryId = 0.0;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    searchId = in.getDouble();
                    break;
                }
                case 2: {
                    queryId = in.getDouble();
                }
            }
        }
        if (searchId == 0.0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u043f\u043e\u0438\u0441\u043a\u0430");
        }
        if (queryId == 0.0) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        try (Connector.Metabase connector = new Connector.Metabase();){
            BasicNode node = MtdEngine.getValidNode(queryId).getRealNode();
            node.lockBarrier(this.getSessionID());
            TaggedReader gIn = new TaggedReader(SqlGenerator.transformToQuery(searchId));
            byte[] content = null;
            while (gIn.next()) {
                switch (gIn.getCurrentTag()) {
                    case 1: {
                        throw new InformException(gIn.getAnsi());
                    }
                    case 6: {
                        content = gIn.getRaw();
                    }
                }
            }
            if (content != null) {
                this.sendResult(content, content.length);
            }
        }
    }
}

