/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbObject;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DbIndex
extends DbObject {
    protected DbTable table;
    protected boolean unique;
    protected boolean valid = true;
    protected List<DbColumn> columns = new ArrayList<DbColumn>();
    protected List<String> raw_columns = new ArrayList<String>();

    public DbIndex(String name, DbTable table) {
        super(name);
        this.table = table;
    }

    @Override
    public String fullName() {
        DbTable parent = this.getParent();
        return parent == null ? this.name() : parent.toFullName(this.name);
    }

    @Override
    protected void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        statement.execute(ssContext, "DROP INDEX " + this.fullName());
    }

    public List<DbColumn> getColumns() {
        return this.columns;
    }

    public List<String> getRawColumns() {
        return this.raw_columns;
    }

    protected boolean columnsEquals(IndexDescriptor id) {
        ArrayList<String> tcols = new ArrayList<String>(this.columns.size());
        for (DbColumn c : this.columns) {
            tcols.add(c.name());
        }
        DbScheme scheme = this.scheme();
        ArrayList<String> ocols = new ArrayList<String>(id.getFields().size());
        for (FieldDescriptor fd : id.getFields()) {
            ocols.add(scheme.toCaseIfNeed(fd.getRawName()));
        }
        return tcols.equals(ocols);
    }

    public boolean equals(IndexDescriptor id) {
        return this.unique == id.isUnique() && this.columnsEquals(id);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isBitmap() {
        return false;
    }

    public boolean isClustered() {
        return false;
    }

    public int getCompressedFields() {
        return 0;
    }

    @Override
    public DbTable getParent() {
        return this.table;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isUsageBitmap() {
        return false;
    }

    public boolean isUsageClustered() {
        return false;
    }

    public boolean isUsageCompressedFields() {
        return false;
    }
}

