/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbColumnable;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbObject;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;

public class DbTable
extends DbColumnable {
    private static final String CHECK_IDX_SQL = "SELECT STATUS FROM ALL_INDEXES WHERE INDEX_NAME = '%s' AND TABLE_NAME = '%s'";
    private Map<String, DbIndex> indexes;

    public DbTable(String name, DbScheme scheme) {
        super(name, scheme);
    }

    public final Map<String, DbIndex> getIndexes(SSContext ssContext) throws SQLException {
        if (this.indexes == null) {
            this.indexes = this.internalGetIndexes(ssContext);
        }
        return this.indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, DbIndex> internalGetIndexes(SSContext ssContext) throws SQLException {
        HashMap<String, DbIndex> indexes = new HashMap<String, DbIndex>();
        if (this.scheme.connection != null) {
            String sch = this.scheme.name;
            try (java.sql.ResultSet rs = this.scheme.metadata.getIndexInfo(null, Strings.isVoid(sch) ? null : Strings.unquote(sch), Strings.unquote(this.name()), false, true);){
                while (rs.next()) {
                    boolean unique;
                    boolean bl = unique = !rs.getBoolean("NON_UNIQUE");
                    String iname = rs.getString("INDEX_NAME");
                    if (iname == null) continue;
                    DbIndex idx = indexes.get(iname = this.scheme.nameFromDb(iname));
                    if (idx == null) {
                        idx = this.newIndexObject(iname, rs.getShort("TYPE"), rs.getString("FILTER_CONDITION"));
                        idx.unique = unique;
                        indexes.put(idx.name, idx);
                    }
                    int pos = rs.getInt("ORDINAL_POSITION") - 1;
                    String cname = this.scheme.nameFromDb(rs.getString("COLUMN_NAME"));
                    idx.getColumns().add(pos, this.getColumns(ssContext).get(cname));
                    if (!this.scheme.connection.getDescriptor().getDatabaseType().isOracle()) continue;
                    try (PreparedStatement stmt = this.scheme.connection.prepareStatement(String.format(CHECK_IDX_SQL, idx.name, this.name));
                         ResultSet results = stmt.executeQuery(ssContext);){
                        if (!results.next()) continue;
                        idx.setValid(results.getString(1).equals("VALID"));
                    }
                }
            }
        }
        return indexes;
    }

    public final DbColumn getColumn(SSContext ssContext, String name) throws SQLException {
        return this.getColumns(ssContext).get(this.scheme.toCaseIfNeed(name));
    }

    public final DbColumn createColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException, InformException {
        name = this.scheme.toCaseIfNeed(name);
        if (this.getColumns(ssContext).get(name) != null) {
            throw new InformException(String.format("Column with name [%s] already exists", name));
        }
        DbColumn result = this.newColumn(ssContext, statement, name, type, brt, size, nullable, fd);
        result.setSqlTypeName(this.scheme.ct2sql(fd));
        result.log("CREATED");
        this.columns.put(result.name, result);
        return result;
    }

    public void addForeignKey(SSContext ssContext, Statement statement, String fieldName, FieldDescriptor fd) throws SQLException {
        TableDescriptor fkDir;
        TableDescriptor tableDescriptor = fkDir = fd == null ? null : fd.foreignKeyDir();
        if (fkDir != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("ALTER TABLE ").append(this.fullName()).append(" ADD CONSTRAINT ").append(this.scheme.getForeignKeyRawName(this.name(), fieldName, fd)).append(" FOREIGN KEY (").append(fieldName).append(") REFERENCES ");
            fkDir.getDatabaseDescriptor().appendTableRawName(fkDir.getRawName(), sql);
            sql.append(" (").append(fkDir.getRecordIdField().getRawName()).append(')');
            statement.execute(ssContext, sql.toString());
        }
    }

    protected DbColumn newColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public final DbIndex getIndex(SSContext ssContext, String name) throws SQLException {
        return this.getIndexes(ssContext).get(this.scheme.toCaseIfNeed(name));
    }

    protected DbIndex newIndexObject(String name, int type, String condition) {
        return new DbIndex(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DbIndex createIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException, InformException {
        DbIndex result;
        LogContext lc;
        Request rq;
        DbIndex dbIndex = this.getIndex(ssContext, id.getRawName());
        if (dbIndex != null) {
            dbIndex.drop(ssContext, statement);
        }
        Request request = rq = (lc = LogContext.CURRENT.get()) instanceof Request ? (Request)lc : null;
        if (rq != null) {
            rq.vlongOp_begin();
        }
        try {
            result = this.newIndex(ssContext, statement, id);
        }
        finally {
            if (rq != null) {
                rq.vlongOp_end();
            }
        }
        result.log("CREATED");
        this.indexes.put(id.getRawName(), result);
        return result;
    }

    protected DbIndex newIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    protected void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        statement.execute(ssContext, "DROP TABLE " + this.fullName());
    }

    @Override
    void deleteInternalDbObject(DbObject obj) {
        if (obj instanceof DbColumn) {
            this.columns.remove(obj.name());
        } else if (obj instanceof DbIndex) {
            this.indexes.remove(obj.name());
        } else {
            super.deleteInternalDbObject(obj);
        }
    }

    @Override
    void renameInternalDbObject(DbObject obj, String oldName) {
        if (obj instanceof DbColumn) {
            this.columns.remove(oldName);
            this.columns.put(obj.name(), (DbColumn)obj);
        } else if (obj instanceof DbIndex) {
            this.indexes.remove(oldName);
            this.indexes.put(obj.name(), (DbIndex)obj);
        } else {
            super.deleteInternalDbObject(obj);
        }
    }
}

