/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.sql.QueryBuilder;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNodeMetadata;
import inform.agent.scripts.sql.RootQueryNode;
import java.io.IOException;

public class ProcedureQueryBuilder
extends QueryBuilder {
    public ProcedureQueryBuilder(Query query) {
        super(query);
    }

    @Override
    public String generate() throws IOException, InformException {
        String procedureName = this.query.getProcedureName();
        if (procedureName == null || procedureName.isEmpty()) {
            this.query.throwError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b");
        }
        RootQueryNode root = this.query.getRootNode();
        StringBuilder params = new StringBuilder();
        int comma = 32;
        DoubleSet checkParams = new DoubleSet();
        int paramCount = 0;
        for (Parameter p : this.query.getInputParameters().values()) {
            if (p.getBindIndex() < 0) continue;
            checkParams.add(p.getBindIndex());
            ++paramCount;
            if (p.getIsIgnored()) {
                p.clear();
            }
            if (p.getValueCount() != 1) {
                this.query.throwError("\u0427\u0438\u0441\u043b\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0440\u0430\u0432\u043d\u044f\u0442\u044c\u0441\u044f 1");
            }
            if (p.getRawValue() instanceof DateTimeInterval) {
                p.setAsDateValue(((DateTimeInterval)p.getRawValue()).getStartDate());
            }
            params.append((char)comma).append('?');
            comma = 44;
        }
        if (paramCount != checkParams.size()) {
            this.query.throwError("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442");
        }
        QueryNodeMetadata metadata = root.getMetadata();
        StringBuilder fields = new StringBuilder();
        comma = 32;
        for (FieldDescriptor f : metadata.getFields()) {
            fields.append((char)comma).append(f.getRawName());
            comma = 44;
        }
        StringBuilder sql = new StringBuilder();
        DatabaseType dbt = metadata.getDescriptor().getDatabaseDescriptor().getDatabaseType();
        dbt.caps().g_storedProcedureExecuteSql(params, procedureName, fields, sql);
        return sql.toString();
    }
}

