/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.sql.QueryBuilder;
import inform.agent.db.sql.QueryTokenizer;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QueryInSqlBuilder
extends QueryBuilder {
    private static final String tokenIfDef = "#ifdef";
    private static final String tokenIfNotDef = "#ifndef";
    private static final String tokenElseIf = "#elseif";
    private static final String tokenElse = "#else";
    private static final String tokenEndIf = "#endif";
    private static final String tokenTable = "#table";
    private static final String tokenAlias = "#alias";
    private static final String tokenIn = "#in";
    private static final String tokenJoin = "#join";
    private static final String tokenInt = "#int";
    private static final String tokenDouble = "#double";
    private static final String tokenDate = "#date";
    private static final String tokenBool = "#bool";
    private static final String tokenString = "#string";
    private static final String tokenSorting = "#sorting";
    private static final String tokenInline = "#inline";
    private static final String tokenParameters = "parameters";
    private static final String tokenDatabase = "database.";
    private static final String[] beginOfIf = new String[]{"#ifdef", "#ifndef"};
    private static final String[] beginOfIfBody = new String[]{"#ifdef", "#ifndef", "#ifndef", "#elseif"};
    private static final String[] endOfIfSection = new String[]{"#elseif", "#else"};
    private static final String[] endOfIfBody = new String[]{"#elseif", "#else", "#endif"};
    private static final String[] endOfIf = new String[]{"#endif"};
    private final String[] word1 = new String[1];
    private final String[] word2 = new String[2];

    public QueryInSqlBuilder(Query query) {
        super(query);
    }

    private String[] splitWord(String s) {
        if (Strings.isVoid(s)) {
            return null;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            this.word2[0] = s.substring(0, i);
            this.word2[1] = s.substring(i + 1);
            return this.word2;
        }
        this.word1[0] = s;
        return this.word1;
    }

    private boolean isToken(QueryTokenizer parser, String token) {
        return parser.value.equalsIgnoreCase(token);
    }

    private boolean isOneOfToken(QueryTokenizer parser, String[] tokenList) {
        for (String token : tokenList) {
            if (!this.isToken(parser, token)) continue;
            return true;
        }
        return false;
    }

    private void skipSymbol(QueryTokenizer parser, char symbol) throws IOException, InformException {
        if (parser.nextToken() != QueryTokenizer.Token.Symbol || parser.value.charAt(0) != symbol) {
            this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u043c\u0432\u043e\u043b '" + symbol + "'");
        }
    }

    private void skipIfDef(QueryTokenizer parser, String[] endOfTokens) throws IOException {
        QueryTokenizer.Token tokenType = parser.nextToken();
        while (tokenType != QueryTokenizer.Token.Eof) {
            if (tokenType == QueryTokenizer.Token.Word) {
                if (this.isOneOfToken(parser, beginOfIf)) {
                    this.skipIfDef(parser, endOfIf);
                }
                if (this.isOneOfToken(parser, endOfTokens)) {
                    return;
                }
            }
            tokenType = parser.nextToken();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processIfDefBody(QueryTokenizer parser, StringBuilder result) throws Exception {
        prevToken = null;
        tokenType = parser.nextToken();
        while (tokenType != QueryTokenizer.Token.Eof) {
            if (tokenType != QueryTokenizer.Token.Word) ** GOTO lbl14
            if (this.isOneOfToken(parser, QueryInSqlBuilder.beginOfIf)) {
                this.processIfDef(parser, result);
                prevToken = null;
            } else {
                if (this.isToken(parser, "#endif")) {
                    return;
                }
                if (this.isOneOfToken(parser, QueryInSqlBuilder.endOfIfSection)) {
                    this.skipIfDef(parser, QueryInSqlBuilder.endOfIf);
                    return;
                }
lbl14:
                // 3 sources

                this.processToken(parser, tokenType, prevToken, result);
                prevToken = tokenType;
            }
            tokenType = parser.nextToken();
        }
    }

    private boolean processDatabaseType(boolean isNotDef, String name) {
        boolean isTrue;
        DatabaseType type = null;
        if ("ORACLE".equals(name)) {
            type = DatabaseType.ORACLE;
        } else if ("PGSQL".equals(name)) {
            type = DatabaseType.POSTGRESQL;
        } else if ("MSSQL".equals(name)) {
            type = DatabaseType.MSSQL_ODBC;
        } else if ("MYSQL".equals(name)) {
            type = DatabaseType.MYSQL;
        } else if ("H2".equals(name)) {
            type = DatabaseType.H2;
        } else {
            this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0442\u0438\u043f \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        DatabaseType queryType = this.query.getDatabaseType();
        boolean bl = isTrue = queryType == type;
        if (!isTrue) {
            boolean bl2 = isTrue = type == DatabaseType.ORACLE && queryType == DatabaseType.ORACLE_ODBC;
        }
        if (isNotDef) {
            isTrue = !isTrue;
        }
        return isTrue;
    }

    private void processIfDef(QueryTokenizer parser, StringBuilder result) throws Exception {
        assert (parser.token == QueryTokenizer.Token.Word);
        assert (this.isOneOfToken(parser, beginOfIfBody));
        boolean isNotDef = this.isToken(parser, tokenIfNotDef);
        boolean processWord = true;
        block4: while (processWord) {
            switch (parser.nextToken()) {
                case Symbol: {
                    continue block4;
                }
                case Word: {
                    processWord = false;
                    continue block4;
                }
            }
            this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
        }
        boolean isTrue = false;
        if (parser.value.startsWith(tokenDatabase)) {
            isTrue = this.processDatabaseType(isNotDef, parser.value.substring(tokenDatabase.length()));
        } else {
            Parameter param = this.query.getInputParameters().get(parser.value);
            if (param == null) {
                this.query.throwError("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + parser.value + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else if (isNotDef) {
                isTrue = param.getIsIgnored() || param.getIsNull() || !param.getAsBoolean();
            } else {
                boolean bl = isTrue = !param.getIsIgnored() && !param.getIsNull() && param.getAsBoolean();
            }
        }
        if (isTrue) {
            this.processIfDefBody(parser, result);
        } else {
            this.skipIfDef(parser, endOfIfBody);
            if (!this.isToken(parser, tokenEndIf)) {
                if (this.isToken(parser, tokenElseIf)) {
                    this.processIfDef(parser, result);
                } else if (this.isToken(parser, tokenElse)) {
                    this.processIfDefBody(parser, result);
                }
            }
        }
    }

    private FieldDescriptor getFieldOf(QueryTokenizer parser, GenericQueryNode datasource) throws IOException, InformException {
        if (parser.nextToken() != QueryTokenizer.Token.Word) {
            return null;
        }
        String[] words = this.splitWord(parser.value);
        if (words == null || words.length != 2) {
            return null;
        }
        GenericQueryNode node = this.query.findNodeByName(words[0]);
        if (node == null || node.getEntryId() != datasource.getEntryId()) {
            return null;
        }
        return datasource.getFieldByName(words[1]);
    }

    private boolean processMacro(QueryTokenizer parser, StringBuilder result) throws Exception {
        if (parser.token != QueryTokenizer.Token.Word || parser.value.charAt(0) != '#') {
            return false;
        }
        if (this.isToken(parser, tokenTable)) {
            GenericQueryNode node;
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.Word) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
            }
            if ((node = this.query.findNodeByName(parser.value)) == null) {
                this.query.throwError("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a '" + parser.value + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                this.skipSymbol(parser, ')');
                node.generateRaw(result, null, null);
            }
            return true;
        }
        if (this.isToken(parser, tokenAlias)) {
            GenericQueryNode node;
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.Word) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
            }
            if ((node = this.query.findNodeByName(parser.value)) == null) {
                this.query.throwError("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a '" + parser.value + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                this.skipSymbol(parser, ')');
                node.generateRaw(result, null, null);
                result.append(' ');
                node.generateAlias(result, false);
            }
            return true;
        }
        if (this.isToken(parser, tokenIn)) {
            GenericQueryNode node;
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.Word) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
            }
            if ((node = this.query.findNodeByName(parser.value)) == null) {
                this.query.throwError("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a '" + parser.value + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                this.skipSymbol(parser, ',');
                FieldDescriptor field = this.getFieldOf(parser, node);
                if (field == null) {
                    node.throwNodeError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
                } else {
                    this.skipSymbol(parser, ')');
                    SqlBuilder.GenerateParams generateParams = new SqlBuilder.GenerateParams();
                    generateParams.subjectFieldId = field.getId();
                    node.generateRaw(result, null, generateParams);
                }
            }
            return true;
        }
        if (this.isToken(parser, tokenJoin)) {
            GenericQueryNode node;
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.Word) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
            }
            if ((node = this.query.findNodeByName(parser.value)) == null) {
                this.query.throwError("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a '" + parser.value + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                this.skipSymbol(parser, ')');
                node.generateJoin(result, null);
            }
            return true;
        }
        if (this.isToken(parser, tokenInt)) {
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.Number) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430(\u0446\u0435\u043b\u043e\u0435)");
            }
            int v = (int)Double.parseDouble(parser.value);
            this.query.generateIntValueSql(v, result);
            this.skipSymbol(parser, ')');
            return true;
        }
        if (this.isToken(parser, tokenDouble)) {
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.Number) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430(\u0434\u0440\u043e\u0431\u043d\u043e\u0435)");
            }
            double v = Double.parseDouble(parser.value);
            this.query.generateDoubleValueSql(v, result);
            this.skipSymbol(parser, ')');
            return true;
        }
        if (this.isToken(parser, tokenDate)) {
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.DoubleQuotedString) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430(\u0434\u0430\u0442\u0430)");
            }
            SimpleDateFormat defaultDateTimeFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            String s = parser.value.substring(1, parser.value.length() - 1);
            double v = 0.0;
            try {
                Date d = defaultDateTimeFormat.parse(s);
                v = DateTime.fromUnixTime(d.getTime());
            }
            catch (ParseException e) {
                this.query.throwError(e);
            }
            this.query.generateDateValueSql(v, result);
            this.skipSymbol(parser, ')');
            return true;
        }
        if (this.isToken(parser, tokenBool)) {
            this.skipSymbol(parser, '(');
            boolean v = false;
            switch (parser.nextToken()) {
                case Number: {
                    v = Double.parseDouble(parser.value) != 0.0;
                    break;
                }
                case Word: {
                    if (parser.value.compareToIgnoreCase("\u0434\u0430") == 0) {
                        v = true;
                        break;
                    }
                    if (parser.value.compareToIgnoreCase("true") == 0) {
                        v = true;
                        break;
                    }
                    if (parser.value.compareToIgnoreCase("\u043d\u0435\u0442") == 0) {
                        v = false;
                        break;
                    }
                    if (parser.value.compareToIgnoreCase("false") == 0) {
                        v = false;
                        break;
                    }
                    this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430(\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435)");
                    break;
                }
                default: {
                    this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430(\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435)");
                }
            }
            this.query.generateBoolValueSql(v, result);
            this.skipSymbol(parser, ')');
            return true;
        }
        if (this.isToken(parser, tokenString)) {
            this.skipSymbol(parser, '(');
            if (parser.nextToken() != QueryTokenizer.Token.DoubleQuotedString) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430(\u0441\u0442\u0440\u043e\u043a\u0430)");
            }
            String v = parser.value.substring(1, parser.value.length() - 1);
            this.query.generateAnsiStringValueSql(v, result);
            this.skipSymbol(parser, ')');
            return true;
        }
        if (this.isToken(parser, tokenSorting)) {
            this.query.generateOrderBy(result);
        } else {
            if (this.isToken(parser, tokenInline)) {
                this.skipSymbol(parser, '(');
                if (parser.nextToken() != QueryTokenizer.Token.Word) {
                    this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
                }
                String[] words = this.splitWord(parser.value);
                this.processParameter(words, true, result);
                this.skipSymbol(parser, ')');
                return true;
            }
            if (this.isOneOfToken(parser, beginOfIf)) {
                this.processIfDef(parser, result);
                return true;
            }
        }
        return false;
    }

    private boolean processParameter(String[] words, boolean inline, StringBuilder result) throws IOException, InformException {
        Parameter param;
        if (words == null || words.length == 0) {
            return false;
        }
        if (!words[0].equalsIgnoreCase(tokenParameters)) {
            if (inline) {
                this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
            }
            return false;
        }
        if (words.length != 2) {
            this.query.throwError("\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
        }
        if ((param = this.query.getInputParameters().get(words[1])) == null) {
            this.query.throwError("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + words[1] + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        this.query.generateParameter(param, inline, result);
        return true;
    }

    private boolean processDatasource(String[] words, StringBuilder result) throws IOException, InformException {
        if (words == null || words.length == 0) {
            return false;
        }
        GenericQueryNode node = this.query.findNodeByName(words[0]);
        if (node == null) {
            return false;
        }
        if (words.length != 1) {
            node.generateChildAlias(result, words[1]);
        } else {
            node.generateAlias(result, false);
        }
        return true;
    }

    private void processWord(QueryTokenizer parser, StringBuilder result) throws Exception {
        boolean processed;
        assert (parser.token == QueryTokenizer.Token.Word);
        if (parser.value.charAt(0) == '#') {
            processed = this.processMacro(parser, result);
        } else {
            String[] words = this.splitWord(parser.value);
            boolean bl = processed = this.processParameter(words, false, result) || this.processDatasource(words, result);
        }
        if (!processed) {
            result.append(parser.value);
        }
    }

    private QueryTokenizer.Token processToken(QueryTokenizer parser, QueryTokenizer.Token tokenType, QueryTokenizer.Token prevToken, StringBuilder result) throws Exception {
        switch (tokenType) {
            case Line: {
                int index;
                if (prevToken == tokenType || (index = result.length() - 1) < 0 || result.charAt(index) == '\n') break;
                result.append("\n");
                break;
            }
            case Number: {
                result.append(' ');
                result.append(parser.value);
                break;
            }
            case Word: {
                if (prevToken != null) {
                    result.append(' ');
                }
                this.processWord(parser, result);
                break;
            }
            case Eof: {
                break;
            }
            case DoubleQuotedString: 
            case SingleQuotedString: {
                result.append(parser.value);
                break;
            }
            case SplashSplashComment: {
                break;
            }
            default: {
                result.append(parser.value);
            }
        }
        return tokenType;
    }

    private QueryTokenizer.Token nextToken(QueryTokenizer parser, QueryTokenizer.Token prevToken, StringBuilder result) throws Exception {
        QueryTokenizer.Token tokenType = parser.nextToken();
        return this.processToken(parser, tokenType, prevToken, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder preprocess() throws IOException, InformException {
        QueryTokenizer parser = new QueryTokenizer(this.query.getSqlText());
        StringBuilder result = new StringBuilder();
        this.query.beginGenerate(parser);
        try {
            try {
                QueryTokenizer.Token tokenType = null;
                while (tokenType != QueryTokenizer.Token.Eof) {
                    tokenType = this.nextToken(parser, tokenType, result);
                }
            }
            catch (Throwable ex) {
                this.query.throwError(ex);
            }
        }
        finally {
            try {
                this.query.endGenerate();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
        }
        return result;
    }

    @Override
    public String generate() throws IOException, InformException {
        StringBuilder sql = this.preprocess();
        int fetchLimit = this.query.getFetchLimit();
        if (fetchLimit > 0) {
            DatabaseCaps caps = this.query.getDatabaseCaps();
            sql = caps.fetchLimitEnding(fetchLimit, sql);
        }
        return sql.toString();
    }
}

