/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql;

import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerSet;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SortField;
import inform.agent.db.SortFieldPath;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.ISqlBuilderState;
import inform.agent.db.sql.QueryBuilder;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.db.types.DataType;
import inform.agent.expr.AbstractEvaluator;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.ExpressionFilterQuery;
import inform.agent.scripts.sql.ExtraField;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryKind;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryNodeMetadata;
import inform.agent.scripts.sql.QueryOptimizerHint;
import inform.agent.scripts.sql.QuerySortFieldList;
import inform.agent.scripts.sql.ReturnedFields;
import inform.agent.scripts.sql.RootQueryNode;
import inform.agent.scripts.sql.UnionQueryNode;
import inform.agent.scripts.sql.expr.Condition;
import inform.agent.scripts.sql.expr.FieldExpression;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleSqlBuilder
extends QueryBuilder
implements ISqlBuilderState {
    private String stage;
    private SqlBuilder.GenerateParams subject = null;

    public SimpleSqlBuilder(Query query) {
        super(query);
    }

    private void appendTable(QueryNode node, DatasourceUsage datasourceUsage, StringBuilder sql) throws Exception {
        node.generateRaw(sql, datasourceUsage == null ? null : datasourceUsage.getFieldsUsage(node.getEntryId()), null);
        sql.append(' ');
        node.generateAlias(sql, false);
    }

    private void appendField(QueryNode node, FieldDescriptor field, StringBuilder sql, StringBuilder exprFilterFields, StringBuilder fieldSql) throws IOException {
        if (field.getType() == DataType.BIG_NUMBER) {
            fieldSql.append("CAST(");
            node.generateAlias(fieldSql, false);
            fieldSql.append('.').append(field.getRawName()).append(") ");
            sql.append((CharSequence)fieldSql).append(field.getRawName());
            if (exprFilterFields != null) {
                exprFilterFields.append("FILTER.").append(field.getRawName());
            }
        } else {
            node.generateAlias(fieldSql, false);
            fieldSql.append('.').append(field.getRawName());
            sql.append((CharSequence)fieldSql);
            if (exprFilterFields != null) {
                exprFilterFields.append("FILTER.").append(field.getRawName());
            }
        }
    }

    private boolean appendNullFieldExpr(char comma, int fieldId, String rawName, StringBuilder sql, FieldExprInfo info) throws Exception {
        if (info == null || info.requiredFields == null || !info.requiredFields.contains(fieldId)) {
            return false;
        }
        sql.append(comma).append(" null as ").append(rawName);
        return true;
    }

    private boolean appendFieldExpression(char comma, RootQueryNode node, FieldDescriptor field, StringBuilder sql, FieldExprInfo info, StringBuilder fieldSql) throws Exception {
        return this.appendFieldExpression(comma, node, field.getId(), field.getRawName(), sql, info, fieldSql);
    }

    private boolean appendFieldExpression(char comma, RootQueryNode node, int fieldId, String rawName, StringBuilder sql, FieldExprInfo info, StringBuilder fieldSql) throws Exception {
        FieldExpression expression = node.getFieldExpression(fieldId);
        if (expression == null) {
            return this.appendNullFieldExpr(comma, fieldId, rawName, sql, info);
        }
        QueryEvaluator evaluator = expression.compile();
        if (evaluator == null || evaluator.isIgnored()) {
            return this.appendNullFieldExpr(comma, fieldId, rawName, sql, info);
        }
        evaluator.generate(fieldSql, this.query);
        if (fieldSql.length() == 0) {
            return this.appendNullFieldExpr(comma, fieldId, rawName, sql, info);
        }
        sql.append(comma).append((CharSequence)fieldSql);
        if (info != null) {
            boolean isAggregative = evaluator.isAggregative();
            if (isAggregative) {
                info.hasAggregative = true;
            }
            if (!isAggregative) {
                if (info.noneAggregative == null) {
                    info.noneAggregative = new IntegerSet();
                }
                info.noneAggregative.add(fieldId);
            }
            evaluator.getDatasourceUsage(info.datasourceUsage);
        }
        expression.sqlCache = fieldSql.toString();
        return true;
    }

    @Override
    public String generate(SqlBuilder.GenerateParams generateParams) throws Exception {
        if (generateParams != null && generateParams.subjectFieldId != 0) {
            this.subject = generateParams;
        }
        return this.generate();
    }

    private void generateJoin(QueryNode node, ArrayList<QueryNode> joins, DatasourceUsage datasourceUsage, StringBuilder sql) throws Exception {
        for (QueryNode join : joins) {
            if (join.generated || join.getParentEntryId() != node.getEntryId()) continue;
            join.generated = true;
            IntegerSet fieldsUsage = datasourceUsage == null ? null : datasourceUsage.getFieldsUsage(join.getEntryId());
            join.generateJoin(sql, fieldsUsage);
            this.generateJoin(join, joins, datasourceUsage, sql);
        }
    }

    private void updateFieldPosition(QuerySortFieldList querySortFields, int fieldPosition, FieldDescriptor field, String fieldSql) {
        if (querySortFields == null || querySortFields.querySortFields == null) {
            return;
        }
        for (QuerySortFieldList.QuerySortField querySortField : querySortFields.querySortFields) {
            if (querySortField.fieldId != field.getId()) continue;
            querySortField.fieldPosition = fieldPosition;
            querySortField.fieldSql = fieldSql;
        }
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder generateSql(RootQueryNode rootNode, IntegerSet requiredFields, InternalParams gp) throws Exception {
        Object evaluator;
        QueryEvaluator queryEvaluator;
        QueryEvaluator evaluator3;
        void var17_31;
        StringBuilder sql = new StringBuilder();
        rootNode.prepareExpressions();
        DatasourceUsage datasourceUsage = new DatasourceUsage(this.query);
        StringBuilder fromSql = new StringBuilder();
        StringBuilder whereSql = null;
        Condition where = rootNode.getWhere();
        Condition hierarchy = rootNode.getHierarchy();
        Condition hierarchyRoot = rootNode.getHierarchyRoot();
        Condition having = rootNode.getHaving();
        ArrayList<QueryNode> joins = new ArrayList<QueryNode>();
        ArrayList<QueryNode> nonjoins = new ArrayList<QueryNode>();
        ExpressionFilterQuery expressionFilterQuery = this.query.getExpressionFilter();
        if (gp.canSort && (this.subject == null || this.subject.subjectFieldId == 0)) {
            QuerySortFieldList querySortFields = this.query.getSortFields();
            if (querySortFields == null) {
                gp.canSort = false;
            } else if (!querySortFields.querySortFields.isEmpty()) {
                this.query.setSortingGeneration(GeneratedSql.Sorting.FAILED);
            } else if (!querySortFields.isEmpty()) {
                int fieldId;
                if (this.query.getQueryKind() == QueryKind.SIMPLE) {
                    for (SortField sortField : querySortFields.fields()) {
                        QueryNode node = rootNode;
                        fieldId = ((SortFieldPath)sortField.get((int)0)).fieldId;
                        for (int i = sortField.size() - 1; i > 0; --i) {
                            SortFieldPath path = (SortFieldPath)sortField.get(i);
                            if ((node = node.createDirectory(path.tableId, path.fieldId)) == null) break;
                            datasourceUsage.add(node.getEntryId());
                        }
                        if (node != null) {
                            QuerySortFieldList.QuerySortField querySortField = new QuerySortFieldList.QuerySortField();
                            querySortField.ascending = sortField.isAscending();
                            querySortField.node = node;
                            querySortField.fieldId = fieldId;
                            querySortFields.querySortFields.add(querySortField);
                            datasourceUsage.add(node.getEntryId(), fieldId);
                            continue;
                        }
                        break;
                    }
                } else {
                    boolean canSort = true;
                    for (SortField sortField : querySortFields.fields()) {
                        if (sortField.size() == 1) continue;
                        canSort = false;
                        gp.canSort = false;
                        break;
                    }
                    if (canSort) {
                        for (SortField sortField : querySortFields.fields()) {
                            fieldId = ((SortFieldPath)sortField.get((int)0)).fieldId;
                            QuerySortFieldList.QuerySortField querySortField = new QuerySortFieldList.QuerySortField();
                            querySortField.ascending = sortField.isAscending();
                            querySortField.node = rootNode;
                            querySortField.fieldId = fieldId;
                            querySortFields.querySortFields.add(querySortField);
                            datasourceUsage.add(rootNode.getEntryId(), fieldId);
                        }
                        for (QuerySortFieldList.QuerySortField querySortField : querySortFields.querySortFields) {
                            querySortField.fieldPosition = -1;
                            datasourceUsage.add(rootNode.getEntryId(), querySortField.fieldId);
                            if (requiredFields == null) continue;
                            requiredFields.add(querySortField.fieldId);
                        }
                    }
                }
            } else {
                gp.canSort = false;
            }
        } else {
            gp.canSort = false;
        }
        rootNode.enumFromTables(joins, nonjoins);
        for (QueryNode n : joins) {
            n.calculateReference();
        }
        for (QueryNode n : nonjoins) {
            n.calculateReference();
        }
        IntegerSet excludedNodes = new IntegerSet();
        block19: while (true) {
            IntegerSet exclude = null;
            for (QueryNode n : joins) {
                if (excludedNodes.contains(n.getEntryId()) || !n.isIgnored()) continue;
                excludedNodes.add(n.getEntryId());
                IntegerSet refs = n.getReferencedTo();
                if (refs == null) continue;
                for (Cursor.Integer id : refs) {
                    if (excludedNodes.contains(id.value)) continue;
                    if (exclude == null) {
                        exclude = new IntegerSet();
                    }
                    exclude.add(id.value);
                }
            }
            for (QueryNode n : nonjoins) {
                if (excludedNodes.contains(n.getEntryId()) || !n.isIgnored()) continue;
                excludedNodes.add(n.getEntryId());
                IntegerSet refs = n.getReferencedTo();
                if (refs == null) continue;
                for (Cursor.Integer id : refs) {
                    if (excludedNodes.contains(id.value)) continue;
                    if (exclude == null) {
                        exclude = new IntegerSet();
                    }
                    exclude.add(id.value);
                }
            }
            if (exclude == null) break;
            Iterator<Cursor.Integer> iterator = exclude.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block19;
                Cursor.Integer id = iterator.next();
                excludedNodes.add(id.value);
                GenericQueryNode node = this.query.findNodeById(id.value);
                if (node == null || !(node instanceof QueryNode)) continue;
                ((QueryNode)node).setIgnored(true);
            }
            break;
        }
        QueryNodeMetadata metadata = rootNode.getMetadata();
        this.stage = "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043e\u043b\u0435\u0439(select)";
        boolean bl = rootNode.isDistinct();
        if (this.query.getQueryKind() == QueryKind.SIMPLE) {
            if (!nonjoins.isEmpty()) {
                boolean bl2 = true;
            } else {
                for (QueryNode node : joins) {
                    if (!node.isDistinctTableRelations()) continue;
                    boolean bl3 = true;
                    break;
                }
            }
        }
        if (var17_31 != false) {
            sql.append(" distinct ");
        }
        if (gp.fetchLimit >= 0) {
            rootNode.getDatabaseCaps().fetchLimitBeginning(gp.fetchLimit, sql);
        }
        StringBuilder blobFields = null;
        int comma = 32;
        FieldExprInfo fieldExprInfo = null;
        int fieldPosition = 0;
        StringBuilder exprFilterFields = expressionFilterQuery != null ? new StringBuilder() : null;
        if (metadata.getKind() == TableDescriptor.Kind.INTERNAL) {
            FieldDescriptor recordId = metadata.getRecordIdField();
            if (this.subject == null || this.subject.subjectFieldId == -1) {
                if (this.query.getQueryKind() == QueryKind.ADVANCED) {
                    fieldExprInfo = new FieldExprInfo(datasourceUsage, requiredFields);
                    StringBuilder fieldSql = new StringBuilder();
                    if (this.appendFieldExpression((char)comma, rootNode, recordId, sql, fieldExprInfo, fieldSql)) {
                        sql.append(" as ").append(recordId.getRawName());
                        if (exprFilterFields != null) {
                            exprFilterFields.append("FILTER.").append(recordId.getRawName());
                        }
                        comma = 44;
                        this.updateFieldPosition(this.query.getSortFields(), ++fieldPosition, recordId, fieldSql.toString());
                    }
                } else {
                    Iterator<ExtraField> fieldSql2 = new StringBuilder();
                    this.appendField(rootNode, recordId, sql, exprFilterFields, (StringBuilder)((Object)fieldSql2));
                    comma = 44;
                    this.updateFieldPosition(this.query.getSortFields(), ++fieldPosition, recordId, ((StringBuilder)((Object)fieldSql2)).toString());
                }
            }
        }
        ReturnedFields returnedFields = this.query.getRootNode().getReturnedFields();
        block26: for (FieldDescriptor fieldDescriptor : metadata.getFields()) {
            if (!returnedFields.contains(fieldDescriptor.getId())) continue;
            StringBuilder stringBuilder = new StringBuilder();
            switch (this.query.getQueryKind()) {
                case SIMPLE: {
                    if (fieldDescriptor.getKind() != 2) break;
                    if (fieldExprInfo == null) {
                        fieldExprInfo = new FieldExprInfo(datasourceUsage, requiredFields);
                    }
                    if (!this.appendFieldExpression((char)comma, rootNode, fieldDescriptor, sql, fieldExprInfo, stringBuilder)) break;
                    sql.append(" as ").append(fieldDescriptor.getRawName());
                    if (exprFilterFields != null) {
                        exprFilterFields.append((char)comma).append("FILTER.").append(fieldDescriptor.getRawName());
                    }
                    comma = 44;
                    this.updateFieldPosition(this.query.getSortFields(), ++fieldPosition, fieldDescriptor, stringBuilder.toString());
                    continue block26;
                }
                case ADVANCED: {
                    if (fieldExprInfo == null) {
                        fieldExprInfo = new FieldExprInfo(datasourceUsage, requiredFields);
                    }
                    if (this.appendFieldExpression((char)comma, rootNode, fieldDescriptor, sql, fieldExprInfo, stringBuilder)) {
                        sql.append(" as ").append(fieldDescriptor.getRawName());
                        if (exprFilterFields != null) {
                            exprFilterFields.append((char)comma).append("FILTER.").append(fieldDescriptor.getRawName());
                        }
                        comma = 44;
                        this.updateFieldPosition(this.query.getSortFields(), ++fieldPosition, fieldDescriptor, stringBuilder.toString());
                        continue block26;
                    }
                    if (requiredFields != null || !gp.canSort || this.query.getSortFields() == null || !this.query.getSortFields().contains(fieldDescriptor.getId())) continue block26;
                    sql.append((char)comma).append("null as ").append(fieldDescriptor.getRawName());
                    comma = 44;
                    this.updateFieldPosition(this.query.getSortFields(), ++fieldPosition, fieldDescriptor, stringBuilder.toString());
                    continue block26;
                }
            }
            if (fieldDescriptor.isAbstract() || this.subject != null && this.subject.subjectFieldId != fieldDescriptor.getId()) continue;
            switch (fieldDescriptor.getType()) {
                case BLOB: 
                case GEOMETRY: {
                    if (this.query.getBlobReceiving() == 0) continue block26;
                    if (blobFields == null) {
                        blobFields = new StringBuilder();
                    } else {
                        blobFields.append(',');
                    }
                    switch (this.query.getBlobReceiving()) {
                        case 1: {
                            blobFields.append("LENGTH(");
                            this.appendField(rootNode, fieldDescriptor, blobFields, null, stringBuilder);
                            blobFields.append(") ").append(fieldDescriptor.getRawName());
                            break;
                        }
                        case 2: {
                            this.appendField(rootNode, fieldDescriptor, blobFields, null, stringBuilder);
                        }
                    }
                    continue block26;
                }
                case FILE: {
                    if (this.query.getBlobReceiving() != 0) break;
                    continue block26;
                }
            }
            sql.append((char)comma);
            if (fieldDescriptor.isAbstract()) {
                sql.append("null as ").append(fieldDescriptor.getRawName());
                if (exprFilterFields != null) {
                    exprFilterFields.append((char)comma).append("FILTER.").append(fieldDescriptor.getRawName());
                }
            } else {
                if (exprFilterFields != null) {
                    exprFilterFields.append((char)comma);
                }
                this.appendField(rootNode, fieldDescriptor, sql, exprFilterFields, stringBuilder);
                this.updateFieldPosition(this.query.getSortFields(), ++fieldPosition, fieldDescriptor, stringBuilder.toString());
            }
            comma = 44;
        }
        if (this.query.hasExtraFields()) {
            for (ExtraField extraField : this.query.getExtraFields()) {
                if (fieldExprInfo == null) {
                    fieldExprInfo = new FieldExprInfo(datasourceUsage, requiredFields);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (!this.appendFieldExpression((char)comma, rootNode, extraField.id, extraField.getRawName(), sql, fieldExprInfo, stringBuilder)) {
                    sql.append((char)comma).append(" null");
                }
                sql.append(" as ").append(extraField.getRawName());
                comma = 44;
            }
        }
        if (gp.canSort) {
            QuerySortFieldList sortFields = this.query.getSortFields();
            if (sortFields != null) {
                String name;
                for (QuerySortFieldList.QuerySortField querySortField : sortFields.querySortFields) {
                    int no = 1;
                    if (querySortField.fieldSql != null) continue;
                    name = "TMPSRT" + no;
                    querySortField.fieldSql = name;
                    sql.append((char)comma);
                    querySortField.node.generateFieldAlias(sql, querySortField.fieldId, false);
                    sql.append(" as ").append(name);
                    ++no;
                }
                if (gp.pagedSort) {
                    void var25_54;
                    boolean bl4 = true;
                    for (QuerySortFieldList.QuerySortField querySortField : sortFields.querySortFields) {
                        if (querySortField.fieldSql == null) continue;
                        name = "TMPPGSRT" + (int)var25_54;
                        sql.append((char)comma).append(querySortField.fieldSql).append(" as ").append(name);
                        if (exprFilterFields != null) {
                            exprFilterFields.append((char)comma).append(name);
                        }
                        querySortField.fieldSql = name;
                        comma = 44;
                        ++var25_54;
                    }
                    if (var25_54 == true) {
                        gp.canSort = false;
                    }
                }
            } else {
                gp.canSort = false;
            }
        }
        if (blobFields != null && blobFields.length() != 0) {
            sql.append((char)comma).append((CharSequence)blobFields);
            if (exprFilterFields != null) {
                exprFilterFields.append((char)comma).append((CharSequence)blobFields);
            }
        }
        this.stage = "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0432 \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u0445";
        if (where != null && (evaluator3 = where.compile()) != null && !evaluator3.isIgnored()) {
            evaluator3.getDatasourceUsage(datasourceUsage);
        }
        if (hierarchyRoot != null && hierarchy != null) {
            QueryEvaluator evaluatorRoot = hierarchyRoot.compile();
            if (evaluatorRoot != null && !evaluatorRoot.isIgnored()) {
                evaluatorRoot.getDatasourceUsage(datasourceUsage);
                QueryEvaluator queryEvaluator2 = hierarchy.compile();
                if (queryEvaluator2 != null && !queryEvaluator2.isIgnored()) {
                    queryEvaluator2.getDatasourceUsage(datasourceUsage);
                } else {
                    hierarchyRoot = null;
                    hierarchy = null;
                }
            } else {
                hierarchyRoot = null;
                hierarchy = null;
            }
        }
        StringBuilder sqlWithoutSelect = sql;
        sql = new StringBuilder();
        sql.append("select ");
        QueryOptimizerHint.OptimizerHint optimizerHint = this.query.getOptimizerHint();
        if (optimizerHint != null) {
            optimizerHint.generateAfterSelectKeyword(this.query, datasourceUsage, sql);
        }
        sql.append((CharSequence)sqlWithoutSelect);
        this.stage = "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432(from)";
        comma = 32;
        Iterator<QueryNode> iterator = joins.iterator();
        while (iterator.hasNext()) {
            QueryNode node = iterator.next();
            if (!node.canExclude(datasourceUsage)) continue;
            iterator.remove();
        }
        if (this.query.getQueryKind() == QueryKind.SIMPLE) {
            this.appendTable(rootNode, null, fromSql);
            this.generateJoin(rootNode, joins, datasourceUsage, fromSql);
            comma = 44;
        }
        for (QueryNode node : nonjoins) {
            if (node.canExclude(datasourceUsage)) continue;
            fromSql.append((char)comma);
            this.appendTable(node, datasourceUsage, fromSql);
            this.generateJoin(node, joins, datasourceUsage, fromSql);
            comma = 44;
        }
        sql.append(" from ").append((CharSequence)fromSql);
        this.stage = "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f(where)";
        if (where != null && (queryEvaluator = where.compile()) != null && !queryEvaluator.isIgnored()) {
            whereSql = new StringBuilder();
            queryEvaluator.generate(whereSql, this.query);
        }
        String string = this.query.getTableRelationsSql();
        if (whereSql != null && whereSql.length() != 0) {
            sql.append(" where ");
            if (string != null) {
                sql.append('(').append((CharSequence)whereSql).append(") and (").append(string).append(')');
            } else {
                sql.append((CharSequence)whereSql);
            }
        } else if (string != null) {
            sql.append(" where ").append(string);
        }
        if (hierarchy != null && hierarchyRoot != null) {
            this.stage = "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0435\u0440\u0430\u0440\u0445\u0438\u0438";
            QueryEvaluator evaluatorRoot = hierarchyRoot.compile();
            evaluator = hierarchy.compile();
            if (evaluator != null && !((AbstractEvaluator)evaluator).isIgnored() && evaluatorRoot != null && !evaluatorRoot.isIgnored()) {
                sql.append(" start with ");
                evaluatorRoot.generate(sql, this.query);
                sql.append(" connect by ");
                ((QueryEvaluator)evaluator).generate(sql, this.query);
            }
        }
        if (this.query.getQueryKind() == QueryKind.ADVANCED) {
            if (fieldExprInfo != null && fieldExprInfo.needGenerateGroupBy()) {
                StringBuilder groupBySql = new StringBuilder();
                this.stage = "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u0438(group by)";
                comma = 32;
                for (Cursor.Integer field : fieldExprInfo.noneAggregative) {
                    FieldExpression expression = rootNode.getFieldExpression(field.value);
                    if (expression == null || Strings.isVoid(expression.sqlCache)) continue;
                    groupBySql.append((char)comma).append(expression.sqlCache);
                    comma = 44;
                }
                if (groupBySql.length() > 0) {
                    sql.append(" group by ").append((CharSequence)groupBySql);
                }
            }
            if (having != null) {
                StringBuilder havingSql = new StringBuilder();
                evaluator = having.compile();
                if (evaluator != null && !((AbstractEvaluator)evaluator).isIgnored()) {
                    ((QueryEvaluator)evaluator).generate(havingSql, this.query);
                }
                if (havingSql.length() > 0) {
                    sql.append(" having ").append((CharSequence)havingSql);
                }
            }
        }
        if (this.subject == null || this.subject.subjectFieldId == 0) {
            this.stage = "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438(order by)";
            if (gp.canSort && !gp.pagedSort) {
                this.query.generateOrderBy(sql);
            }
            if (expressionFilterQuery != null) {
                QueryEvaluator evaluator5;
                expressionFilterQuery.beginGenerate(this);
                StringBuilder filterSql = new StringBuilder();
                filterSql.append("select ").append((CharSequence)exprFilterFields).append(" from (").append((CharSequence)sql).append(") ").append("FILTER");
                filterSql.append(expressionFilterQuery.getDirectorySQL());
                filterSql.append(" where ");
                Condition filter = expressionFilterQuery.getRootNode().getWhere();
                if (filter != null && (evaluator5 = filter.compile()) != null && !evaluator5.isIgnored()) {
                    evaluator5.generate(filterSql, expressionFilterQuery);
                    sql = filterSql;
                }
                this.query.getSqlParameters().addFrom(expressionFilterQuery.getSqlParameters());
                expressionFilterQuery.endGenerate();
            }
        }
        return sql;
    }

    public static String getExpressionFilterCondition(ExpressionFilterQuery expressionFilterQuery) throws Exception {
        if (expressionFilterQuery == null) {
            return null;
        }
        Condition filter = expressionFilterQuery.getRootNode().getWhere();
        if (filter == null) {
            return null;
        }
        expressionFilterQuery.beginGenerate(null);
        QueryEvaluator evaluator = filter.compile();
        if (evaluator == null || evaluator.isIgnored()) {
            return null;
        }
        StringBuilder filterSql = new StringBuilder();
        evaluator.generate(filterSql, expressionFilterQuery);
        if (filterSql.length() == 0) {
            return null;
        }
        return filterSql.toString();
    }

    private void getRequiredFields(RootQueryNode rootNode, IntegerSet requiredFields) {
        QueryNodeMetadata metadata = rootNode.getMetadata();
        if (metadata.getKind() == TableDescriptor.Kind.INTERNAL) {
            FieldDescriptor recordId = metadata.getRecordIdField();
            if ((this.subject == null || this.subject.subjectFieldId == -1) && rootNode.getFieldExpression(recordId.getRefFieldId()) != null) {
                requiredFields.add(recordId.getId());
            }
        }
        for (FieldDescriptor field : metadata.getFields()) {
            if (rootNode.getFieldExpression(field.getRefFieldId()) == null) continue;
            requiredFields.add(field.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generate() throws Exception {
        IntegerSet requiredFields = null;
        this.stage = "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f";
        this.query.beginGenerate(this);
        InternalParams gp = new InternalParams();
        StringBuilder sql = new StringBuilder();
        try {
            QuerySortFieldList sortFields;
            DatabaseCaps caps = this.query.getDatabaseCaps();
            int fetchLimit = this.query.getFetchLimit();
            gp.pagedSort = this.query.isPagedFetch();
            gp.fetchLimit = fetchLimit;
            if (caps.canLogNodeID()) {
                sql.append("/*q:").append((long)this.query.getNodeId()).append("*/ ");
            }
            RootQueryNode rootNode = this.query.getRootNode();
            switch (rootNode.getUnionCount()) {
                case 0: {
                    sql.append((CharSequence)this.generateSql(rootNode, requiredFields, gp));
                    sql = caps.fetchLimitEnding(fetchLimit, sql);
                    break;
                }
                case 1: {
                    sql.append((CharSequence)this.generateSql(rootNode.firstUnion(), requiredFields, gp));
                    sql = caps.fetchLimitEnding(fetchLimit, sql);
                    break;
                }
                default: {
                    gp.canSort = false;
                    gp.fetchLimit = -1;
                    if (this.query.getQueryKind() == QueryKind.ADVANCED) {
                        requiredFields = new IntegerSet();
                        for (UnionQueryNode unionQueryNode : rootNode.getUnions()) {
                            this.getRequiredFields(unionQueryNode, requiredFields);
                        }
                    }
                    String separator = "(";
                    for (UnionQueryNode union : rootNode.getUnions()) {
                        sql.append(separator);
                        sql.append((CharSequence)this.generateSql(union, requiredFields, gp));
                        sql.append(')');
                        if (rootNode.isDistinct()) {
                            separator = " union (";
                            continue;
                        }
                        separator = " union all (";
                    }
                    this.query.setSortingGeneration(GeneratedSql.Sorting.FAILED);
                    sql = caps.fetchLimitEnding(fetchLimit, sql);
                }
            }
            if (gp.canSort && gp.pagedSort && (sortFields = this.query.getSortFields()) != null) {
                sql.append(" order by ");
                int n = 32;
                for (QuerySortFieldList.QuerySortField querySortField : sortFields.querySortFields) {
                    int n2;
                    if (querySortField.fieldSql == null) continue;
                    sql.append((char)n2).append(querySortField.fieldSql);
                    n2 = 44;
                    if (querySortField.ascending) {
                        sql.append(" asc");
                        continue;
                    }
                    sql.append(" desc");
                }
            }
            this.stage = "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f";
        }
        finally {
            this.query.endGenerate();
        }
        return sql.toString();
    }

    @Override
    public String getCurrentState() {
        return this.stage;
    }

    private static class InternalParams {
        int fetchLimit = -1;
        boolean canSort = true;
        boolean sendCannotSort = false;
        boolean pagedSort = false;

        private InternalParams() {
        }
    }

    private static class FieldExprInfo {
        boolean hasAggregative = false;
        IntegerSet noneAggregative = null;
        final DatasourceUsage datasourceUsage;
        final IntegerSet requiredFields;

        private FieldExprInfo(DatasourceUsage datasourceUseage, IntegerSet requiredFields) {
            this.datasourceUsage = datasourceUseage;
            this.requiredFields = requiredFields;
        }

        boolean needGenerateGroupBy() {
            return this.hasAggregative && this.noneAggregative != null && !this.noneAggregative.empty();
        }
    }
}

