/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerSet;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.sql.ValueSqlGenerator;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.scripts.sql.ReturnedFields;
import java.util.ArrayList;

public class TableSqlGenerator {
    private static final String alias = "P";

    public static void generatePeriodicFromSql(TableDescriptor table, double actualPoint, ReturnedFields returnedFields, IntegerSet usedFields, ValueSqlGenerator valueGenerator, StringBuilder fromSql) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        DoubleHash<PeriodicStorage> storage = null;
        for (FieldDescriptor field : table.getFields()) {
            if (!returnedFields.contains(field.getId()) || usedFields != null && !usedFields.contains(field.getId())) continue;
            fields.add(field);
            if (!field.hasPeriodicStorage()) continue;
            if (storage == null) {
                storage = new DoubleHash<PeriodicStorage>();
            }
            FieldDescriptor.PeriodicFieldStorage p = field.getPeriodicStorage();
            if (storage.get(p.tableId) != null) continue;
            storage.add(new PeriodicStorage(storage.size() + 1, p.tableId, table));
        }
        if (storage == null) {
            table.getDatabaseDescriptor().appendTableRawName(table.getRawName(), fromSql);
            return;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select");
        int comma = 32;
        FieldDescriptor recordId = table.getRecordIdField();
        if (returnedFields.contains(-1)) {
            sql.append((char)comma).append(alias).append('.').append(recordId).append(" as ").append(recordId);
            comma = 44;
        }
        for (FieldDescriptor field : fields) {
            sql.append((char)comma);
            FieldDescriptor.PeriodicFieldStorage p = field.getPeriodicStorage();
            if (p != null) {
                PeriodicStorage s = (PeriodicStorage)storage.get(p.tableId);
                if (s == null) {
                    throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + NumberConverter.doubleToString(p.tableId));
                }
                FieldDescriptor realField = s.tableDescriptor.getExistingFieldDescriptor(p.fieldId);
                sql.append(alias).append(s.no).append('.').append(realField);
            } else {
                sql.append(alias).append('.').append(field);
            }
            sql.append(" as ").append(field);
            comma = 44;
        }
        sql.append(" from ").appendFull(table).append(' ').append(alias);
        for (PeriodicStorage s : storage) {
            String a = alias + s.no;
            sql.append(" left outer join ").append(s.tableDescriptor).append(' ').append(a).append(" on ").append(a).append('.').append(s.referenceField).append("=").append(alias).append('.').append(recordId).append(" and ").append(a).append('.').append(s.beginField).append("<=");
            valueGenerator.generateDateValueSql(actualPoint, sql.getBuilder());
            sql.append(" and ").append(a).append('.').append(s.endField).append(">");
            valueGenerator.generateDateValueSql(actualPoint, sql.getBuilder());
        }
        fromSql.append(sql);
    }

    private static class PeriodicStorage
    implements DoubleHash.Entry {
        final int no;
        final TableDescriptor tableDescriptor;
        final TableDescriptor.PeriodicTableStorage storage;
        final FieldDescriptor referenceField;
        final FieldDescriptor beginField;
        final FieldDescriptor endField;

        private PeriodicStorage(int no, double tableId, TableDescriptor periodicTable) {
            this.no = no;
            this.tableDescriptor = TableDescriptor.get(tableId);
            this.storage = periodicTable.getPeriodicTableStorages().get(tableId);
            if (this.storage == null) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + NumberConverter.doubleToString(tableId));
            }
            this.referenceField = this.tableDescriptor.getExistingFieldDescriptor(this.storage.referenceFieldId);
            this.beginField = this.tableDescriptor.getExistingFieldDescriptor(this.storage.beginFieldId);
            this.endField = this.tableDescriptor.getExistingFieldDescriptor(this.storage.endFieldId);
        }

        @Override
        public double key() {
            return this.storage.tableId;
        }
    }
}

