/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SearchGeneratedSql;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.sql.engine.Condition;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.GenerateCondition;
import inform.agent.db.sql.engine.HierarchicEntry;
import inform.agent.db.sql.engine.NestedEntry;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.sql.engine.SearchFields;
import inform.agent.db.sql.engine.SearchSorting;
import inform.agent.db.sql.engine.SubjectEntry;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.SqlParameter;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.sql.ExpressionFilterQuery;
import inform.agent.scripts.sql.QueryParameter;
import inform.agent.scripts.sql.QueryParameterList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Engine {
    Search topSearch;
    DatabaseDescriptor databaseDescriptor;
    DatabaseType databaseType;
    DatabaseCaps caps;
    Constants constants;
    StringBuilder aliasLegend;
    Generate.Section filter;
    String filterDirectories;
    int[] filterFields;

    public static GeneratedSql generate(double tableId, double userNodeID, double databaseId, int databaseTypeId, SqlGenerator host, byte[] inputData) throws IOException {
        Engine engine = new Engine();
        return engine.createGeneratedSql(tableId, userNodeID, databaseId, databaseTypeId, host, inputData);
    }

    public GeneratedSql createGeneratedSql(double tableId, double userNodeID, double databaseId, int databaseTypeId, SqlGenerator host, byte[] inputData) throws IOException {
        String filterSql;
        this.constants = host.getConstants();
        this.topSearch = new Search(this.constants, host.getTimeZoneHost());
        this.topSearch.loadRequest(new TaggedReader(inputData));
        ExpressionFilterQuery filterQuery = host.getExpressionFilterQuery();
        if (filterQuery != null && !Strings.isVoid(filterSql = host.getExpressionFilter())) {
            this.filter = new Generate.Section();
            this.filter.sql.append(filterSql);
            QueryParameterList parameters = filterQuery.getSqlParameters();
            block32: for (QueryParameter queryParameter : parameters.items()) {
                if (queryParameter.getIsNull()) {
                    this.filter.addNullParam(queryParameter.getType().toDataType());
                    continue;
                }
                switch (queryParameter.getType()) {
                    case STRING: {
                        this.filter.addStringParam(queryParameter.getStringValue());
                        continue block32;
                    }
                    case UNICODE: {
                        this.filter.addUnicodeParam(queryParameter.getStringValue());
                        continue block32;
                    }
                    case DATE_TIME: 
                    case TIMESTAMP: {
                        this.filter.addDateTimeParam(queryParameter.getNumberValue());
                        continue block32;
                    }
                    case DOUBLE: {
                        this.filter.addDoubleParam(queryParameter.getNumberValue());
                        continue block32;
                    }
                    case INTEGER: {
                        this.filter.addIntegerParam((int)queryParameter.getNumberValue());
                        continue block32;
                    }
                    case BOOLEAN: {
                        this.filter.addBooleanParam(queryParameter.getBooleanValue());
                        continue block32;
                    }
                }
                this.filter.addNullParam(queryParameter.getType().toDataType());
            }
            this.filterDirectories = host.JNI_ExpressionFilterGetDirectoriesSQL();
            this.filterFields = filterQuery.requiredFilterFields();
            this.topSearch.hasDataFilter(true);
        }
        this.topSearch.beginGenerate(this);
        try {
            this.init(databaseId, databaseTypeId);
            Generate.Section section = this.generateSql(this.topSearch);
            ByteArrayOutputStream paramsContent = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(paramsContent);
            for (SqlParameter p : section.sqlParameters) {
                if (p.isNull()) {
                    DataType dataType = DataType.NONE;
                    switch (p.getType()) {
                        case INTEGER: {
                            dataType = DataType.INTEGER;
                            break;
                        }
                        case DOUBLE: {
                            dataType = DataType.FLOAT;
                            break;
                        }
                        case STRING: {
                            dataType = DataType.STRING;
                            break;
                        }
                        case BLOB: {
                            dataType = DataType.BLOB;
                            break;
                        }
                        case DATE_TIME: {
                            dataType = DataType.DATE_TIME;
                            break;
                        }
                        case UNICODE: {
                            dataType = DataType.UNICODE;
                            break;
                        }
                        case BOOLEAN: {
                            dataType = DataType.BOOLEAN;
                        }
                    }
                    out.putInt32(1, dataType.toInt());
                    continue;
                }
                switch (p.getType()) {
                    case INTEGER: {
                        out.putInt32(2, p.getInteger());
                        break;
                    }
                    case DOUBLE: {
                        out.putDouble(3, p.getDouble());
                        break;
                    }
                    case STRING: {
                        out.putAnsi(4, p.getString());
                        break;
                    }
                    case BLOB: {
                        out.putRaw(5, p.getBlob());
                        break;
                    }
                    case DATE_TIME: {
                        out.putDouble(6, p.getDouble());
                        break;
                    }
                    case UNICODE: {
                        out.putUnicode(7, p.getString());
                        break;
                    }
                    case BOOLEAN: {
                        out.putInt32(8, p.getAsBoolean() ? 1 : 0);
                    }
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            out.reset(byteArrayOutputStream);
            if (this.topSearch.hasFromSection()) {
                int capacity = section.sql.length() + 64;
                if (!Strings.isVoid(this.aliasLegend)) {
                    capacity += this.aliasLegend.length() + 32;
                }
                StringBuilder sql = new StringBuilder(capacity);
                if (this.topSearch.searchNodeId != 0.0 && DatabaseCaps.canLogNodeID(this.databaseType)) {
                    sql.append("/*").append("f:").append(NumberConverter.doubleToString(this.topSearch.searchNodeId)).append("*/").append(' ');
                }
                sql.append((CharSequence)section.sql);
                if (this.topSearch.generateDebugInfo() && this.aliasLegend != null && this.aliasLegend.length() != 0) {
                    sql.append("\r\n").append("/*").append("\r\n").append((CharSequence)this.aliasLegend).append("\r\n").append("*/");
                }
                out.putString(2, sql.toString());
                if (this.topSearch.kind == Search.Kind.Advanced) {
                    out.putEmpty(5);
                }
                if (this.topSearch.disabledLockRecords()) {
                    out.putEmpty(7);
                }
                if (!this.topSearch.hasBlobFields() || this.topSearch.canSelectBlobs()) {
                    out.putEmpty(8);
                }
                if (this.topSearch.isSubject()) {
                    out.putEmpty(9);
                }
                if (this.topSearch.hasPrimaryKeyExpression()) {
                    out.putEmpty(11);
                }
                if (this.topSearch.failedSort()) {
                    out.putEmpty(10);
                }
                out.putEmpty(3);
                out.putRaw(202, paramsContent.internalBuffer(), paramsContent.size());
            } else {
                out.putEmpty(4);
            }
            out.flush();
            SearchGeneratedSql searchGeneratedSql = new SearchGeneratedSql(new ByteArrayInputStream(byteArrayOutputStream.internalBuffer(), 0, byteArrayOutputStream.size()));
            return searchGeneratedSql;
        }
        catch (Search.Exception exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new Search.Exception(this.topSearch, InformException.getExceptionMessage(exception), exception);
        }
        finally {
            this.topSearch.endGenerate();
        }
    }

    private void init(double databaseId, int databaseTypeId) {
        if (databaseId != 0.0) {
            this.databaseDescriptor = DatabaseDescriptor.getDatabase(databaseId);
        } else {
            TableDescriptor tableDescriptor = this.topSearch.getRootEntry().getTableDescriptor();
            this.databaseDescriptor = tableDescriptor.getDatabaseDescriptor();
        }
        this.databaseType = databaseTypeId < 0 ? this.databaseDescriptor.getDatabaseType() : DatabaseType.get(databaseTypeId);
        this.caps = this.databaseType.caps();
        this.aliasLegend = new StringBuilder();
    }

    Generate.Section generateSql(Search search) throws IOException {
        Generate.Section section = this.processGenerateSql(search);
        if (section == null) {
            return section;
        }
        section = this.generateWithSections(search, section);
        if (search.hasDataFilter()) {
            section.sql.insert(0, "select * from (");
            section.sql.append(") filter ");
            if (!Strings.isVoid(this.filterDirectories)) {
                section.sql.append(this.filterDirectories);
            }
            section.sql.append(" where ");
            section.append(this.filter);
            if (!Strings.isVoid(search.dataFilterOrderBy)) {
                section.sql.append(" order by ").append((CharSequence)search.dataFilterOrderBy);
            }
        }
        if (search.fetchLimit > 0) {
            this.caps.fetchLimitWrap(search.fetchLimit, section.sql);
        }
        if (search.fetchLimit > 0) {
            this.caps.fetchLimitBottom(search.fetchLimit, section.sql);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Generate.Section generateEntrySql(Search search, SearchEntry entry) throws IOException {
        Search parent = search.parentSearch;
        search.parentSearch = entry.owner;
        try {
            Generate.Section section = this.generateSql(search);
            return section;
        }
        finally {
            search.parentSearch = parent;
        }
    }

    Generate.Section processGenerateSql(Search search) throws IOException {
        search.initialize(this.caps);
        if (search.kind == Search.Kind.StoredProcedure) {
            return this.generateStoredProcedureSql(search);
        }
        if (search.isUnions()) {
            return this.generateUnionSql(search);
        }
        search.rootEntry.checkEntry(search.kind == Search.Kind.Standard);
        if (search.isHierarchic() && this.caps.isAnsiHierarchicSyntax()) {
            search.rootEntry.excludePeriodicDataRecursive();
            search.hasRecursionWithSection(true);
            search.additionalFields = new ArrayList();
            search.additionalFieldNames = new HashSet();
            search.additionalFieldIds = new IntegerSet();
            if (search.kind == Search.Kind.Advanced) {
                return this.generateAdvancedHierarchicSql(search);
            }
            return this.generateStandardHierarchicSql(search);
        }
        if (search.kind == Search.Kind.Advanced) {
            return this.generateAdvancedSql(search);
        }
        return this.generateStandardSql(search);
    }

    private void adjustCondition(Condition condition) {
        if (condition != null) {
            condition.adjust(this.caps);
        }
    }

    private boolean beginOracleOptiomizer(Generate.Section section, boolean optimized) {
        if (!optimized) {
            section.sql.append("/*+");
        }
        return true;
    }

    private boolean endOracleOptiomizer(Generate.Section section, boolean optimized) {
        if (optimized) {
            section.sql.append(" */ ");
        }
        return true;
    }

    private void generateSelectSectionOptimizer(final Search search, Generate.Section section) {
        switch (this.databaseType) {
            case ORACLE_ODBC: 
            case ORACLE: {
                break;
            }
            default: {
                return;
            }
        }
        if (!search.hasOptimizer()) {
            return;
        }
        boolean optimized = false;
        if (!Strings.isVoid(search.oracleOptimizerIndexCaching)) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(" opt_param('optimizer_index_caching' ").append(search.oracleOptimizerIndexCaching).append(')');
        }
        if (!Strings.isVoid(search.oracleOptimizerIndexCostAdj)) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(" opt_param('optimizer_index_cost_adj' ").append(search.oracleOptimizerIndexCostAdj).append(')');
        }
        if (!Strings.isVoid(search.oracleHint)) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(' ').append(search.oracleHint);
        }
        boolean leadingHint = false;
        boolean indexHint = true;
        int jnlHint = 2;
        int jhashHint = 3;
        int jMergeHint = 4;
        final StringBuilder[] hints = new StringBuilder[]{null, null, null, null, null};
        search.rootEntry.process(new SearchEntry.Process(){

            @Override
            public void processEntry(SearchEntry entry) {
                StringBuilder sql;
                if (entry.ignored()) {
                    return;
                }
                if (!Strings.isVoid(entry.oracleHint_Index)) {
                    sql = hints[1];
                    if (sql == null) {
                        sql = hints[1] = new StringBuilder();
                    }
                    sql.append(" index(");
                    entry.generateAlias(sql);
                    sql.append(' ').append(entry.oracleHint_Index).append(')');
                }
                switch (entry.oracleHint_JoinType) {
                    case 1: {
                        sql = hints[2];
                        if (sql == null) {
                            sql = hints[2] = new StringBuilder();
                        }
                        sql.append(' ');
                        entry.generateAlias(sql);
                        break;
                    }
                    case 2: {
                        sql = hints[3];
                        if (sql == null) {
                            sql = hints[3] = new StringBuilder();
                        }
                        sql.append(' ');
                        entry.generateAlias(sql);
                        break;
                    }
                    case 3: {
                        sql = hints[4];
                        if (sql == null) {
                            sql = hints[4] = new StringBuilder();
                        }
                        sql.append(' ');
                        entry.generateAlias(sql);
                        break;
                    }
                }
                if (search.oracleLeading.contains(entry.entryId)) {
                    sql = hints[0];
                    if (sql == null) {
                        sql = hints[0] = new StringBuilder();
                    }
                    sql.append(' ');
                    entry.generateAlias(sql);
                }
            }
        });
        if (hints[0] != null) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(" leading(").append((CharSequence)hints[0]).append(')');
        }
        if (hints[2] != null) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(" USE_NL(").append((CharSequence)hints[2]).append(')');
        }
        if (hints[3] != null) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(" USE_HASH(").append((CharSequence)hints[3]).append(')');
        }
        if (hints[4] != null) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append(" USE_MERGE(").append((CharSequence)hints[4]).append(')');
        }
        if (hints[1] != null) {
            optimized = this.beginOracleOptiomizer(section, optimized);
            section.sql.append((CharSequence)hints[1]);
        }
        this.endOracleOptiomizer(section, optimized);
    }

    private Generate.Section generateStandardSql(Search search) throws IOException {
        boolean distinct;
        if (search.isUnionItem() && search.parentSearch != null && search.parentSearch.sorting != null && !search.parentSearch.sorting.isEmpty()) {
            search.sortableFields = new ArrayList();
        }
        StringBuilder blobs = null;
        this.adjustCondition(search.where);
        this.adjustCondition(search.relations);
        this.adjustCondition(search.hierarchyRoot);
        this.adjustCondition(search.hierarchyConnection);
        Generate.OrderBy sorting = null;
        if (search.hasDataFilter() || search.pagedFetch()) {
            if (!search.isUnionItem()) {
                sorting = Generate.generateStandardDataFilterOrderBy(search, this.caps);
            }
        } else {
            sorting = Generate.generateStandardOrderBy(search, this.caps);
        }
        Generate.Section whereSection = GenerateCondition.createSection(this, search.where);
        Generate.Section relations = GenerateCondition.createSection(this, search.relations);
        Generate.Section hierarchyRoot = GenerateCondition.createSection(this, search.hierarchyRoot);
        Generate.Section hierarchyConnection = GenerateCondition.createSection(this, search.hierarchyConnection);
        if (relations != null) {
            if (whereSection == null) {
                whereSection = relations;
            } else {
                whereSection.addParameters(relations.sqlParameters);
                whereSection.sql.insert(0, '(').append(')').append(Condition.LogicalOperator.AND.sql).append((CharSequence)relations.sql);
            }
        }
        search.rootEntry.adjustRelations(this.caps);
        for (int i = 0; i < 2; ++i) {
            search.rootEntry.excludeByRelations();
        }
        search.rootEntry.excludeIfExcludedFromConditions(false);
        SearchEntry fieldsEntry = search.rootEntry;
        SearchEntry rootEntry = search.rootEntry;
        if (search.isUnionItem() && !rootEntry.isEmpty()) {
            rootEntry = rootEntry.children.get(0);
            rootEntry.excludeIfExcludedFromConditions(false);
            rootEntry.excludable(false);
        }
        rootEntry.checkIgnored();
        rootEntry.ignored(false);
        if (!search.periodicInitialized()) {
            search.periodicInitialized(true);
            search.fillSignificantFields();
            rootEntry.expandPeriodicTables();
        }
        Generate.Section from = Generate.generateFrom(search, this);
        search.hasFromSection(from.sql.length() != 0);
        Generate.Section section = new Generate.Section();
        section.sql.append("select ");
        this.generateSelectSectionOptimizer(search, section);
        boolean bl = distinct = search.distinct() || search.relations != null && !search.relations.isEmpty() || search.rootEntry.hasDistinctRelations();
        if (distinct) {
            search.disabledLockRecords(true);
            search.canSelectBlobs(false);
            section.sql.append(" distinct ");
        }
        if (search.fetchLimit > 0) {
            this.caps.fetchLimitTop(search.fetchLimit, section.sql);
        }
        if (search.isSubject()) {
            Generate.fieldWithModificator(this.caps, rootEntry, search.subjectFieldId, search.subjectFieldModificator, section.sql, "\u043f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u043e\u043c \u043f\u043e\u0438\u0441\u043a\u0435", "entryId \u043f\u043e\u0438\u0441\u043a\u0430", search.parentEntry.entryId);
            if (search.sortableFields != null) {
                search.sortableFields.add(null);
            }
        } else {
            int separator = 32;
            TableDescriptor table = fieldsEntry.getTableDescriptor();
            if (table.getKind() == TableDescriptor.Kind.INTERNAL) {
                rootEntry.generateFieldAlias(-1, section.sql);
                separator = 44;
                if (search.sortableFields != null) {
                    search.sortableFields.add(rootEntry.getValidFieldDescriptor(-1));
                }
            }
            for (FieldDescriptor f : table.getFields()) {
                if (sorting != null && sorting.fieldIds != null && sorting.fieldIds.contains(f.getId()) || !search.generateNullFields() && (f.isAbstract() || rootEntry.excludePeriodicData() && f.hasPeriodicStorage())) continue;
                boolean required = false;
                if (f.getType() != DataType.BLOB && (search.generateFileBlobs() || f.getType() != DataType.FILE) || required) {
                    boolean null_field;
                    boolean bl2 = null_field = f.isAbstract() || !search.rootEntry.isFieldSignificant(f.getId());
                    if (null_field && !search.generateNullFields() && !required) continue;
                    section.sql.append((char)separator);
                    if (null_field) {
                        section.sql.append("null").append(' ').append(f.getRawName());
                    } else if (f.hasPeriodicStorage() && !rootEntry.periodicExpanded()) {
                        section.sql.append("null").append(' ').append(f.getRawName());
                    } else if (f.getType() != DataType.BIG_NUMBER) {
                        rootEntry.generateFieldAlias(f, section.sql);
                    } else {
                        rootEntry.generateFieldAliasCasted(f, section.sql);
                        section.sql.append(' ').append(f.getRawName());
                    }
                    separator = 44;
                    if (search.sortableFields == null) continue;
                    search.sortableFields.add(f.isRightPadded() ? null : f);
                    continue;
                }
                search.hasBlobFields(true);
                switch (search.receiveBlobType) {
                    case Length: {
                        if (f.getType() != DataType.FILE) {
                            if (blobs == null) {
                                blobs = new StringBuilder();
                            }
                            blobs.append(", length(");
                            rootEntry.generateFieldAlias(f, blobs);
                            blobs.append(")").append(" as ").append(f.getRawName());
                            break;
                        }
                    }
                    case Content: {
                        if (blobs == null) {
                            blobs = new StringBuilder();
                        }
                        blobs.append(',');
                        rootEntry.generateFieldAlias(f, blobs);
                    }
                }
            }
            if (sorting != null && !Strings.isVoid(sorting.fields)) {
                section.sql.append(',').append((CharSequence)sorting.fields);
            }
            if (blobs != null) {
                section.sql.append((CharSequence)blobs);
            }
        }
        section.append(" from ", from);
        if (from.isEmpty()) {
            section.sql.append(" from ");
        }
        section.append(" where ", whereSection);
        section.append(" start with ", hierarchyRoot);
        section.append(" connect by ", hierarchyConnection);
        if (!search.skipOrderBy() && !search.excludeOrderBy() && sorting != null && sorting.orderBy != null) {
            section.sql.append(search.siblingsSort() && !this.caps.isAnsiHierarchicSyntax() ? " order siblings by " : " order by ").append((CharSequence)sorting.orderBy);
        }
        search.hasFieldsSection(true);
        return section;
    }

    private Generate.Section generateAdvancedSql(Search search) throws IOException {
        search.rootEntry.clearUsedFields();
        search.rootEntry.selected(true);
        search.applyIneffictiveFields();
        this.adjustCondition(search.where);
        this.adjustCondition(search.having);
        this.adjustCondition(search.relations);
        this.adjustCondition(search.hierarchyRoot);
        this.adjustCondition(search.hierarchyConnection);
        Generate.Section fieldsSection = Generate.generateFields(search, this);
        StringBuilder orderBy = null;
        if (!search.isUnionItem() || !search.hasDataFilter() && !search.pagedFetch()) {
            orderBy = Generate.generateAdvancedOrderBy(search, this, fieldsSection);
        }
        Generate.Section whereSection = GenerateCondition.createSection(this, search.where);
        Generate.Section relationsSection = GenerateCondition.createSection(this, search.relations);
        Generate.Section hierarchyRoot = GenerateCondition.createSection(this, search.hierarchyRoot);
        Generate.Section hierarchyConnection = GenerateCondition.createSection(this, search.hierarchyConnection);
        if (relationsSection != null) {
            if (whereSection == null) {
                whereSection = relationsSection;
            } else {
                whereSection.addParameters(relationsSection.sqlParameters);
                whereSection.sql.insert(0, '(').append(')').append(Condition.LogicalOperator.AND.sql).append((CharSequence)relationsSection.sql);
            }
        }
        search.rootEntry.adjustRelations(this.caps);
        for (int i = 0; i < 2; ++i) {
            search.rootEntry.excludeByRelations();
        }
        search.rootEntry.excludeIfExcludedFromConditions(false);
        search.rootEntry.checkIgnored();
        search.rootEntry.ignored(false);
        search.rootEntry.fillUsedFieldsAdvanced(search);
        if (!search.periodicInitialized()) {
            search.periodicInitialized(true);
            if (!search.isHierarchic() || !this.caps.isAnsiHierarchicSyntax()) {
                search.rootEntry.expandPeriodicTables();
            }
        }
        search.hasFieldsSection(fieldsSection != null && fieldsSection.sql.length() != 0);
        Generate.Section fromSection = Generate.generateFrom(search, this);
        search.hasFromSection(fromSection.sql.length() != 0);
        if (!search.hasFromSection() && !search.hasFieldsSection()) {
            return new Generate.Section();
        }
        Generate.Section havingSection = GenerateCondition.createSection(this, search.having);
        Generate.Section groupBySection = null;
        if (Generate.needGroupBy(search, this)) {
            groupBySection = Generate.generateGroupBy(search, this);
            if (fieldsSection.extra != null) {
                if (groupBySection == null) {
                    groupBySection = new Generate.Section();
                } else {
                    groupBySection.sql.append(", ");
                }
                groupBySection.sql.append((CharSequence)fieldsSection.extra);
            }
        } else if (havingSection != null) {
            if (whereSection != null && whereSection.sql.length() != 0) {
                whereSection.sql.insert(0, '(').append(')').append((Object)Condition.LogicalOperator.AND).append('(').append((CharSequence)havingSection.sql).append(')');
                whereSection.addParameters(havingSection.sqlParameters);
            } else {
                whereSection = havingSection;
            }
            havingSection = null;
        }
        Generate.Section section = new Generate.Section();
        section.sql.append("select ");
        this.generateSelectSectionOptimizer(search, section);
        if (search.distinct()) {
            section.sql.append(" distinct ");
        }
        if (search.fetchLimit > 0) {
            this.caps.fetchLimitTop(search.fetchLimit, section.sql);
        }
        if (search.hasFieldsSection()) {
            section.append(fieldsSection);
        }
        section.append(" from ", fromSection);
        section.append(" where ", whereSection);
        section.append(" start with ", hierarchyRoot);
        section.append(" connect by ", hierarchyConnection);
        section.append(" group by ", groupBySection);
        section.append(" having ", havingSection);
        if (!search.excludeOrderBy() && orderBy != null && orderBy.length() != 0) {
            section.sql.append(search.siblingsSort() && !this.caps.isAnsiHierarchicSyntax() ? " order siblings by " : " order by ").append((CharSequence)orderBy);
        }
        search.hasFieldsSection(true);
        return section;
    }

    private Generate.Section generateUnionSql(Search search) throws IOException {
        Generate.Section section = null;
        ArrayList<FieldDescriptor> sortableFields = null;
        for (Search union : search.unions) {
            union.subjectFieldId = search.subjectFieldId;
            Generate.Section unionSection = this.generateSql(union);
            if (section == null) {
                section = unionSection;
                section.sql.insert(0, '(');
                sortableFields = union.sortableFields;
            } else {
                if (search.distinct()) {
                    section.sql.append("\r\nunion\r\n");
                } else {
                    section.sql.append("\r\nunion all\r\n");
                }
                section.sql.append('(');
                section.append(unionSection);
            }
            section.sql.append(')');
            if (union.disabledLockRecords()) {
                search.disabledLockRecords(true);
            }
            if (union.hasPrimaryKeyExpression()) {
                search.hasPrimaryKeyExpression(true);
            }
            if (!union.hasFieldsSection()) continue;
            search.hasFieldsSection(true);
        }
        search.hasFromSection(true);
        if (search.hasDataFilter() || search.pagedFetch()) {
            search.failedSort(true);
            search.useDataFilterAllFields(true);
        } else if (!search.excludeOrderBy() && search.sorting != null && !search.sorting.isEmpty() && sortableFields != null) {
            StringBuilder orderBy = null;
            for (SearchSorting.Field sf : search.sorting.fields()) {
                if (sf.entry.parentEntry != null) {
                    search.failedSort(true);
                    break;
                }
                FieldDescriptor field = null;
                int index = 0;
                for (FieldDescriptor f : sortableFields) {
                    ++index;
                    if (f == null || f.getId() != sf.fieldId) continue;
                    field = f;
                    break;
                }
                if (field == null) {
                    search.failedSort(true);
                    break;
                }
                if (orderBy == null) {
                    orderBy = new StringBuilder();
                } else {
                    orderBy.append(", ");
                }
                if (search.kind == Search.Kind.Standard) {
                    orderBy.append(field.getRawName());
                } else {
                    orderBy.append(index);
                }
                orderBy.append(sf.ascending ? " asc " : " desc ");
            }
            if (!search.failedSort() && !search.excludeOrderBy() && orderBy != null && orderBy.length() != 0) {
                section.sql.append(search.siblingsSort() && !this.caps.isAnsiHierarchicSyntax() ? " order siblings by " : " order by ").append((CharSequence)orderBy);
            }
        }
        return section;
    }

    private Generate.Section generateStandardHierarchicSql(Search search) throws IOException {
        Search hierarchic = new Search(search);
        int rootId = ++search.lastEntryId;
        hierarchic.searchNodeId = search.searchNodeId;
        hierarchic.assignProps(search);
        hierarchic.kind = Search.Kind.Advanced;
        hierarchic.parameters = search.parameters;
        hierarchic.subjects = search.subjects;
        hierarchic.subjectList = search.subjectList;
        if (hierarchic.subjectList != null) {
            for (SubjectEntry subject : hierarchic.subjectList) {
                hierarchic.entries.add(subject);
            }
        }
        hierarchic.entryExclusionMethod = search.entryExclusionMethod;
        hierarchic.parentEntry = search.parentEntry;
        hierarchic.lastEntryId = search.lastEntryId;
        hierarchic.returnedFields = search.returnedFields;
        hierarchic.subjectFieldId = search.subjectFieldId;
        hierarchic.subjectFieldModificator = search.subjectFieldModificator;
        if (search.where != null) {
            hierarchic.where = new Condition(hierarchic, search.where);
        }
        if (search.having != null) {
            hierarchic.having = new Condition(hierarchic, search.having);
        }
        if (search.relations != null) {
            hierarchic.relations = new Condition(hierarchic, search.relations);
        }
        if (search.hierarchyRoot != null) {
            hierarchic.hierarchyRoot = new Condition(hierarchic, search.hierarchyRoot);
        }
        if (search.hierarchyConnection != null) {
            hierarchic.hierarchyConnection = new Condition(hierarchic, search.hierarchyConnection);
        }
        hierarchic.deepSearch = search.isSubject() ? search.getDeepParent() : search.getDeepSearch();
        hierarchic.rootEntry = search.rootEntry;
        HierarchicEntry rootEntry = new HierarchicEntry(rootId, hierarchic, false, null);
        rootEntry.addEntry(search.rootEntry);
        hierarchic.rootEntry = rootEntry;
        rootEntry.fillEntries(hierarchic.entries);
        hierarchic.rootEntry.excludePeriodicDataRecursive();
        hierarchic.additionalFields = new ArrayList();
        hierarchic.additionalFieldNames = new HashSet();
        hierarchic.additionalFieldIds = new IntegerSet();
        TableDescriptor table = rootEntry.getTableDescriptor();
        hierarchic.fields = new SearchFields(table, false);
        int skipFieldId = 0;
        if (table.hasStandartPrimaryKey()) {
            FieldDescriptor recordId = table.getRecordIdField();
            skipFieldId = recordId.getId();
            SearchField field = new SearchField(skipFieldId);
            field.dataType = recordId.getType();
            field.proxyField = recordId;
            field.expression = new FieldExpression();
            field.expression.newField(search.rootEntry.entryId, skipFieldId);
            field.source = "\u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f " + recordId.getCaption() + " [" + skipFieldId + "]";
            field.line = "\u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u043b\u044f ";
            hierarchic.fields.items.add(field);
        }
        List<FieldDescriptor> fields = table.getFields();
        for (FieldDescriptor descriptor : fields) {
            int fieldId = descriptor.getId();
            if (fieldId == skipFieldId) continue;
            SearchField field = new SearchField(fieldId);
            field.proxyField = descriptor;
            field.dataType = descriptor.getType();
            field.source = "\u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f " + field.proxyField.getCaption() + " [" + fieldId + "]";
            field.line = "\u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u043b\u044f ";
            if (!descriptor.isVirtual()) {
                field.expression = new FieldExpression();
                field.expression.newField(search.rootEntry.entryId, field.id);
            }
            hierarchic.fields.items.add(field);
        }
        if (!search.siblingsSort() && search.sorting != null && !search.sorting.isEmpty()) {
            search.failedSort(true);
        } else {
            hierarchic.sorting = search.sorting;
            hierarchic.nullSortKind = search.nullSortKind;
        }
        ++search.maxAlias;
        hierarchic.baseAlias = search.baseAlias;
        Generate.Section section = this.generateAdvancedHierarchicSql(hierarchic);
        search.hasFieldsSection(hierarchic.hasFieldsSection());
        search.hasFromSection(hierarchic.hasFromSection());
        if (hierarchic.failedSort()) {
            search.failedSort(hierarchic.failedSort());
        }
        return section;
    }

    private Search createHierarchicItem(Search search) {
        return this.createHierarchicItem(search, false);
    }

    private Search createHierarchicItem(Search search, boolean isHierarchicBody) {
        Search hierarchicItemSearch = search.parentSearch == null ? new Search(this.topSearch.constants, this.topSearch.timeZoneHost) : new Search(search.parentSearch);
        hierarchicItemSearch.rootEntry = search.rootEntry;
        if (search.fields != null) {
            hierarchicItemSearch.fields = new SearchFields(search.fields, isHierarchicBody);
        }
        hierarchicItemSearch.searchNodeId = search.searchNodeId;
        hierarchicItemSearch.kind = Search.Kind.Advanced;
        hierarchicItemSearch.assignProps(search);
        hierarchicItemSearch.isFilterPreset(true);
        hierarchicItemSearch.isHierarchic(false);
        hierarchicItemSearch.isHierarchicBody(isHierarchicBody);
        hierarchicItemSearch.hasRecursionWithSection(false);
        hierarchicItemSearch.isUnionItem(false);
        hierarchicItemSearch.hasDataFilter(false);
        hierarchicItemSearch.pagedFetch(false);
        hierarchicItemSearch.generateDebugInfo(false);
        hierarchicItemSearch.isNested(false);
        hierarchicItemSearch.distinct(search.distinct());
        if (!isHierarchicBody) {
            hierarchicItemSearch.generateNullFields(true);
            hierarchicItemSearch.isSubject(false);
        } else {
            hierarchicItemSearch.subjectFieldId = search.subjectFieldId;
            hierarchicItemSearch.subjectFieldModificator = search.subjectFieldModificator;
            hierarchicItemSearch.parentEntry = search.parentEntry;
        }
        hierarchicItemSearch.parameters = search.parameters;
        hierarchicItemSearch.returnedFields = search.returnedFields;
        if (search.subjects != null && !search.subjects.empty()) {
            hierarchicItemSearch.subjects = new IntegerHash();
            hierarchicItemSearch.subjectList = new ArrayList();
            for (SubjectEntry subject : search.subjectList) {
                SubjectEntry s = new SubjectEntry(hierarchicItemSearch, subject);
                hierarchicItemSearch.subjects.add(s);
                hierarchicItemSearch.subjectList.add(s);
                hierarchicItemSearch.entries.add(s);
            }
        }
        return hierarchicItemSearch;
    }

    private Generate.Section generateAdvancedHierarchicSql(Search search) throws IOException {
        String recursionName = "RecursionEntry_" + NumberConverter.doubleToString(search.rootTableId()) + "_" + search.nextWithId();
        for (SearchField field : search.fields.items) {
            search.additionalFieldIds.add(field.id);
        }
        ++search.lastEntryId;
        int hierarchicId = search.lastEntryId++;
        int priorId = search.lastEntryId;
        ArrayList additionalFields = new ArrayList();
        if (search.where != null) {
            search.where.adjustAnsiHierarchic(hierarchicId, this.caps, true);
        }
        if (search.hierarchyConnection != null) {
            search.hierarchyConnection.adjustAnsiHierarchic(priorId, this.caps, false);
        }
        search.newAdditionalFieldId("R", -10, 1, DataType.INTEGER, 0, false);
        SearchField sortField = null;
        if (search.siblingsSort() && search.sorting != null && !search.sorting.isEmpty() && !search.distinct()) {
            SearchSorting.Field sf = search.sorting.fields().get(0);
            if (sf.entry == null) {
                search.failedSort(true);
            } else {
                FieldDescriptor fieldDescriptor = sf.entry.getValidFieldDescriptor(sf.fieldId, "\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0435", "\u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438", 1);
                sortField = search.createAdditionalFieldId("R", sf.entry.entryId, sf.fieldId, fieldDescriptor.getType(), fieldDescriptor.getSize(), fieldDescriptor.isNullable());
                sortField.hierarchicSort(true);
            }
        }
        Search hierarchySearch = this.createHierarchicItem(search);
        hierarchySearch.unions = new ArrayList();
        hierarchySearch.rootEntry.reset();
        hierarchySearch.baseAlias = search.parentSearch != null && search.parentSearch.isHierarchicBody() ? search.parentSearch.maxAlias : this.topSearch.maxAlias;
        hierarchySearch.maxAlias = this.topSearch.maxAlias = hierarchySearch.initEntryAlias(hierarchySearch.baseAlias);
        Search hierarchyRootSearch = this.createHierarchicItem(hierarchySearch);
        hierarchyRootSearch.deepSearch = search.getDeepSearch();
        hierarchyRootSearch.setSubjectsDeepParent();
        hierarchyRootSearch.isHierarchicRootSection(true);
        HierarchicEntry hierarchyRootEntry = new HierarchicEntry(hierarchicId, hierarchyRootSearch, true, recursionName);
        hierarchyRootSearch.rootEntry = hierarchyRootEntry;
        hierarchyRootSearch.fields.addAdditionalFields(this.caps, search, hierarchyRootSearch, hierarchicId);
        if (sortField != null) {
            hierarchyRootSearch.fields.addAdditionalField(this.caps, search, hierarchyRootSearch, hierarchicId, sortField);
        }
        if (search.hierarchyRoot != null && !search.hierarchyRoot.isEmpty()) {
            hierarchyRootSearch.where = new Condition(hierarchyRootSearch, search.hierarchyRoot);
        }
        hierarchyRootEntry.fillEntries(hierarchyRootSearch.entries);
        hierarchySearch.unions.add(hierarchyRootSearch);
        Search hierarchyConnectionSearch = this.createHierarchicItem(hierarchySearch);
        hierarchyConnectionSearch.deepSearch = search.getDeepSearch();
        hierarchyConnectionSearch.setSubjectsDeepParent();
        hierarchyConnectionSearch.isHierarchicConditionSection(true);
        HierarchicEntry hierarchyConnectionRootEntry = new HierarchicEntry(hierarchicId, hierarchyConnectionSearch, true, recursionName);
        hierarchyConnectionSearch.rootEntry = hierarchyConnectionRootEntry;
        HierarchicEntry hierarchyConnectionEntry = new HierarchicEntry(priorId, hierarchyConnectionSearch, false, recursionName);
        if (search.hierarchyConnection != null && !search.hierarchyConnection.isEmpty()) {
            hierarchyConnectionEntry.fieldBindings = new Condition(hierarchyConnectionSearch, search.hierarchyConnection);
            hierarchyConnectionEntry.hasExplicitRelations(true);
        }
        hierarchyConnectionRootEntry.addEntry(hierarchyConnectionEntry);
        hierarchyConnectionRootEntry.addRelated(hierarchyConnectionEntry);
        hierarchyConnectionSearch.fields.addAdditionalFields(this.caps, search, hierarchyConnectionSearch, priorId);
        if (sortField != null) {
            hierarchyConnectionSearch.fields.addAdditionalField(this.caps, search, hierarchyConnectionSearch, hierarchicId, sortField);
        }
        hierarchyConnectionRootEntry.fillEntries(hierarchyConnectionSearch.entries);
        hierarchySearch.unions.add(hierarchyConnectionSearch);
        hierarchySearch.distinct(false);
        hierarchySearch.rootEntry.reset();
        hierarchySearch.maxAlias = hierarchySearch.initEntryAlias(hierarchySearch.baseAlias);
        Generate.Section section = this.generateUnionSql(hierarchySearch);
        search.hasFieldsSection(hierarchySearch.hasFieldsSection());
        search.hasFromSection(hierarchySearch.hasFromSection());
        search.hasPrimaryKeyExpression(hierarchySearch.hasPrimaryKeyExpression());
        StringBuilder withSql = new StringBuilder();
        if (this.caps.isPostgreSqlHierarchicSyntax()) {
            withSql.append("recursive ");
        }
        withSql.append(recursionName).append("(");
        int comma = 32;
        for (SearchField field : hierarchyRootSearch.fields.items) {
            if (!field.generated()) continue;
            withSql.append((char)comma).append(field.proxyField.getRawName());
            comma = 44;
        }
        withSql.append(")").append(" as ").append("(").append("\r\n");
        section.sql.insert(0, withSql);
        section.sql.append("\r\n").append(")").append("\r\n");
        search.incWithId();
        Search body = this.createHierarchicItem(search, true);
        body.generateNullFields(search.generateNullFields());
        HierarchicEntry bodyRootEntry = new HierarchicEntry(search.rootEntry.entryId, body, false, recursionName);
        body.rootEntry = bodyRootEntry;
        HierarchicEntry bodyEntry = new HierarchicEntry(hierarchicId, body, false, recursionName);
        bodyRootEntry.addEntry(bodyEntry);
        bodyRootEntry.setAdditionalFields(search.additionalFields);
        bodyEntry.setAdditionalFields(search.additionalFields);
        if (sortField != null) {
            bodyEntry.additionalFields.add(sortField);
        }
        if (search.where != null) {
            body.where = new Condition(body, search.where);
        }
        if (search.having != null) {
            body.having = new Condition(body, search.having);
        }
        if (search.relations != null) {
            body.relations = new Condition(body, search.relations);
        }
        for (SearchField searchField : body.fields.items) {
            if (!searchField.hasExpression()) continue;
            searchField.expression = new FieldExpression();
            searchField.expression.newField(hierarchicId, searchField.id);
        }
        if (sortField != null) {
            SearchField sf = new SearchField(sortField.id);
            sf.proxyField = sortField.proxyField;
            sf.expression = new FieldExpression();
            sf.expression.newField(hierarchicId, sf.id);
            body.fields.items.add(sf);
            sortField = sf;
        }
        bodyRootEntry.fillEntries(body.entries);
        if (search.subjects != null && !search.subjects.empty() && !search.rootEntry.isEmpty()) {
            int replaceEntryId = search.rootEntry.children.get((int)0).entryId;
            for (SubjectEntry subject : body.subjectList) {
                ParametersList parameters = subject.parameters();
                if (parameters == null) continue;
                for (Parameter parameter : parameters.values()) {
                    int bindintEntryId = parameter.getDatasourceBinding();
                    if (bindintEntryId != replaceEntryId) continue;
                    parameter.setDatasourceBinding(hierarchicId);
                }
            }
        }
        body.deepSearch = search.isSubject() ? search.getDeepSearch() : body;
        body.setSubjectsDeepParent();
        body.rootEntry.reset();
        body.maxAlias = body.initEntryAlias(search.baseAlias);
        Generate.Section bodySection = this.generateSql(body);
        if (sortField != null && !search.excludeOrderBy()) {
            SearchSorting.Field field = search.sorting.fields().get(0);
            bodySection.sql.append(search.siblingsSort() && !this.caps.isAnsiHierarchicSyntax() ? " order siblings by " : " order by ").append(sortField.position).append(field.ascending ? " asc " : " desc ");
        }
        section.append(bodySection);
        return section;
    }

    private Generate.Section generateWithSections(Search search, Generate.Section section) {
        Generate.Section[] withSections = new Generate.Section[]{null};
        search.rootEntry.process(searchEntry -> {
            Generate.Section withSection;
            if (!(searchEntry instanceof NestedEntry)) {
                return;
            }
            NestedEntry entry = (NestedEntry)searchEntry;
            if (!entry.selected() || entry.cteSection == null) {
                return;
            }
            if (withSections[0] == null) {
                withSection = withSections[0] = new Generate.Section();
                withSection.sql.append("\r\n").append("with ");
                boolean appendNewLine = false;
            } else {
                withSection = withSections[0];
                withSection.sql.append(", ");
                boolean appendNewLine = true;
            }
            entry.generateCTEAlias(withSection.sql);
            withSection.sql.append(" as ").append('(').append("\r\n");
            withSection.append(entry.cteSection);
            withSection.sql.append("\r\n").append(')').append("\r\n");
        });
        Generate.Section withSection = withSections[0];
        if (search.hasRecursionWithSection()) {
            if (withSection == null) {
                withSection = new Generate.Section();
                withSection.sql.append("\r\n").append("with ");
            } else {
                withSection.sql.append(", ");
            }
        }
        if (withSection == null) {
            return section;
        }
        withSection.append(section);
        return withSection;
    }

    private Generate.Section generateStoredProcedureSql(Search search) {
        if (Strings.isVoid(search.storedProcedureName)) {
            throw new Search.Exception(search, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b");
        }
        search.disabledLockRecords(true);
        search.hasFromSection(true);
        Generate.Section section = null;
        if (search.parameters != null) {
            for (Parameter p : search.parameters.values()) {
                if (p.getIsIgnored()) {
                    if (section == null) {
                        section = new Generate.Section();
                    } else {
                        section.sql.append(", ");
                    }
                    section.sql.append("null");
                    continue;
                }
                if (p.getValueCount() != 1) {
                    String msg = "\u0427\u0438\u0441\u043b\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + p.getCaption() + "[" + p.getId() + "] \u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0440\u0430\u0432\u043d\u044f\u0442\u044c\u0441\u044f 1";
                    throw new Search.Exception(search, msg);
                }
                if (section == null) {
                    section = new Generate.Section();
                } else {
                    section.sql.append(", ");
                }
                Generate.parameterValues(search, this.caps, section, p.getDataType(), p);
            }
        }
        if (section == null) {
            section = new Generate.Section();
        }
        StringBuilder spName = new StringBuilder();
        StringBuilder fields = null;
        DatabaseDescriptor databaseDescriptor = null;
        TableDescriptor table = null;
        if (search.rootEntry != null && (table = search.rootEntry.getTableDescriptor()) != null) {
            databaseDescriptor = table.getDbDescIfExists();
        }
        if (databaseDescriptor == null) {
            spName.append(search.storedProcedureName);
        } else {
            databaseDescriptor.appendTableRawName(search.storedProcedureName, spName);
            if (search.isSubject()) {
                FieldDescriptor field = table.getExistingFieldDescriptor(search.subjectFieldId);
                fields = new StringBuilder();
                fields.append(field.getRawName());
            } else {
                if (table.getKind() == TableDescriptor.Kind.INTERNAL) {
                    fields = new StringBuilder();
                    fields.append("ID");
                }
                block4: for (FieldDescriptor field : table.getFields()) {
                    switch (field.getType()) {
                        case BLOB: 
                        case FILE: {
                            continue block4;
                        }
                    }
                    if (field.isVirtual()) continue;
                    if (fields == null) {
                        fields = new StringBuilder();
                    } else {
                        fields.append(", ");
                    }
                    fields.append(field.getRawName());
                }
            }
        }
        StringBuilder sql = section.sql;
        section.sql = new StringBuilder();
        this.caps.g_storedProcedureExecuteSql(sql, spName, fields, section.sql);
        return section;
    }
}

