/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.taggedio.TaggedReader;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.sql.engine.GenerateFieldExpression;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.types.DataType;
import java.io.IOException;
import java.util.ArrayList;

public class FieldExpression {
    ArrayList<Item> items;
    Terms terms;

    public FieldExpression() {
    }

    public FieldExpression(FieldExpression expression) {
        if (!expression.isEmpty()) {
            this.items = new ArrayList(expression.items.size());
            for (Item item : expression.items) {
                this.items.add(new Item(item));
            }
        }
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public Item newItem(Kind kind) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        Item item = new Item(kind);
        this.items.add(item);
        return item;
    }

    public Item newField(int entryId, int fieldId) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        Item item = new Item(Kind.Field);
        this.items.add(item);
        item.entryId = entryId;
        item.fieldId = fieldId;
        return item;
    }

    public void loadTag(TaggedReader in, Item item) throws IOException {
        assert (item != null);
        if (in.getCurrentTag() != 18) {
            item.null_val = false;
        }
        switch (in.getCurrentTag()) {
            case 3: {
                item.braceCount = in.getInt();
                break;
            }
            case 4: {
                item.entryId = in.getInt();
                break;
            }
            case 5: {
                item.fieldId = in.getInt();
                break;
            }
            case 6: {
                item.function = Function.fromInt(in.getInt());
                break;
            }
            case 16: {
                item.entryId = -1;
                item.fieldId = in.getInt();
                break;
            }
            case 17: {
                item.typeCast = TypeCast.fromInt(in.getInt());
                break;
            }
            case 15: {
                item.scale = in.getInt();
                break;
            }
            case 10: {
                if (item.dataType != DataType.BOOLEAN) {
                    item.dataType = DataType.INTEGER;
                }
                item.int_val = in.getInt();
                break;
            }
            case 11: {
                switch (item.dataType) {
                    case INTERVAL: 
                    case FLOAT: {
                        break;
                    }
                    default: {
                        item.dataType = DataType.FLOAT;
                    }
                }
                item.dbl_val = in.getDouble();
                break;
            }
            case 13: {
                item.dataType = DataType.DATE_TIME;
                item.dbl_val = in.getDouble();
                break;
            }
            case 12: {
                item.dataType = DataType.STRING;
                item.str_val = in.getString();
                break;
            }
            case 14: {
                item.null_val = true;
                break;
            }
            case 18: {
                item.dataType = DataType.getDataTypeById(in.getInt());
            }
        }
    }

    public void load(TaggedReader in) throws IOException {
        this.items = new ArrayList();
        Item item = null;
        while (in.next()) {
            if (in.getCurrentTag() == 7) {
                item = this.newItem(Kind.fromInt(in.getInt()));
                continue;
            }
            this.loadTag(in, item);
        }
    }

    public void fillUsedFields(SearchEntry entry) {
        if (this.terms == null || this.terms.isEmpty()) {
            return;
        }
        for (Term term : this.terms) {
            if (term.token != Token.Argument || term.item.kind != Kind.Field || term.item.entryId != entry.entryId) continue;
            entry.addUsedField(term.item.fieldId);
        }
    }

    Terms adjust(Search search, DatabaseCaps caps, SearchField field) {
        if (this.terms == null) {
            this.terms = GenerateFieldExpression.parse(search, caps, field, this.items);
        }
        return this.terms;
    }

    static class Terms
    extends ArrayList<Term> {
        private int index = 0;

        Terms() {
        }

        public void reset() {
            this.index = 0;
        }

        public void reset(int index) {
            this.index = index;
        }

        public int save() {
            return this.index;
        }

        public boolean valid() {
            return 0 <= this.index && this.index < this.size();
        }

        public Term current() {
            return (Term)this.get(this.index);
        }

        public void next() {
            ++this.index;
        }
    }

    static class Term {
        final Token token;
        final Item item;

        Term(Token token, Item item) {
            this.token = token;
            this.item = item;
        }
    }

    static enum Token {
        Operator,
        Argument,
        Function,
        OpenBrace,
        CloseBrace,
        SoftBrace,
        CloseSoftBrace,
        Inline,
        Concat;

    }

    public static class Item {
        public Kind kind;
        public int braceCount = 0;
        public Function function = Function.NONE;
        public int entryId = 0;
        public int fieldId = 0;
        public DataType dataType = DataType.NONE;
        public int int_val = 0;
        public double dbl_val = 0.0;
        public String str_val = "";
        public boolean null_val = false;
        public int scale = 0;
        public TypeCast typeCast = TypeCast.NONE;
        public boolean ignored = false;
        public boolean autoNotNull = false;
        public int lineNo = 0;

        public Item(Kind kind) {
            this.kind = kind;
            this.null_val = kind == Kind.TypedValue || kind == Kind.Value;
        }

        public Item(Kind kind, boolean isNull) {
            this.kind = kind;
            this.null_val = isNull;
        }

        public Item(int value) {
            this.kind = Kind.Value;
            this.dataType = DataType.INTEGER;
            this.int_val = value;
            this.dbl_val = this.int_val;
        }

        public Item(Item item) {
            this.kind = item.kind;
            this.braceCount = item.braceCount;
            this.function = item.function;
            this.entryId = item.entryId;
            this.fieldId = item.fieldId;
            this.dataType = item.dataType;
            this.int_val = item.int_val;
            this.dbl_val = item.dbl_val;
            this.str_val = item.str_val;
            this.null_val = item.null_val;
            this.scale = item.scale;
            this.typeCast = item.typeCast;
            this.ignored = item.ignored;
            this.autoNotNull = item.autoNotNull;
            this.lineNo = item.lineNo;
        }
    }

    static enum TypeCast {
        NONE(0),
        Bool(1),
        Number(2);

        private final int typeId;
        static final TypeCast[] items;

        private TypeCast(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static TypeCast fromInt(int typeId) {
            if (0 <= typeId && typeId < items.length) {
                return items[typeId];
            }
            return NONE;
        }

        static {
            items = TypeCast.values();
        }
    }

    static enum Kind {
        Field(0),
        Function(1),
        Value(2),
        Parameter(3),
        SystemField(4),
        TypedValue(5);

        private final int typeId;
        static final Kind[] items;

        private Kind(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static Kind fromInt(int typeId) {
            if (0 <= typeId && typeId < items.length) {
                return items[typeId];
            }
            return Field;
        }

        static {
            items = Kind.values();
        }
    }
}

