/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

public enum Function {
    NONE(0),
    Add(1),
    Div(2),
    Mul(3),
    Sub(4),
    Day(5),
    Month(6),
    Year(7),
    RoundTo(8),
    NotNullValue(9),
    Abs(10),
    Hour(11),
    Minute(12),
    Second(13),
    ExtractDate(14),
    FirstValue(15),
    BlobSize(16),
    Mod(17),
    Inline(18),
    Quarter(19),
    Trunc(20),
    MonthsBetween(21),
    TruncDateYear(22),
    TruncDateMonth(23),
    TruncDateQuarter(24),
    TruncDateHour(25),
    ToDate(26),
    ToNumber(27),
    AddMonths(28),
    RegexpSubstr(29),
    AddSeparators(30),
    DaysBetween(31),
    NumberToString(32),
    TruncDateWeek(33),
    AddDays(34),
    DateValue(35),
    PramValues(36),
    Delimiter(37),
    MonthEndDate(28),
    Unknown(-1);

    private final int typeId;
    static final Function[] items;

    private Function(int value) {
        this.typeId = value;
    }

    public int toInt() {
        return this.typeId;
    }

    public static Function fromInt(int typeId) {
        if (0 <= typeId && typeId < items.length) {
            return items[typeId];
        }
        return Unknown;
    }

    public int toCapsDatePart() {
        switch (this) {
            case Day: {
                return 0;
            }
            case Month: {
                return 1;
            }
            case Year: {
                return 2;
            }
            case Hour: {
                return 3;
            }
            case Minute: {
                return 4;
            }
            case Second: {
                return 5;
            }
            case ExtractDate: {
                return 6;
            }
        }
        return -1;
    }

    static {
        items = Function.values();
    }
}

