/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.TimeInfo;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.sql.engine.Condition;
import inform.agent.db.sql.engine.Engine;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.GenerateFieldExpression;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.types.DataType;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Parameter;
import java.io.IOException;
import java.util.ArrayList;

public class GenerateCondition {
    public static Generate.Section createSection(Engine engine, Condition condition) {
        if (condition == null || condition.isEmpty()) {
            return null;
        }
        condition.prepare();
        if (condition.plainItems.isEmpty()) {
            return null;
        }
        Parser parser = new Parser(engine, condition);
        Term root = parser.parse();
        if (root == null) {
            return null;
        }
        Result result = new Result();
        root.collapse(result);
        root = result.term;
        if (root == null) {
            return null;
        }
        Generate.Section section = new Generate.Section();
        root.generate(engine, condition, section);
        return section;
    }

    static class Operand {
        Condition.Operand operand;
        DataType dataType = DataType.NONE;
        Parameter parameter;
        SearchEntry entry;
        FieldDescriptor field;
        SearchField rootField;
        FieldExpression expression;
        int lineNo = -1;
        Search search;

        Operand() {
        }

        boolean isNullOperand() {
            if (this.field != null || this.expression != null) {
                return false;
            }
            if (this.parameter != null) {
                if (this.parameter.getDatasourceBinding() != 0 && this.parameter.getFieldBinding() != 0) {
                    return false;
                }
                return this.parameter.getIsIgnored() || this.parameter.getIsNull();
            }
            return this.operand.kind == Condition.Operand.Kind.Null;
        }

        boolean isSubject() {
            return this.entry != null && this.entry.isSubject();
        }

        boolean isMultiple() {
            if (this.operand != null && this.operand.kind == Condition.Operand.Kind.Parameter && this.parameter != null) {
                if (this.parameter.isWithNull()) {
                    return this.parameter.getValueCount() > 0;
                }
                return this.parameter.getValueCount() > 1;
            }
            return false;
        }

        void get(Condition condition, Condition.Item item, Condition.Operand source) {
            this.operand = source;
            this.dataType = source.dataType;
            switch (source.kind) {
                case Null: 
                case Value: {
                    break;
                }
                case Parameter: {
                    this.parameter = condition.search.getValidParameter(source.fieldId, condition.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                    if (this.parameter.getDatasourceBinding() != 0 && this.parameter.getFieldBinding() != 0) {
                        Search deepSearch = condition.search.getDeepSearch();
                        assert (deepSearch != null);
                        deepSearch = deepSearch.throughSearch(this.parameter.getParamBinding());
                        this.getField(deepSearch, this.parameter.getDatasourceBinding(), this.parameter.getFieldBinding(), condition, item);
                        this.parameter = null;
                        break;
                    }
                    this.dataType = this.parameter.getDataType();
                    break;
                }
                case Field: {
                    this.getField(condition.search, source.entryId, source.fieldId, condition, item);
                    break;
                }
                default: {
                    throw new Search.Exception(condition.search, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 " + condition.source + " (\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 : " + item.lineNo + ")");
                }
            }
        }

        void getField(Search search, int entryId, int fieldId, Condition condition, Condition.Item item) {
            this.search = search;
            this.entry = this.search.getValidEntry(entryId, condition.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
            this.field = this.entry.getValidFieldDescriptor(fieldId, condition.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
            this.dataType = this.field.getType();
            if (this.search.kind == Search.Kind.Advanced && !this.search.isHierarchicConditionSection() && !this.entry.isSubject() && this.entry.isRoot()) {
                this.rootField = this.search.fields.find(this.field.getId());
                if (this.rootField != null && !this.rootField.hasExpression() && this.rootField.function != AggregateFunction.CountEx) {
                    throw new Search.Exception(condition.search, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044f " + this.field.getCaption() + " \u0432 " + condition.source + " (\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 : " + item.lineNo + ")");
                }
            }
        }

        boolean getExpression(Condition condition, Condition.Item item, FieldExpression expression) {
            if (expression == null || expression.isEmpty()) {
                return false;
            }
            this.expression = expression;
            this.lineNo = item.lineNo;
            for (FieldExpression.Item operand : expression.items) {
                switch (operand.kind) {
                    case Field: {
                        this.dataType = condition.search.getValidFieldType(operand.entryId, operand.fieldId, condition.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                        if (this.dataType == DataType.NONE) break;
                        return true;
                    }
                    case Value: 
                    case TypedValue: {
                        this.dataType = operand.dataType;
                        if (this.dataType == DataType.NONE) break;
                        return true;
                    }
                    case Parameter: {
                        this.dataType = condition.search.getValidFieldType(-1, operand.fieldId, condition.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                        if (this.dataType == DataType.NONE) break;
                        return true;
                    }
                    case SystemField: {
                        this.dataType = condition.search.getValidFieldType(-10, operand.fieldId, condition.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                        if (this.dataType == DataType.NONE) break;
                        return true;
                    }
                }
            }
            return true;
        }

        Argument createParameter() {
            assert (this.parameter != null);
            if (this.parameter.getIsIgnored() || this.parameter.getValueCount() == 0) {
                return new ValueArg(this.dataType);
            }
            assert (this.parameter.getDatasourceBinding() == 0 && this.parameter.getFieldBinding() == 0);
            return new ParamArg(this.dataType, this.parameter);
        }

        Argument createArgument(boolean havingContext) {
            if (this.field != null) {
                return new FieldArg(this.search, this.entry, this.field, this.rootField, this.operand.prior, this.operand.function);
            }
            if (this.parameter != null) {
                return this.createParameter();
            }
            if (this.expression != null) {
                return new ExpressionArg(this.dataType, this.expression, havingContext, this.lineNo);
            }
            if (this.operand.kind == Condition.Operand.Kind.Null) {
                return new ValueArg(this.dataType);
            }
            switch (this.dataType.toSqlDataType()) {
                case BOOLEAN: 
                case INTEGER: {
                    return new ValueArg(this.dataType, this.operand.int_val);
                }
                case DOUBLE: 
                case DATE_TIME: 
                case TIMESTAMP: {
                    return new ValueArg(this.dataType, this.operand.dbl_val);
                }
                case STRING: 
                case UNICODE: {
                    return new ValueArg(this.dataType, this.operand.str_val);
                }
            }
            return new ValueArg(this.dataType);
        }
    }

    static class ExpressionArg
    extends Argument {
        final FieldExpression expression;
        final boolean havingContext;
        final int lineNo;

        ExpressionArg(DataType dataType, FieldExpression expression, boolean havingContext, int lineNo) {
            super(ArgumentKind.Expression, dataType);
            this.expression = expression;
            this.havingContext = havingContext;
            this.lineNo = lineNo;
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section, Condition.Operator operator, boolean inlineValue, int lineNo) {
            this.escapeChar = '\u0000';
            SearchField rootField = new SearchField(Integer.MAX_VALUE);
            rootField.dataType = this.dataType;
            rootField.expression = this.expression;
            rootField.source = condition.source;
            rootField.line = "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ";
            rootField.lineNo = this.lineNo;
            section.sql.append('(');
            GenerateFieldExpression.generate(condition.search, engine, this.havingContext, section, rootField);
            section.sql.append(')');
        }
    }

    static class ParamArg
    extends Argument {
        final Parameter parameter;

        ParamArg(DataType dataType, Parameter parameter) {
            super(ArgumentKind.Param, dataType);
            this.parameter = parameter;
        }

        @Override
        boolean isNull() {
            return this.parameter == null || this.parameter.getIsIgnored() || this.parameter.getIsNull();
        }

        @Override
        boolean isNotNull() {
            return !this.isNull();
        }

        @Override
        boolean swapable() {
            return this.parameter != null && !this.parameter.getIsIgnored();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void generate(Engine engine, Condition condition, Generate.Section section, Condition.Operator operator, boolean inlineValue, int lineNo) {
            boolean need_braces;
            this.escapeChar = '\u0000';
            int sep = 32;
            boolean bl = need_braces = operator == Condition.Operator.In || operator == Condition.Operator.NotIn || this.parameter.getValueCount() > 1;
            if (need_braces) {
                section.sql.append('(');
            }
            if (condition.search.inlineParams() || inlineValue) {
                switch (operator) {
                    case LikeEx: 
                    case NotLikeEx: {
                        if (this.dataType == DataType.STRING) {
                            if (this.parameter.getValueCount() == 1) {
                                this.escapeChar = engine.caps.getEscapeLikeChar(this.parameter.getAsString());
                            } else {
                                StringBuilder value = new StringBuilder();
                                int count = this.parameter.getValueCount();
                                for (int i = 0; i < count; ++i) {
                                    Object v = this.parameter.valueByIndex(i);
                                    if (v == null) continue;
                                    value.append(v.toString());
                                }
                                this.escapeChar = engine.caps.getEscapeLikeChar(value.toString());
                            }
                            int count = this.parameter.getValueCount();
                            for (int i = 0; i < count; ++i) {
                                Object v = this.parameter.valueByIndex(i);
                                if (v == null) continue;
                                section.sql.append((char)sep).append(engine.caps.c_string2sql("%" + engine.caps.toLikeString(v.toString(), this.escapeChar) + "%"));
                                sep = 44;
                            }
                            break;
                        }
                    }
                    default: {
                        Generate.parameterValues(condition.search, engine.caps, section, this.parameter.getDataType(), this.parameter);
                        break;
                    }
                }
            } else {
                switch (operator) {
                    case LikeEx: 
                    case NotLikeEx: {
                        if (this.dataType == DataType.STRING) {
                            if (this.parameter.getValueCount() == 1) {
                                this.escapeChar = engine.caps.getEscapeLikeChar(this.parameter.getAsString());
                            } else {
                                StringBuilder value = new StringBuilder();
                                int count = this.parameter.getValueCount();
                                for (int i = 0; i < count; ++i) {
                                    Object v = this.parameter.valueByIndex(i);
                                    if (v == null) continue;
                                    value.append(v.toString());
                                }
                                this.escapeChar = engine.caps.getEscapeLikeChar(value.toString());
                            }
                            int count = this.parameter.getValueCount();
                            for (int i = 0; i < count; ++i) {
                                Object v = this.parameter.valueByIndex(i);
                                if (v == null) continue;
                                section.sql.append((char)sep).append('?');
                                sep = 44;
                                section.addStringParam("%" + engine.caps.toLikeString(v.toString(), this.escapeChar) + "%");
                            }
                            break;
                        }
                    }
                    default: {
                        Generate.parameterValues(condition.search, engine.caps, section, this.parameter.getDataType(), this.parameter);
                    }
                }
            }
            if (need_braces) {
                section.sql.append(')');
            }
        }
    }

    static class FieldArg
    extends Argument {
        final Search search;
        final SearchEntry entry;
        final FieldDescriptor field;
        final SearchField rootField;
        final boolean prior;
        final Function function;
        int modificator = 0;

        FieldArg(Search search, SearchEntry entry, FieldDescriptor field, SearchField rootField, boolean prior, Function function) {
            super(ArgumentKind.Field, field.getType());
            this.search = search;
            this.entry = entry;
            this.field = field;
            this.rootField = rootField;
            this.prior = prior;
            this.function = function;
        }

        @Override
        boolean swapable() {
            return this.entry == null || !this.entry.isSubject();
        }

        @Override
        boolean setModificator(int modificator) {
            if (this.entry != null && this.entry.isSubject()) {
                this.modificator = modificator;
                return true;
            }
            return super.setModificator(modificator);
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section, Condition.Operator operator, boolean inlineValue, int lineNo) throws IOException {
            this.escapeChar = '\u0000';
            String suffix = null;
            if (this.prior) {
                section.sql.append("prior ");
            }
            switch (this.function) {
                case BlobSize: {
                    if (this.dataType != DataType.BLOB) break;
                    section.sql.append(" length(");
                    suffix = ")";
                }
            }
            if (this.entry != null && this.entry.isSubject()) {
                assert (this.entry.inplaceSearch != null);
                try {
                    this.entry.inplaceSearch.setSubjectField(this.field.getId(), this.modificator);
                    Generate.Section subject = engine.generateEntrySql(this.entry.inplaceSearch, this.entry);
                    section.addParameters(subject.sqlParameters);
                    if (this.entry.inplaceSearch.isUnions()) {
                        section.sql.append('(').append("select ").append("T.").append(this.field.getRawName()).append(" from ").append('(').append((CharSequence)subject.sql).append(") T)");
                    }
                    section.sql.append('(').append((CharSequence)subject.sql).append(')');
                }
                catch (Search.Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new Search.Exception(condition.search, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 " + condition.source + " (\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 " + lineNo + ")", e);
                }
            } else if (this.rootField != null) {
                GenerateFieldExpression.generate(this.search, engine, condition.havingContext, section, this.rootField);
            } else if (this.entry != null) {
                this.entry.generateFieldAlias(this.field, section.sql);
            }
            if (suffix != null) {
                section.sql.append(suffix);
            }
        }
    }

    static class NotNullArg
    extends Argument {
        final Argument arg1;
        final Argument arg2;

        NotNullArg(Argument arg1, Argument arg2) {
            super(ArgumentKind.Value, arg1.dataType != DataType.NONE ? arg1.dataType : arg2.dataType);
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        boolean isNull() {
            return this.arg1.isNull() && this.arg2.isNull();
        }

        @Override
        boolean isNotNull() {
            return !this.arg1.isNull() || !this.arg2.isNull();
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section, Condition.Operator operator, boolean inlineValue, int lineNo) throws IOException {
            this.escapeChar = '\u0000';
            section.sql.append(' ').append("coalesce(");
            this.arg1.generate(engine, condition, section, operator, inlineValue, lineNo);
            section.sql.append(',');
            this.arg2.generate(engine, condition, section, operator, inlineValue, lineNo);
            section.sql.append(')');
        }
    }

    static class ValueArg
    extends Argument {
        final boolean null_val;
        int int_val;
        double dbl_val;
        String str_val;

        ValueArg(DataType dataType) {
            super(ArgumentKind.Value, dataType);
            this.null_val = true;
        }

        ValueArg(DataType dataType, int int_val) {
            super(ArgumentKind.Value, dataType);
            this.null_val = false;
            this.int_val = int_val;
        }

        ValueArg(DataType dataType, double dbl_val) {
            super(ArgumentKind.Value, dataType);
            this.null_val = false;
            this.dbl_val = dbl_val;
        }

        ValueArg(DataType dataType, String str_val) {
            super(ArgumentKind.Value, dataType);
            this.null_val = false;
            this.str_val = str_val;
        }

        ValueArg(ValueArg arg) {
            super(arg.kind, arg.dataType);
            this.null_val = arg.null_val;
            this.int_val = arg.int_val;
            this.dbl_val = arg.dbl_val;
            this.str_val = arg.str_val;
        }

        @Override
        boolean isNull() {
            return this.null_val;
        }

        @Override
        boolean isNotNull() {
            return !this.null_val;
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section, Condition.Operator operator, boolean inlineValue, int lineNo) {
            this.escapeChar = '\u0000';
            if (this.null_val) {
                if (condition.search.inlineParams() || this.dataType == DataType.NONE) {
                    section.sql.append("null");
                } else {
                    section.sql.append('?');
                    section.addNullParam(this.dataType);
                }
            } else {
                switch (this.dataType) {
                    case INTEGER: {
                        if (condition.search.inlineParams() || inlineValue) {
                            section.sql.append(this.int_val);
                            break;
                        }
                        section.sql.append('?');
                        section.addIntegerParam(this.int_val);
                        break;
                    }
                    case BOOLEAN: {
                        if (condition.search.inlineParams() || inlineValue) {
                            section.sql.append(engine.caps.c_bool2sql(this.int_val != 0));
                            break;
                        }
                        section.sql.append('?');
                        section.addBooleanParam(this.int_val != 0);
                        break;
                    }
                    case PRIMARY_KEY: 
                    case FLOAT: 
                    case INTERVAL: 
                    case DIRECTORY: 
                    case METATREE_NODE: {
                        if (condition.search.inlineParams()) {
                            section.sql.append(engine.caps.c_float2sql(this.dbl_val));
                            break;
                        }
                        section.sql.append('?');
                        section.addDoubleParam(this.dbl_val);
                        break;
                    }
                    case DATE_TIME: {
                        if (condition.search.inlineParams()) {
                            section.sql.append(engine.caps.c_dateTime2sql(this.dbl_val));
                            break;
                        }
                        section.sql.append('?');
                        section.addDateTimeParam(this.dbl_val);
                        break;
                    }
                    case STRING: {
                        switch (operator) {
                            case LikeEx: 
                            case NotLikeEx: {
                                this.escapeChar = engine.caps.getEscapeLikeChar(this.str_val);
                                this.str_val = "%" + engine.caps.toLikeString(this.str_val, this.escapeChar) + "%";
                            }
                        }
                        if (condition.search.inlineParams()) {
                            section.sql.append(engine.caps.c_string2sql(this.str_val));
                            break;
                        }
                        section.sql.append('?');
                        section.addStringParam(this.str_val);
                        break;
                    }
                    case BIG_NUMBER: {
                        if (condition.search.inlineParams()) {
                            section.sql.append(engine.caps.c_string2sql(this.str_val));
                            break;
                        }
                        section.sql.append('?');
                        section.addStringParam(this.str_val);
                        break;
                    }
                    case UNICODE: {
                        section.sql.append('?');
                        section.addUnicodeParam(this.str_val);
                        break;
                    }
                    default: {
                        section.sql.append("/*unknown argument*/");
                    }
                }
            }
        }
    }

    static abstract class Argument {
        final ArgumentKind kind;
        DataType dataType;
        protected char escapeChar = '\u0000';

        Argument(ArgumentKind kind, DataType dataType) {
            this.kind = kind;
            this.dataType = dataType;
        }

        boolean isNull() {
            return false;
        }

        boolean isNotNull() {
            return false;
        }

        boolean swapable() {
            return true;
        }

        boolean setModificator(int modificator) {
            return false;
        }

        abstract void generate(Engine var1, Condition var2, Generate.Section var3, Condition.Operator var4, boolean var5, int var6) throws IOException;
    }

    static class OperatorTerm
    extends Term {
        final Condition.LogicalOperator operator;
        Term left;
        Term right;

        OperatorTerm(Condition.Item item, Condition.LogicalOperator operator) {
            super(Token.Operator, item);
            this.operator = operator;
            this.left = null;
            this.right = null;
        }

        OperatorTerm(Condition.Item item, Condition.LogicalOperator operator, Term left, Term right) {
            super(Token.Operator, item);
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        @Override
        void collapse(Result result) {
            int leftCount = 0;
            int rightCount = 0;
            boolean leftTrue = false;
            boolean rightTrue = false;
            if (this.left != null) {
                this.left.collapse(result);
                this.left = result.term;
                leftCount = result.count;
                leftTrue = result.alwaysTrue;
            }
            if (this.right != null) {
                this.right.collapse(result);
                this.right = result.term;
                rightCount = result.count;
                rightTrue = result.alwaysTrue;
            }
            if (this.left == null) {
                result.count = rightCount;
                result.alwaysTrue = rightTrue;
                result.term = this.right;
                return;
            }
            if (this.right == null) {
                result.count = leftCount;
                result.alwaysTrue = leftTrue;
                result.term = this.left;
                return;
            }
            if (leftTrue && rightTrue) {
                result.count = 0;
                result.alwaysTrue = false;
                result.term = null;
                return;
            }
            if (leftTrue) {
                result.count = rightCount;
                result.alwaysTrue = rightTrue;
                result.term = this.right;
                return;
            }
            if (rightTrue) {
                result.count = leftCount;
                result.alwaysTrue = leftTrue;
                result.term = this.left;
                return;
            }
            result.count = leftCount + rightCount + 1;
            result.alwaysTrue = false;
            result.term = this;
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section) {
            if (this.left != null) {
                this.left.generate(engine, condition, section);
                if (this.right != null) {
                    section.sql.append(this.operator.sql);
                    this.right.generate(engine, condition, section);
                }
            } else if (this.right != null) {
                this.right.generate(engine, condition, section);
            }
        }
    }

    static class BraceTerm
    extends Term {
        Term body;

        BraceTerm(Condition.Item item, Term body) {
            super(Token.Brace, item);
            this.body = body;
        }

        @Override
        void collapse(Result result) {
            while (this.body != null && this.body.token == Token.Brace && this.body instanceof BraceTerm) {
                this.body = ((BraceTerm)this.body).body;
            }
            if (this.body == null) {
                result.alwaysTrue = false;
                result.count = 0;
                result.term = null;
            } else {
                this.body.collapse(result);
                if (result.count > 1) {
                    result.term = this;
                }
            }
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section) {
            assert (this.body != null);
            section.sql.append('(');
            this.body.generate(engine, condition, section);
            section.sql.append(')');
        }
    }

    static class ConditionTerm
    extends Term {
        Condition.Operator operator;
        Argument left;
        Argument right;
        final int modificator;
        char escapeChar;

        ConditionTerm(Condition.Item item, Condition.Operator operator, Argument left, Argument right, int modificator) {
            super(Token.Condition, item);
            this.operator = operator;
            this.left = left;
            this.right = right;
            this.modificator = modificator;
        }

        @Override
        void collapse(Result result) {
            result.alwaysTrue = false;
            result.count = this.operator == Condition.Operator.Expression ? (this.left != null ? 1 : 0) : (this.left != null && this.right != null ? 1 : 0);
            result.term = result.count != 0 ? this : null;
        }

        @Override
        void generate(Engine engine, Condition condition, Generate.Section section) {
            try {
                this.escapeChar = '\u0000';
                if (this.operator == Condition.Operator.Expression) {
                    assert (this.left != null);
                    this.left.generate(engine, condition, section, this.operator, false, this.item.lineNo);
                    return;
                }
                assert (this.left != null && this.right != null);
                boolean leftNull = this.left.isNull();
                boolean rightNull = this.right.isNull();
                if (leftNull && rightNull) {
                    section.sql.append("(0").append(this.operator.sql).append("0)");
                    return;
                }
                if (leftNull && this.right.swapable() && this.swapCondition(this.operator)) {
                    Argument a = this.left;
                    this.left = this.right;
                    this.right = a;
                    boolean n = leftNull;
                    leftNull = rightNull;
                    rightNull = n;
                }
                if (rightNull) {
                    if (this.left.isNotNull()) {
                        section.sql.append("(1").append(this.operator.sql).append("0)");
                        return;
                    }
                    switch (this.operator) {
                        case Equal: 
                        case In: 
                        case Like: 
                        case LikeEx: {
                            this.generateArg(engine, condition, section, Condition.Operator.Equal, this.left, 0, false);
                            section.sql.append(" is null");
                            return;
                        }
                        case NotEqual: 
                        case NotIn: 
                        case NotLike: 
                        case NotLikeEx: {
                            this.generateArg(engine, condition, section, Condition.Operator.NotEqual, this.left, 0, false);
                            section.sql.append(" is not null");
                            return;
                        }
                    }
                }
                int conditionModificator = 0;
                if (this.left.kind == ArgumentKind.Field && this.right.kind == ArgumentKind.Field) {
                    switch (this.modificator) {
                        case 4: 
                        case 5: 
                        case 6: {
                            conditionModificator = this.modificator;
                        }
                    }
                }
                boolean leftInline = this.left.kind == ArgumentKind.Value;
                boolean rightInline = this.right.kind == ArgumentKind.Value;
                boolean inlineValue = leftInline && rightInline;
                this.generateArg(engine, condition, section, this.operator, this.left, conditionModificator, inlineValue);
                section.sql.append(this.operator.sql);
                this.generateArg(engine, condition, section, this.operator, this.right, conditionModificator, inlineValue);
                switch (this.operator) {
                    case Like: 
                    case LikeEx: 
                    case NotLike: 
                    case NotLikeEx: {
                        if (this.escapeChar == '\u0000') break;
                        section.sql.append(" escape ").append('\'').append(this.escapeChar).append('\'');
                    }
                }
            }
            catch (Search.Exception e) {
                throw e;
            }
            catch (Throwable ex) {
                throw new Search.Exception(condition.search, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 " + condition.source + " (\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 " + this.item.lineNo + ")", ex);
            }
        }

        void generateArg(Engine engine, Condition condition, Generate.Section section, Condition.Operator conditionOperator, Argument arg, int conditionModificator, boolean inlineValue) throws IOException {
            this.escapeChar = '\u0000';
            String suffix = null;
            boolean needTypify = false;
            if (!arg.setModificator(this.modificator)) {
                switch (arg.dataType) {
                    case STRING: {
                        switch (this.modificator) {
                            case 1: {
                                section.sql.append("upper(");
                                suffix = ")";
                            }
                        }
                        break;
                    }
                    case DATE_TIME: {
                        int function_type;
                        int n = function_type = Generate.isDateExtractModificator(this.modificator) ? Generate.DATE_MOD_FUNCTION[this.modificator] : -1;
                        if (function_type >= 0) {
                            ValueArg carg;
                            if (arg instanceof ValueArg && this.try_generate_precalculated_datetime_arg(condition, section, carg = (ValueArg)arg, this.modificator)) {
                                return;
                            }
                            section.sql.append(engine.caps.function(function_type));
                            suffix = engine.caps.functionSuffix(function_type);
                            needTypify = arg.kind == ArgumentKind.Param;
                            break;
                        }
                        switch (conditionModificator) {
                            case 4: {
                                engine.caps.truncDate(section.sql, () -> {
                                    try {
                                        arg.generate(engine, condition, section, conditionOperator, inlineValue, this.item.lineNo);
                                    }
                                    catch (IOException e) {
                                        throw InformException.wrap(e);
                                    }
                                }, DatabaseCaps.TruncDateType.month);
                                this.escapeChar = arg.escapeChar;
                                return;
                            }
                            case 6: {
                                engine.caps.truncDate(section.sql, () -> {
                                    try {
                                        arg.generate(engine, condition, section, conditionOperator, inlineValue, this.item.lineNo);
                                    }
                                    catch (IOException e) {
                                        throw InformException.wrap(e);
                                    }
                                }, DatabaseCaps.TruncDateType.quarter);
                                this.escapeChar = arg.escapeChar;
                                return;
                            }
                            case 5: {
                                function_type = Generate.DATE_MOD_FUNCTION[5];
                                section.sql.append(engine.caps.function(function_type));
                                suffix = engine.caps.functionSuffix(function_type);
                            }
                        }
                    }
                }
            }
            arg.generate(engine, condition, section, conditionOperator, inlineValue, this.item.lineNo);
            this.escapeChar = arg.escapeChar;
            if (needTypify) {
                engine.caps.typifySuffix(arg.dataType, section.sql);
            }
            if (suffix != null) {
                section.sql.append(suffix);
            }
        }

        private boolean try_generate_precalculated_datetime_arg(Condition condition, Generate.Section section, ValueArg arg, int mod) {
            int v;
            switch (mod) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    return false;
                }
            }
            if (condition.timeInfo == null) {
                condition.timeInfo = new TimeInfo();
            }
            if (arg.null_val) {
                condition.timeInfo.clear();
            } else {
                DateTime.toTimeInfo(arg.dbl_val, condition.timeInfo);
            }
            switch (mod) {
                case 1: {
                    v = condition.timeInfo.day;
                    break;
                }
                case 2: {
                    v = condition.timeInfo.month;
                    break;
                }
                case 3: {
                    v = condition.timeInfo.year;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (condition.search.inlineParams()) {
                section.sql.append(v);
            } else {
                section.sql.append('?');
                section.addIntegerParam(v);
            }
            return true;
        }

        private boolean swapCondition(Condition.Operator operator) {
            switch (operator) {
                case Like: 
                case LikeEx: 
                case NotLike: 
                case NotLikeEx: {
                    return false;
                }
            }
            switch (operator) {
                case More: {
                    this.operator = Condition.Operator.Less;
                    break;
                }
                case MoreOrEqual: {
                    this.operator = Condition.Operator.LessOrEqual;
                    break;
                }
                case Less: {
                    this.operator = Condition.Operator.More;
                    break;
                }
                case LessOrEqual: {
                    this.operator = Condition.Operator.MoreOrEqual;
                }
            }
            return true;
        }
    }

    static abstract class Term {
        final Token token;
        final Condition.Item item;

        Term(Token token, Condition.Item item) {
            this.token = token;
            this.item = item;
        }

        abstract void collapse(Result var1);

        abstract void generate(Engine var1, Condition var2, Generate.Section var3);
    }

    static class Result {
        Term term = null;
        int count = 0;
        boolean alwaysTrue = false;

        Result() {
        }
    }

    static enum ArgumentKind {
        Value,
        Field,
        Param,
        Expression;

    }

    static enum Token {
        Empty,
        Condition,
        Brace,
        Operator;

    }

    private static class Parser {
        Condition.PlainItem token;
        final Condition condition;
        final Engine engine;
        final Search search;
        final ArrayList<Condition.PlainItem> plainItems;
        final int tokenCount;
        int tokenIndex = 0;
        private Condition.Operator cOperator;
        private Condition.LogicalOperator lOperator;

        Parser(Engine engine, Condition condition) {
            this.condition = condition;
            this.engine = engine;
            this.search = condition.search;
            this.plainItems = condition.plainItems;
            this.tokenCount = this.plainItems.size();
            this.token = this.plainItems.isEmpty() ? null : this.plainItems.get(0);
        }

        void nextToken() {
            ++this.tokenIndex;
            this.token = this.tokenIndex < this.tokenCount ? this.plainItems.get(this.tokenIndex) : null;
        }

        Term parse() {
            try {
                return this.parseOperator();
            }
            catch (Search.Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new Search.Exception(this.search, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 " + this.condition.source + " (\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 : " + this.token.item.lineNo);
            }
        }

        Term parseOperator() {
            Term term = null;
            if (this.token != null) {
                term = this.parsItem();
            }
            while (this.token != null && this.token.kind == Condition.PlainKind.Operator) {
                OperatorTerm operator = new OperatorTerm(this.token.item, this.token.item.logicalOperator);
                this.nextToken();
                operator.left = term;
                term = operator;
                operator.right = this.parsItem();
            }
            return term;
        }

        Term parsItem() {
            if (this.token != null) {
                switch (this.token.kind) {
                    case Condition: {
                        Term term = this.parseCondition();
                        this.nextToken();
                        return term;
                    }
                    case OpenBrace: {
                        this.nextToken();
                        assert (this.token != null);
                        this.token = this.plainItems.get(this.tokenIndex);
                        BraceTerm term = new BraceTerm(this.token.item, this.parseOperator());
                        assert (this.token != null && this.token.kind == Condition.PlainKind.CloseBrace);
                        this.nextToken();
                        return term;
                    }
                }
            }
            return null;
        }

        private int dateOf(double dateTime) {
            int date = (int)dateTime;
            int time = (int)Math.abs((dateTime - (double)date) * 8.64E7 + 0.5);
            return time >= 86400000 ? date + 1 : date;
        }

        private void expandDateModificator(ValueArg[] a, DataType dataType, int modificator) {
            if (dataType != DataType.DATE_TIME) {
                return;
            }
            assert (a[0] != null);
            switch (modificator) {
                case 4: 
                case 5: 
                case 6: {
                    if (a[1] == null) {
                        a[1] = new ValueArg(a[0]);
                    }
                    if (this.condition.timeInfo != null) break;
                    this.condition.timeInfo = new TimeInfo();
                    break;
                }
                default: {
                    if (a[1] != null) break;
                    return;
                }
            }
            int b = this.dateOf(a[0].dbl_val);
            switch (modificator) {
                case 4: {
                    DateTime.toTimeInfo(b, this.condition.timeInfo);
                    a[0].dbl_val = DateTime.create(this.condition.timeInfo.year, this.condition.timeInfo.month, 1);
                    a[1].dbl_val = a[0].dbl_val + (double)DateTime.daysInMonth(this.condition.timeInfo.month, this.condition.timeInfo.year);
                    break;
                }
                case 5: {
                    a[0].dbl_val = b;
                    a[1].dbl_val = b + 1;
                    break;
                }
                case 6: {
                    int m2;
                    DateTime.toTimeInfo(b, this.condition.timeInfo);
                    int y2 = this.condition.timeInfo.year;
                    if (this.condition.timeInfo.month < 4) {
                        this.condition.timeInfo.month = 1;
                        m2 = 4;
                    } else if (this.condition.timeInfo.month < 7) {
                        this.condition.timeInfo.month = 4;
                        m2 = 7;
                    } else if (this.condition.timeInfo.month < 10) {
                        this.condition.timeInfo.month = 7;
                        m2 = 10;
                    } else {
                        this.condition.timeInfo.month = 10;
                        m2 = 1;
                        ++y2;
                    }
                    a[0].dbl_val = DateTime.create(this.condition.timeInfo.year, this.condition.timeInfo.month, 1);
                    a[1].dbl_val = DateTime.create(y2, m2, 1);
                    break;
                }
                default: {
                    if (!(a[1].dbl_val - a[0].dbl_val > 1.0)) break;
                    a[1].dbl_val += 1.0;
                }
            }
        }

        ValueArg createParamValueArgument(Object rawValue, DataType valueType, DataType dataType) {
            if (rawValue == null) {
                return new ValueArg(dataType);
            }
            switch (valueType.toSqlDataType()) {
                case BOOLEAN: 
                case INTEGER: {
                    return new ValueArg(valueType, ValueCaster.toInt(rawValue));
                }
                case DOUBLE: 
                case DATE_TIME: 
                case TIMESTAMP: {
                    return new ValueArg(valueType, ValueCaster.toDouble(rawValue));
                }
                case STRING: 
                case UNICODE: {
                    return new ValueArg(valueType, ValueCaster.toString(rawValue));
                }
            }
            return new ValueArg(dataType);
        }

        void createParamValueArgument(Object rawValue, DataType valueType, DataType dataType, ValueArg[] a) {
            a[1] = null;
            if (rawValue == null) {
                a[0] = new ValueArg(dataType);
            } else if (rawValue instanceof DateTimeInterval) {
                DateTimeInterval dti = (DateTimeInterval)rawValue;
                a[0] = new ValueArg(DataType.DATE_TIME, dti.getStartDate());
                a[1] = new ValueArg(DataType.DATE_TIME, dti.getEndDate());
            } else {
                a[0] = this.createParamValueArgument(rawValue, valueType, dataType);
            }
        }

        boolean needSplit(Condition.Operator operator) {
            switch (operator) {
                case Equal: 
                case NotEqual: 
                case In: 
                case NotIn: {
                    return false;
                }
            }
            return true;
        }

        private boolean expandOperators(Condition.Operator operator, boolean pairedModificator) {
            this.cOperator = operator;
            switch (this.cOperator) {
                case Equal: 
                case Like: 
                case LikeEx: {
                    this.lOperator = Condition.LogicalOperator.OR;
                    return false;
                }
                case NotEqual: 
                case More: 
                case Less: 
                case NotLike: 
                case NotLikeEx: {
                    this.lOperator = Condition.LogicalOperator.AND;
                    return false;
                }
                case MoreOrEqual: {
                    if (pairedModificator) {
                        this.lOperator = Condition.LogicalOperator.OR;
                        return false;
                    }
                    this.cOperator = Condition.Operator.More;
                    this.lOperator = Condition.LogicalOperator.AND;
                    return true;
                }
                case LessOrEqual: {
                    if (pairedModificator) {
                        this.lOperator = Condition.LogicalOperator.OR;
                        return false;
                    }
                    this.cOperator = Condition.Operator.Less;
                    this.lOperator = Condition.LogicalOperator.AND;
                    return true;
                }
                case In: {
                    this.cOperator = Condition.Operator.Equal;
                    this.lOperator = Condition.LogicalOperator.OR;
                    return false;
                }
                case NotIn: {
                    this.cOperator = Condition.Operator.NotEqual;
                    this.lOperator = Condition.LogicalOperator.AND;
                    return false;
                }
            }
            this.lOperator = Condition.LogicalOperator.NONE;
            return false;
        }

        private Term createLeftPairedCondition(Condition.Operator operator, Argument left1, Argument left2, Argument right, int modificator) {
            if (Generate.isSqlDateModificator(modificator)) {
                return new ConditionTerm(this.token.item, operator, left1, right, modificator);
            }
            switch (operator) {
                case Equal: 
                case In: 
                case Like: 
                case LikeEx: {
                    ConditionTerm t1 = new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, left1, right, modificator);
                    ConditionTerm t2 = new ConditionTerm(this.token.item, Condition.Operator.Less, right, left2, modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.AND, t1, t2));
                }
                case NotEqual: 
                case NotIn: 
                case NotLike: 
                case NotLikeEx: {
                    ConditionTerm t1 = new ConditionTerm(this.token.item, Condition.Operator.Less, right, left1, modificator);
                    ConditionTerm t2 = new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, right, left2, modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, t1, t2));
                }
                case More: {
                    return new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, left2, right, modificator);
                }
                case MoreOrEqual: {
                    return new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, left1, right, modificator);
                }
                case Less: {
                    return new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, left2, right, modificator);
                }
                case LessOrEqual: {
                    return new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, left1, right, modificator);
                }
            }
            return null;
        }

        Term createLeftPairedRightPairedCondition(Condition.Operator operator, Argument left1, Argument left2, Argument right1, Argument right2, int modificator) {
            if (Generate.isDateExtractModificator(modificator)) {
                return new ConditionTerm(this.token.item, operator, left1, right1, modificator);
            }
            switch (operator) {
                case Equal: 
                case In: 
                case Like: 
                case LikeEx: {
                    ConditionTerm l1 = new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, right1, left1, modificator);
                    ConditionTerm l2 = new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, left2, right2, modificator);
                    BraceTerm t1 = new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.AND, l1, l2));
                    ConditionTerm r1 = new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, left1, right1, modificator);
                    ConditionTerm r2 = new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, right2, left2, modificator);
                    BraceTerm t2 = new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.AND, r1, r2));
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, t1, t2));
                }
                case NotEqual: 
                case NotIn: 
                case NotLike: 
                case NotLikeEx: {
                    ConditionTerm t1 = new ConditionTerm(this.token.item, Condition.Operator.Less, left2, right1, modificator);
                    ConditionTerm t2 = new ConditionTerm(this.token.item, Condition.Operator.More, left1, right2, modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, t1, t2));
                }
                case More: {
                    return new ConditionTerm(this.token.item, Condition.Operator.More, left1, right2, modificator);
                }
                case MoreOrEqual: {
                    return new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, left1, right1, modificator);
                }
                case Less: {
                    return new ConditionTerm(this.token.item, Condition.Operator.Less, left2, right1, modificator);
                }
                case LessOrEqual: {
                    return new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, left2, right2, modificator);
                }
            }
            return null;
        }

        Term createRightBoolCondition(Condition.Operator operator, Argument leftArgument, Argument rightArgument, int modificator) {
            switch (operator) {
                case Equal: 
                case NotEqual: 
                case More: 
                case Less: 
                case MoreOrEqual: 
                case LessOrEqual: {
                    break;
                }
                case NotIn: 
                case NotLike: 
                case NotLikeEx: {
                    operator = Condition.Operator.NotEqual;
                    break;
                }
                default: {
                    operator = Condition.Operator.Equal;
                }
            }
            int val = 0;
            boolean isNull = false;
            boolean isConst = false;
            switch (rightArgument.kind) {
                case Value: {
                    ValueArg c = (ValueArg)rightArgument;
                    if (c.null_val) {
                        isNull = true;
                        isConst = true;
                        break;
                    }
                    switch (c.dataType) {
                        case INTEGER: {
                            c.dataType = DataType.BOOLEAN;
                        }
                        case BOOLEAN: {
                            val = c.int_val;
                            isConst = true;
                        }
                    }
                    break;
                }
                case Param: {
                    ParamArg p = (ParamArg)rightArgument;
                    if (p.parameter == null || p.parameter.getIsIgnored() || p.parameter.getIsNull() || p.parameter.getValueCount() == 0) {
                        isNull = true;
                        isConst = true;
                        break;
                    }
                    if (p.parameter.getValueCount() == 0) break;
                    switch (p.parameter.getDataType()) {
                        case INTEGER: 
                        case BOOLEAN: {
                            val = p.parameter.getAsIntNumberByIndex(0);
                            isConst = true;
                        }
                    }
                }
            }
            switch (modificator) {
                case 1: {
                    ValueArg zero = new ValueArg(DataType.BOOLEAN, 0);
                    NotNullArg nvl = new NotNullArg(leftArgument, zero);
                    leftArgument = nvl;
                    nvl = new NotNullArg(rightArgument, zero);
                    rightArgument = nvl;
                    modificator = 0;
                    break;
                }
                case 2: {
                    switch (operator) {
                        case Equal: {
                            if (!isConst) break;
                            if (!isNull && val != 0) {
                                return new ConditionTerm(this.token.item, Condition.Operator.NotEqual, leftArgument, new ValueArg(DataType.BOOLEAN, 0), modificator);
                            }
                            if (isNull) {
                                return new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(DataType.BOOLEAN), modificator);
                            }
                            return new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(DataType.BOOLEAN, 0), modificator);
                        }
                        case NotEqual: {
                            if (!isConst) break;
                            if (!isNull && val != 9) {
                                ConditionTerm term = new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(DataType.BOOLEAN, 0), modificator);
                                ConditionTerm nullTerm = new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(DataType.BOOLEAN), modificator);
                                return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, term, nullTerm));
                            }
                            if (isNull) {
                                return new ConditionTerm(this.token.item, Condition.Operator.NotEqual, leftArgument, new ValueArg(DataType.BOOLEAN), modificator);
                            }
                            return new ConditionTerm(this.token.item, Condition.Operator.NotEqual, leftArgument, new ValueArg(DataType.BOOLEAN, 0), modificator);
                        }
                    }
                    break;
                }
                default: {
                    if (operator != Condition.Operator.NotEqual || !isConst || isNull || val == 0) break;
                    ConditionTerm term = new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(DataType.BOOLEAN, 0), modificator);
                    ConditionTerm nullTerm = new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(DataType.BOOLEAN), modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, term, nullTerm));
                }
            }
            return new ConditionTerm(this.token.item, operator, leftArgument, rightArgument, modificator);
        }

        Term createRightPairedCondition(Condition.Operator operator, Argument left, Argument right1, Argument right2, int modificator) {
            if (Generate.isDateExtractModificator(modificator)) {
                return new ConditionTerm(this.token.item, operator, left, right1, modificator);
            }
            switch (operator) {
                case Equal: 
                case In: 
                case Like: 
                case LikeEx: {
                    ConditionTerm t1 = new ConditionTerm(this.token.item, Condition.Operator.LessOrEqual, right1, left, modificator);
                    ConditionTerm t2 = new ConditionTerm(this.token.item, Condition.Operator.Less, left, right2, modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.AND, t1, t2));
                }
                case NotEqual: 
                case NotIn: 
                case NotLike: 
                case NotLikeEx: {
                    ConditionTerm t1 = new ConditionTerm(this.token.item, Condition.Operator.Less, left, right1, modificator);
                    ConditionTerm t2 = new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, left, right2, modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, t1, t2));
                }
                case More: {
                    return new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, left, right2, modificator);
                }
                case MoreOrEqual: {
                    return new ConditionTerm(this.token.item, Condition.Operator.MoreOrEqual, left, right1, modificator);
                }
                case Less: {
                    return new ConditionTerm(this.token.item, Condition.Operator.Less, left, right1, modificator);
                }
                case LessOrEqual: {
                    return new ConditionTerm(this.token.item, Condition.Operator.Less, left, right2, modificator);
                }
            }
            return null;
        }

        Term parseCondition() {
            Condition.Operator operator = this.token.item.operator;
            if (operator == Condition.Operator.Expression) {
                return new ConditionTerm(this.token.item, operator, new ExpressionArg(DataType.NONE, this.token.item.rightExpression, false, this.token.item.lineNo), null, 0);
            }
            Operand left = new Operand();
            Operand right = new Operand();
            left.get(this.condition, this.token.item, this.token.item.left);
            if (!right.getExpression(this.condition, this.token.item, this.token.item.rightExpression)) {
                right.get(this.condition, this.token.item, this.token.item.right);
            }
            if (left.dataType == DataType.NONE) {
                left.dataType = right.dataType;
            } else if (right.dataType == DataType.NONE) {
                right.dataType = left.dataType;
            }
            DataType dataType = left.dataType;
            if (dataType == DataType.NONE || left.isNullOperand() && right.isNullOperand()) {
                return new ConditionTerm(this.token.item, operator, new ValueArg(DataType.INTEGER, 0), new ValueArg(DataType.INTEGER, 0), 0);
            }
            int modificator = this.token.item.modificator;
            if (left.isNullOperand() && !right.isSubject()) {
                block0 : switch (operator) {
                    case Like: 
                    case LikeEx: 
                    case NotLike: 
                    case NotLikeEx: {
                        break;
                    }
                    default: {
                        Operand tmp = left;
                        left = right;
                        right = tmp;
                        switch (operator) {
                            case More: {
                                operator = Condition.Operator.Less;
                                break block0;
                            }
                            case MoreOrEqual: {
                                operator = Condition.Operator.LessOrEqual;
                                break block0;
                            }
                            case Less: {
                                operator = Condition.Operator.More;
                                break block0;
                            }
                            case LessOrEqual: {
                                operator = Condition.Operator.MoreOrEqual;
                            }
                        }
                    }
                }
            }
            switch (dataType) {
                case BOOLEAN: 
                case STRING: 
                case UNICODE: 
                case DATE_TIME: {
                    break;
                }
                default: {
                    modificator = 0;
                }
            }
            if (right.isMultiple() || right.isSubject()) {
                switch (operator) {
                    case Equal: {
                        operator = Condition.Operator.In;
                        break;
                    }
                    case NotEqual: {
                        operator = Condition.Operator.NotIn;
                    }
                }
            } else {
                switch (operator) {
                    case In: {
                        operator = Condition.Operator.Equal;
                        break;
                    }
                    case NotIn: {
                        operator = Condition.Operator.NotEqual;
                    }
                }
            }
            boolean leftPaired = left.parameter != null && left.parameter.isWithDateTimeInterval() && left.parameter.getValueCount() >= 1;
            boolean rightPaired = right.parameter != null && right.parameter.isWithDateTimeInterval() && right.parameter.getValueCount() >= 1;
            boolean pairedModificator = false;
            if (dataType == DataType.DATE_TIME) {
                switch (modificator) {
                    case 4: 
                    case 5: 
                    case 6: {
                        pairedModificator = true;
                    }
                }
            }
            if ((leftPaired || pairedModificator && left.parameter != null) && (right.operand == null || right.operand.kind != Condition.Operand.Kind.Null)) {
                Term term = null;
                ValueArg[] a = new ValueArg[]{null, null};
                int count = left.parameter.getValueCount();
                for (int i = 0; i < count; ++i) {
                    this.createParamValueArgument(left.parameter.valueByIndex(i), left.parameter.getDataType(), dataType, a);
                    this.expandDateModificator(a, dataType, modificator);
                    Term t = this.parseLeftPairedCondition(operator, a, right, modificator, dataType, rightPaired, pairedModificator);
                    term = term == null ? t : new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, term, t);
                }
                return new BraceTerm(this.token.item, term);
            }
            if (left.parameter != null) {
                boolean in = this.expandOperators(operator, pairedModificator);
                Term term = null;
                int count = left.parameter.getValueCount();
                for (int i = 0; i < count; ++i) {
                    ValueArg a = this.createParamValueArgument(left.parameter.valueByIndex(i), left.parameter.getDataType(), dataType);
                    Term inTerm = null;
                    if (in) {
                        inTerm = this.parseRightCondition(Condition.Operator.In, a, right, modificator, dataType, rightPaired, pairedModificator);
                    }
                    Term t = this.parseRightCondition(operator, a, right, modificator, dataType, rightPaired, pairedModificator);
                    if (inTerm != null) {
                        t = new BraceTerm(this.token.item, new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, inTerm, t));
                    }
                    term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                }
                if (left.parameter.isWithNull()) {
                    Term nullTerm = this.parseRightCondition(operator, new ValueArg(dataType), right, modificator, dataType, rightPaired, pairedModificator);
                    term = new OperatorTerm(this.token.item, this.lOperator, term, nullTerm);
                }
                return new BraceTerm(this.token.item, term);
            }
            return this.parseRightCondition(operator, left.createArgument(this.condition.havingContext), right, modificator, dataType, rightPaired, pairedModificator);
        }

        Term parseLeftPairedCondition(Condition.Operator operator, ValueArg[] a, Operand right, int modificator, DataType dataType, boolean rightPaired, boolean pairedModificator) {
            this.expandOperators(operator, pairedModificator);
            if (right.parameter != null) {
                if (right.parameter.getIsNull() || right.parameter.getValueCount() == 0) {
                    return this.createLeftPairedCondition(operator, a[0], a[1], new ValueArg(dataType), modificator);
                }
                Term term = null;
                if (rightPaired) {
                    ValueArg[] r = new ValueArg[]{null, null};
                    int count = right.parameter.getValueCount();
                    for (int i = 0; i < count; ++i) {
                        this.createParamValueArgument(right.parameter.valueByIndex(i), right.parameter.getDataType(), dataType, r);
                        this.expandDateModificator(r, dataType, modificator);
                        Term t = this.createLeftPairedRightPairedCondition(operator, a[0], a[1], r[0], r[1], modificator);
                        term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                    }
                    return new BraceTerm(this.token.item, term);
                }
                if (pairedModificator) {
                    ValueArg[] r = new ValueArg[]{null, null};
                    int count = right.parameter.getValueCount();
                    for (int i = 0; i < count; ++i) {
                        r[0] = this.createParamValueArgument(right.parameter.valueByIndex(i), right.parameter.getDataType(), dataType);
                        r[1] = null;
                        this.expandDateModificator(r, dataType, modificator);
                        Term t = this.createLeftPairedRightPairedCondition(operator, a[0], a[1], r[0], r[1], modificator);
                        term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                    }
                    return new BraceTerm(this.token.item, term);
                }
                int count = right.parameter.getValueCount();
                for (int i = 0; i < count; ++i) {
                    ValueArg rightArg = this.createParamValueArgument(right.parameter.valueByIndex(i), right.parameter.getDataType(), dataType);
                    Term t = this.createLeftPairedCondition(operator, a[0], a[1], rightArg, modificator);
                    term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                }
                if (right.parameter.isWithNull()) {
                    term = new OperatorTerm(this.token.item, this.lOperator, term, this.createLeftPairedCondition(operator, a[0], a[1], new ValueArg(dataType), modificator));
                }
                return new BraceTerm(this.token.item, term);
            }
            return this.createLeftPairedCondition(operator, a[0], a[1], right.createArgument(this.condition.havingContext), modificator);
        }

        Term parseRightCondition(Condition.Operator operator, Argument leftArgument, Operand right, int modificator, DataType dataType, boolean rightPaired, boolean pairedModificator) {
            if (right.isNullOperand()) {
                if (dataType == DataType.BOOLEAN) {
                    return this.createRightBoolCondition(operator, leftArgument, new ValueArg(dataType), modificator);
                }
                return new ConditionTerm(this.token.item, operator, leftArgument, new ValueArg(dataType), modificator);
            }
            Term term = null;
            if (right.parameter != null && (rightPaired || pairedModificator)) {
                this.expandOperators(operator, true);
                operator = this.cOperator;
                ValueArg[] r = new ValueArg[]{null, null};
                if (rightPaired) {
                    int count = right.parameter.getValueCount();
                    for (int i = 0; i < count; ++i) {
                        this.createParamValueArgument(right.parameter.getRawValueByIndex(i), right.dataType, dataType, r);
                        this.expandDateModificator(r, dataType, modificator);
                        Term t = this.createRightPairedCondition(operator, leftArgument, r[0], r[1], modificator);
                        term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                    }
                } else {
                    int count = right.parameter.getValueCount();
                    for (int i = 0; i < count; ++i) {
                        r[0] = this.createParamValueArgument(right.parameter.getAsDateValueByIndex(i), right.parameter.getDataType(), dataType);
                        r[1] = null;
                        this.expandDateModificator(r, dataType, modificator);
                        Term t = this.createRightPairedCondition(operator, leftArgument, r[0], r[1], modificator);
                        term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                    }
                }
                return new BraceTerm(this.token.item, term);
            }
            if (dataType == DataType.BOOLEAN) {
                if (right.isMultiple()) {
                    this.expandOperators(operator, pairedModificator);
                    int count = right.parameter.getValueCount();
                    for (int i = 0; i < count; ++i) {
                        ValueArg rightArg = this.createParamValueArgument(right.parameter.valueByIndex(i), right.parameter.getDataType(), dataType);
                        Term t = this.createRightBoolCondition(operator, leftArgument, rightArg, modificator);
                        term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                    }
                    if (right.parameter.isWithNull()) {
                        term = new OperatorTerm(this.token.item, this.lOperator, term, this.createRightBoolCondition(operator, leftArgument, new ValueArg(DataType.BOOLEAN), modificator));
                    }
                    return new BraceTerm(this.token.item, term);
                }
                return this.createRightBoolCondition(operator, leftArgument, right.createArgument(this.condition.havingContext), modificator);
            }
            if (right.isMultiple()) {
                boolean in = this.expandOperators(operator, pairedModificator);
                if (this.needSplit(operator) || modificator != 0 || leftArgument.isNull()) {
                    Term inTerm = null;
                    operator = this.cOperator;
                    if (in) {
                        inTerm = new ConditionTerm(this.token.item, Condition.Operator.In, leftArgument, right.createArgument(this.condition.havingContext), modificator);
                        if (right.parameter.isWithNull()) {
                            inTerm = new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, inTerm, new ConditionTerm(this.token.item, Condition.Operator.Equal, leftArgument, new ValueArg(dataType), modificator));
                        }
                    }
                    int count = right.parameter.getValueCount();
                    for (int i = 0; i < count; ++i) {
                        ValueArg rightArg = this.createParamValueArgument(right.parameter.valueByIndex(i), right.parameter.getDataType(), dataType);
                        ConditionTerm t = new ConditionTerm(this.token.item, operator, leftArgument, rightArg, modificator);
                        term = term == null ? t : new OperatorTerm(this.token.item, this.lOperator, term, t);
                    }
                    if (!in && right.parameter.isWithNull()) {
                        ConditionTerm nullTerm = new ConditionTerm(this.token.item, operator, leftArgument, new ValueArg(dataType), modificator);
                        term = new OperatorTerm(this.token.item, this.lOperator, term, nullTerm);
                    }
                    if (in) {
                        term = new OperatorTerm(this.token.item, Condition.LogicalOperator.OR, new BraceTerm(this.token.item, inTerm), new BraceTerm(this.token.item, term));
                    }
                    return new BraceTerm(this.token.item, term);
                }
                term = new ConditionTerm(this.token.item, operator, leftArgument, right.createArgument(this.condition.havingContext), modificator);
                if (right.parameter.isWithNull()) {
                    ConditionTerm nullTerm = new ConditionTerm(this.token.item, this.cOperator, leftArgument, new ValueArg(dataType), modificator);
                    return new BraceTerm(this.token.item, new OperatorTerm(this.token.item, this.lOperator, term, nullTerm));
                }
                return term;
            }
            return new ConditionTerm(this.token.item, operator, leftArgument, right.createArgument(this.condition.havingContext), modificator);
        }
    }
}

