/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.InformException;
import inform.adt.collections.IntegerSet;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.PhenixLinks;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.types.DataType;

public class LinksEntry
extends SearchEntry {
    private final String alias;
    private final String rawName;
    private final FieldDescriptor[] descriptors = new FieldDescriptor[]{new FieldDescriptor(1, PhenixLinks.FIELD_NAMES[0], DataType.PRIMARY_KEY, 0, true), new FieldDescriptor(2, PhenixLinks.FIELD_NAMES[1], DataType.PRIMARY_KEY, 0, true), new FieldDescriptor(3, PhenixLinks.FIELD_NAMES[2], DataType.PRIMARY_KEY, 0, true), new FieldDescriptor(4, PhenixLinks.FIELD_NAMES[3], DataType.PRIMARY_KEY, 0, true)};

    public LinksEntry(int entryId, int aliasId, DatabaseDescriptor database) {
        super(entryId, SearchEntry.Kind.Table, 0.0);
        switch (entryId) {
            case -1001: {
                this.rawName = database.getTableRawName("PHX_ELEMENTS");
                break;
            }
            case -1002: {
                this.rawName = database.getTableRawName("PHX_LINKED");
                break;
            }
            default: {
                assert (false);
                this.rawName = null;
            }
        }
        this.alias = "L" + aliasId;
    }

    @Override
    public double entryNodeId() {
        return 0.0;
    }

    @Override
    public StringBuilder generateAlias(StringBuilder sql) {
        return sql.append(this.alias);
    }

    @Override
    public void generateTableRawName(StringBuilder sql) {
        sql.append(this.rawName);
    }

    @Override
    public FieldDescriptor getValidFieldDescriptor(int fieldId) {
        if (1 <= fieldId && fieldId <= 4) {
            return this.descriptors[fieldId - 1];
        }
        throw new InformException("\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e" + fieldId).detail("[\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + this.rawName + ", id \u043f\u043e\u043b\u044f: [" + fieldId + "]");
    }

    @Override
    public FieldDescriptor getValidFieldDescriptor(int fieldId, String source, String line, int lineNo) {
        if (1 <= fieldId && fieldId <= 4) {
            return this.descriptors[fieldId - 1];
        }
        throw new Search.Exception(this.owner, "\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 " + source + " (" + line + ": " + lineNo + ")").detail("[\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + this.rawName + ", id \u043f\u043e\u043b\u044f: " + fieldId + "]");
    }

    @Override
    public void setSignificantFields(IntegerSet significantFields) {
    }
}

