/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.collections.ArrayMap;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.sql.engine.Condition;
import inform.agent.db.sql.engine.DataEntry;
import inform.agent.db.sql.engine.DirectoryEntry;
import inform.agent.db.sql.engine.Engine;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.LinksEntry;
import inform.agent.db.sql.engine.NestedEntry;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.sql.engine.SearchFields;
import inform.agent.db.sql.engine.SearchSorting;
import inform.agent.db.sql.engine.SubjectEntry;
import inform.agent.db.sql.engine.TableEntry;
import inform.agent.db.types.DataType;
import inform.agent.mtd.MtdEngine;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class Search {
    ArrayList<String> dataFilterFields = null;
    int dataFilterAliasNo = 0;
    StringBuilder dataFilterOrderBy = null;
    ArrayList<FieldDescriptor> sortableFields = null;
    private static final int PROP_isFilterPreset = 1;
    private static final int PROP_isUnionItem = 2;
    private static final int PROP_isNested = 4;
    private static final int PROP_isSubject = 8;
    private static final int PROP_isHierarchic = 16;
    private static final int PROP_isHierarchicRootSection = 32;
    private static final int PROP_isHierarchicConditionSection = 64;
    private static final int PROP_distinct = 128;
    private static final int PROP_pagedFetch = 256;
    private static final int PROP_inlineParams = 512;
    private static final int PROP_generateDebugInfo = 1024;
    private static final int PROP_excludeOrderBy = 2048;
    private static final int PROP_skipOrderBy = 4096;
    private static final int PROP_failedSort = 8192;
    private static final int PROP_selfSortFields = 16384;
    private static final int PROP_siblingsSort = 32768;
    private static final int PROP_generateFileBlobs = 65536;
    private static final int PROP_canSelectBlobs = 131072;
    private static final int PROP_hasBlobFields = 262144;
    private static final int hasPrimaryKeyExpression = 524288;
    private static final int PROP_hasFieldsSection = 0x100000;
    private static final int PROP_generateNullFields = 0x200000;
    private static final int PROP_disabledLockRecords = 0x400000;
    private static final int PROP_hasFromSection = 0x800000;
    private static final int PROP_dontConvertFieldExprArgs = 0x1000000;
    private static final int PROP_periodicInitialized = 0x2000000;
    private static final int PROP_hasDataFilter = 0x4000000;
    private static final int PROP_useDataFilterAllFields = 0x8000000;
    private static final int PROP_hasRecursionWithSection = 0x10000000;
    private static final int PROP_hasOptimizer = 0x20000000;
    private static final int PROP_isHierarchicBody = 0x40000000;
    private int props = 0;
    final TimeZoneHost timeZoneHost;
    final IntegerHash<SearchEntry> entries = new IntegerHash();
    int lastEntryId = 0;
    int lastAdditionalFieldId = 1;
    IntegerSet additionalFieldIds = null;
    HashSet<String> additionalFieldNames = null;
    ArrayList<SearchField> additionalFields = null;
    private int lastWithId = 0;
    final Constants constants;
    ParametersList parameters;
    Search parentSearch;
    Search deepParent = null;
    Search deepSearch = null;
    SearchEntry parentEntry;
    double searchNodeId;
    SearchEntry rootEntry;
    LinksEntry linksEntry;
    Kind kind = Kind.Standard;
    IntegerHash<SubjectEntry> subjects;
    ArrayList<SubjectEntry> subjectList;
    ArrayList<Search> unions;
    int fetchLimit = 0;
    IntegerSet returnedFields;
    IntegerSet significantFields;
    SearchFields fields;
    Condition where;
    Condition having;
    Condition relations;
    Condition hierarchyRoot;
    Condition hierarchyConnection;
    SearchSorting sorting;
    Generate.NullSortKind nullSortKind = Generate.NullSortKind.Default;
    Generate.BlobReceiving receiveBlobType = Generate.BlobReceiving.Skip;
    Generate.EntryExclusionMethod entryExclusionMethod = Generate.EntryExclusionMethod.Default;
    String storedProcedureName = null;
    String oracleOptimizerIndexCaching = null;
    String oracleOptimizerIndexCostAdj = null;
    String oracleHint = null;
    IntegerSet oracleLeading = null;
    int baseAlias = 0;
    int maxAlias = 0;
    int subjectFieldId = 0;
    int subjectFieldModificator = 0;

    public Search(Constants constants, TimeZoneHost timeZoneHost) {
        this.timeZoneHost = timeZoneHost;
        this.parentSearch = null;
        this.constants = constants;
    }

    Search(Search parentSearch) {
        this.timeZoneHost = Core.serverTimeZoneHost;
        this.parentSearch = parentSearch;
        this.constants = parentSearch.constants;
        this.inlineParams(parentSearch.inlineParams());
    }

    public double rootTableId() {
        return this.rootEntry != null ? this.rootEntry.tableId : 0.0;
    }

    public void setRootTableId(double tableId) {
        if (this.isFilterPreset()) {
            if (this.rootEntry == null) {
                StringBuilder msg = new StringBuilder();
                msg.append("\u0412 \u043f\u043e\u0438\u0441\u043a\u0435 ");
                MtdEngine.appendNodeNameForLog(msg, this.searchNodeId);
                msg.append(" \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043a\u043e\u0440\u043d\u0435\u0432\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430");
                throw new Exception(this, msg.toString());
            }
            if (this.rootEntry.tableId != tableId) {
                StringBuilder msg = new StringBuilder();
                msg.append("\u0412 \u043f\u043e\u0438\u0441\u043a\u0435 ");
                MtdEngine.appendNodeNameForLog(msg, this.searchNodeId);
                msg.append(" \u043a\u043e\u0440\u043d\u0435\u0432\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 ");
                MtdEngine.appendNodeNameForLog(msg, this.rootEntry.tableId);
                msg.append(" \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439 ");
                MtdEngine.appendNodeNameForLog(msg, tableId);
                msg.append(" \u0438\u0441\u0442\u043e\u043d\u0447\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
                throw new Exception(this, msg.toString());
            }
        } else {
            assert (this.rootEntry == null);
            this.rootEntry = new TableEntry(0, tableId);
            if (this.rootEntry.getTableDescriptor().isHasPeriodicStorage()) {
                this.isFilterPreset(true);
            }
        }
    }

    public SearchEntry getValidEntry(int entryId, String source, String line, int lineNo) {
        SearchEntry entry = this.entries.get(entryId);
        if (entry == null) {
            if (this.linksEntry != null) {
                if (this.linksEntry.entryId == entryId) {
                    return this.linksEntry;
                }
            } else {
                switch (entryId) {
                    case -1002: 
                    case -1001: {
                        this.linksEntry = new LinksEntry(entryId, this.rootEntry.entryId, this.rootEntry.getTableDescriptor().getDatabaseDescriptor());
                        this.entries.add(this.linksEntry);
                        return this.linksEntry;
                    }
                }
            }
            throw new Exception(this, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 " + source + " (entryId: " + entryId + ", " + line + ": " + lineNo + ")");
        }
        return entry;
    }

    public DataType getValidFieldType(int entryId, int fieldId, String source, String line, int lineNo) {
        switch (entryId) {
            case -1: {
                Parameter parameter = this.getValidParameter(fieldId, source, line, lineNo);
                if (parameter.getIsIgnored() || parameter.getIsNull()) {
                    return DataType.NONE;
                }
                return parameter.getDataType();
            }
            case -10: {
                throw new Exception(this, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 " + source + " (fieldId: " + fieldId + ", " + line + ": " + lineNo + ")");
            }
        }
        SearchEntry entry = this.getValidEntry(entryId, source, line, lineNo);
        return entry.getValidFieldDescriptor(fieldId, source, line, lineNo).getType();
    }

    public Parameter getValidParameter(int paramId, String source, String line, int lineNo) {
        Parameter parameter = null;
        if (this.parameters != null) {
            parameter = this.parameters.get(paramId);
        }
        if (parameter == null) {
            throw new Exception(this, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 " + source + " (paramId: " + paramId + ", " + line + ": " + lineNo + ")");
        }
        return parameter;
    }

    public Parameter findParameter(int paramId) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(paramId);
    }

    public void loadRequest(TaggedReader in) throws IOException {
        int dataLinkId = 0;
        double parentTableId = 0.0;
        double parentRecordId = 0.0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 30: {
                    this.inlineParams(true);
                    break;
                }
                case 3: {
                    dataLinkId = in.getInt();
                    break;
                }
                case 9: {
                    parentTableId = in.getDouble();
                    break;
                }
                case 4: {
                    parentRecordId = in.getDouble();
                    break;
                }
                case 5: {
                    this.setRootTableId(in.getDouble());
                    break;
                }
                case 12: {
                    if (this.selfSortFields()) break;
                    if (this.sorting == null) {
                        this.sorting = new SearchSorting();
                    }
                    this.sorting.addSortField(this, in);
                    break;
                }
                case 14: {
                    this.loadSearchNode(in.getStreamReader());
                    break;
                }
                case 15: {
                    if (this.parameters == null) {
                        this.parameters = new ParametersList();
                    }
                    this.parameters.loadParametersValues(this.constants, in.getStreamReader(), this.timeZoneHost);
                    break;
                }
                case 26: {
                    this.parameters.load(this.constants, in.getSubStreamReader(), this.timeZoneHost, true);
                    break;
                }
                case 22: {
                    if (this.relations == null) {
                        this.relations = new Condition(this, "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c");
                    }
                    this.relations.load(in.getStreamReader());
                    dataLinkId = 0;
                    break;
                }
                case 23: {
                    int loadedFetchLimit = in.getInt();
                    if (loadedFetchLimit <= 0) break;
                    this.fetchLimit = loadedFetchLimit;
                    break;
                }
                case 48: {
                    this.pagedFetch(this.fetchLimit > 0);
                    break;
                }
                case 29: {
                    this.returnedFields = new IntegerSet();
                    TaggedReader stream = in.getStreamReader();
                    while (stream.next()) {
                        this.returnedFields.add(stream.getInt());
                    }
                    break;
                }
                case 31: {
                    this.searchNodeId = in.getDouble();
                    break;
                }
                case 39: {
                    this.receiveBlobType = Generate.BlobReceiving.fromInt(in.getInt());
                    break;
                }
                case 49: {
                    this.generateFileBlobs(true);
                    break;
                }
                case 40: {
                    this.isNested(true);
                    break;
                }
                case 33: {
                    if (!(this.rootEntry instanceof DataEntry)) break;
                    ((DataEntry)this.rootEntry).setActualPointValue(in.getDouble());
                    break;
                }
                case 34: {
                    this.generateDebugInfo(true);
                    break;
                }
                case 35: {
                    TaggedReader stream = in.getStreamReader();
                    while (stream.next()) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                if (this.where == null) {
                                    this.where = new Condition(this, "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0430");
                                }
                                this.where.load(stream.getStreamReader());
                                break;
                            }
                            case 2: {
                                this.excludeOrderBy(true);
                                break;
                            }
                            case 3: {
                                this.isSubject(true);
                                this.subjectFieldId = stream.getInt();
                            }
                        }
                    }
                    break;
                }
                case 50: {
                    this.nullSortKind = Generate.NullSortKind.fromInt(in.getInt());
                }
            }
        }
        if (this.parameters != null) {
            this.parameters.makeWrapUp();
        }
        switch (dataLinkId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.relations == null) {
                    this.relations = new Condition(this, "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c");
                }
                this.relations.loadSystemLink(dataLinkId, parentTableId, parentRecordId);
            }
        }
    }

    public void loadSearchParameterBindings(TaggedReader in) throws IOException {
        if (this.parameters != null) {
            this.parameters.load(this.constants, in, Core.serverTimeZoneHost, true);
            this.parameters.makeWrapUp();
        }
    }

    public void loadSearchNode(TaggedReader in) throws IOException {
        this.isFilterPreset(true);
        if (!this.isUnionItem()) {
            this.kind = Kind.Standard;
        }
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 8: {
                    this.kind = Kind.Advanced;
                    break;
                }
                case 15: {
                    this.kind = Kind.fromInt(in.getInt());
                    if (this.kind != null) break;
                    this.kind = Kind.Advanced;
                    break;
                }
                case 16: {
                    this.storedProcedureName = in.getAnsi();
                    break;
                }
                case 9: {
                    this.distinct(true);
                    break;
                }
                case 2: {
                    this.rootEntry = this.loadSearchEntries(in.getSubStreamReader(), null);
                    break;
                }
                case 11: {
                    this.loadSubjects(in.getSubStreamReader());
                    break;
                }
                case 3: {
                    this.where = new Condition(this, "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0430");
                    this.where.load(in.getSubStreamReader());
                    break;
                }
                case 6: {
                    this.fields = new SearchFields(this.rootEntry.getTableDescriptor(), this.kind == Kind.Advanced && !this.isUnionItem());
                    this.fields.load(in.getSubStreamReader());
                    break;
                }
                case 7: {
                    this.having = new Condition(this, "\u043f\u043e\u0441\u0442\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0430", true);
                    this.having.load(in.getSubStreamReader());
                    break;
                }
                case 14: {
                    this.isHierarchic(true);
                    break;
                }
                case 18: {
                    this.siblingsSort(true);
                    break;
                }
                case 19: {
                    this.fetchLimit = in.getInt();
                    break;
                }
                case 20: {
                    if (this.sorting == null) {
                        this.sorting = new SearchSorting();
                    }
                    this.sorting.load(this, in.getSubStreamReader());
                    break;
                }
                case 12: {
                    this.hierarchyConnection = new Condition(this, "\u0438\u0435\u0440\u0430\u0440\u0445\u0438\u0438 \u043f\u043e\u0438\u0441\u043a\u0430");
                    this.hierarchyConnection.load(in.getSubStreamReader());
                    break;
                }
                case 13: {
                    this.hierarchyRoot = new Condition(this, "\u043a\u043e\u0440\u043d\u0435 \u0438\u0435\u0440\u0430\u0440\u0445\u0438\u0438 \u043f\u043e\u0438\u0441\u043a\u0430");
                    this.hierarchyRoot.load(in.getSubStreamReader());
                    break;
                }
                case 10: {
                    if (this.unions == null) {
                        this.unions = new ArrayList();
                    }
                    Search unionItem = new Search(this);
                    unionItem.isUnionItem(true);
                    unionItem.kind = this.kind;
                    unionItem.loadSearchNode(in.getSubStreamReader());
                    this.unions.add(unionItem);
                    break;
                }
                case 153: {
                    this.parameters = new ParametersList();
                    this.parameters.load(this.constants, in.getSubStreamReader(), Core.serverTimeZoneHost);
                    break;
                }
                case 21: {
                    this.entryExclusionMethod = Generate.EntryExclusionMethod.fromInt(in.getInt());
                    break;
                }
                case 23: {
                    this.inlineParams(true);
                    break;
                }
                case 24: {
                    this.significantFields = new IntegerSet();
                    TaggedReader stream = in.getSubStreamReader();
                    while (stream.next()) {
                        this.significantFields.add(stream.getInt());
                    }
                    break;
                }
                case 25: {
                    TaggedReader stream = in.getSubStreamReader();
                    while (stream.next()) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                this.hasOptimizer(true);
                                this.oracleOptimizerIndexCaching = stream.getAnsi();
                                break;
                            }
                            case 2: {
                                this.hasOptimizer(true);
                                this.oracleOptimizerIndexCostAdj = stream.getAnsi();
                                break;
                            }
                            case 3: {
                                this.hasOptimizer(true);
                                this.oracleHint = stream.getAnsi();
                                break;
                            }
                            case 4: {
                                this.hasOptimizer(true);
                                if (this.oracleLeading == null) {
                                    this.oracleLeading = new IntegerSet();
                                }
                                this.oracleLeading.add(stream.getInt());
                            }
                        }
                    }
                    break;
                }
                case 26: {
                    this.convertFieldExprArgs(false);
                }
            }
        }
        if (this.parameters != null && this.parentSearch != null) {
            this.parameters.makeWrapUp();
        }
        if (!this.isUnionItem()) {
            if (this.rootEntry != null) {
                this.rootEntry.loaded();
            }
            if (this.unions != null) {
                for (Search union : this.unions) {
                    union.kind = this.kind;
                    union.relations = this.relations;
                    union.linksEntry = this.linksEntry;
                    union.parameters = this.parameters;
                    union.generateNullFields(true);
                    union.convertFieldExprArgs(this.convertFieldExprArgs());
                    if (this.kind == Kind.Standard) {
                        if (this.isSubject()) {
                            union.parentEntry = this.parentEntry;
                            union.isSubject(true);
                        }
                        union.subjectFieldId = this.subjectFieldId;
                        union.subjectFieldModificator = this.subjectFieldModificator;
                        union.rootEntry.selected(true);
                    }
                    union.rootEntry.loaded();
                }
            }
        }
        if (this.subjectList != null) {
            for (SubjectEntry entry : this.subjectList) {
                entry.loaded();
            }
        }
    }

    private void checkRecursiveSearch(double nodeId) {
        if (nodeId == 0.0) {
            return;
        }
        Search search = this;
        while (search != null) {
            if (search.searchNodeId == nodeId) {
                double mainId = 0.0;
                Search main = search;
                while (main != null) {
                    mainId = main.searchNodeId;
                    main = main.parentSearch;
                }
                StringBuilder detail = new StringBuilder();
                detail.append("\u041f\u043e\u0438\u0441\u043a ");
                MtdEngine.appendNodeNameForLog(detail, nodeId);
                detail.append(", \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043f\u043e\u0438\u0441\u043a ");
                MtdEngine.appendNodeNameForLog(detail, mainId);
                throw new InformException("\u0426\u0438\u043a\u043b\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0430").detail(detail.toString());
            }
            search = search.parentSearch;
        }
    }

    private SearchEntry loadSearchEntries(TaggedReader in, SearchEntry parentEntry) throws IOException {
        SearchEntry entry = null;
        block9: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    byte[] raw = in.getRaw();
                    int entryId = LittleEndian.getInt(raw, 0);
                    SearchEntry.Kind entryKind = SearchEntry.Kind.fromInt(LittleEndian.getInt(raw, 4));
                    if (this.lastEntryId < entryId) {
                        this.lastEntryId = entryId;
                    }
                    double nodeId = in.getDouble(151);
                    switch (entryKind) {
                        case Directory: {
                            entry = new DirectoryEntry(entryId, nodeId);
                            break;
                        }
                        case Find: {
                            this.checkRecursiveSearch(nodeId);
                            raw = MtdEngine.getNodeContent(nodeId);
                            Search nested = new Search(this);
                            nested.isNested(true);
                            nested.searchNodeId = nodeId;
                            nested.loadSearchNode(new TaggedReader(raw));
                            entry = nested.parentEntry = new NestedEntry(entryId, nested);
                            break;
                        }
                        default: {
                            entry = new TableEntry(entryId, nodeId);
                        }
                    }
                    if (parentEntry != null) {
                        entry.parentEntry = parentEntry;
                        parentEntry.addEntry(entry);
                    }
                    entry.owner = this;
                    this.entries.add(entry);
                    continue block9;
                }
                case 5: {
                    this.loadSearchEntries(in, entry);
                    continue block9;
                }
                case 6: {
                    return entry;
                }
            }
            assert (entry != null);
            entry.loadTag(in);
        }
        return entry;
    }

    private void loadSubjects(TaggedReader in) throws IOException {
        this.subjects = new IntegerHash();
        this.subjectList = new ArrayList();
        SubjectEntry subject = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    byte[] raw = in.getRaw();
                    int entryId = LittleEndian.getInt(raw, 0);
                    SearchEntry.Kind entryKind = SearchEntry.Kind.fromInt(LittleEndian.getInt(raw, 4));
                    double nodeId = in.getDouble(151);
                    if (entryKind != SearchEntry.Kind.Find) {
                        subject = null;
                        break;
                    }
                    this.checkRecursiveSearch(nodeId);
                    if (this.lastEntryId < entryId) {
                        this.lastEntryId = entryId;
                    }
                    raw = MtdEngine.getNodeContent(nodeId);
                    Search search = new Search(this);
                    search.isSubject(true);
                    search.searchNodeId = nodeId;
                    subject = new SubjectEntry(entryId, search);
                    search.parentEntry = subject;
                    subject.owner = this;
                    search.loadSearchNode(new TaggedReader(raw));
                    this.subjects.add(subject);
                    this.subjectList.add(subject);
                    this.entries.add(subject);
                    break;
                }
                case 9: 
                case 13: {
                    if (subject == null) break;
                    subject.loadTag(in);
                    break;
                }
                case 2: {
                    subject = null;
                }
            }
        }
    }

    void exceptionDetail(Exception exception) {
        StringBuilder detailing = new StringBuilder();
        if (this.parentSearch == null) {
            detailing.append("\u041f\u043e\u0438\u0441\u043a: ");
            MtdEngine.appendNodeNameForLog(detailing, this.searchNodeId);
        } else {
            this.parentSearch.exceptionDetail(exception);
            detailing.append("->[");
            if (this.parentEntry != null) {
                detailing.append("entryId: ").append(this.parentEntry.entryId).append(", ");
            }
            detailing.append("node: ");
            MtdEngine.appendNodeNameForLog(detailing, this.searchNodeId);
            detailing.append(']');
        }
        exception.detail(detailing.toString());
    }

    public boolean isUnions() {
        return this.unions != null && !this.unions.isEmpty();
    }

    public void assignProps(Search search) {
        this.props = search.props;
    }

    public boolean isFilterPreset() {
        return (this.props & 1) != 0;
    }

    public void isFilterPreset(boolean value) {
        this.props = value ? (this.props |= 1) : (this.props &= 0xFFFFFFFE);
    }

    public boolean isUnionItem() {
        return (this.props & 2) != 0;
    }

    public void isUnionItem(boolean value) {
        this.props = value ? (this.props |= 2) : (this.props &= 0xFFFFFFFD);
    }

    public boolean isNested() {
        return (this.props & 4) != 0;
    }

    public void isNested(boolean value) {
        this.props = value ? (this.props |= 4) : (this.props &= 0xFFFFFFFB);
    }

    public boolean isSubject() {
        return (this.props & 8) != 0;
    }

    public void isSubject(boolean value) {
        this.props = value ? (this.props |= 8) : (this.props &= 0xFFFFFFF7);
    }

    public boolean isHierarchic() {
        return (this.props & 0x10) != 0;
    }

    public void isHierarchic(boolean value) {
        this.props = value ? (this.props |= 0x10) : (this.props &= 0xFFFFFFEF);
    }

    public boolean isHierarchicRootSection() {
        return (this.props & 0x20) != 0;
    }

    public void isHierarchicRootSection(boolean value) {
        this.props = value ? (this.props |= 0x20) : (this.props &= 0xFFFFFFDF);
    }

    public boolean isHierarchicConditionSection() {
        return (this.props & 0x40) != 0;
    }

    public void isHierarchicConditionSection(boolean value) {
        this.props = value ? (this.props |= 0x40) : (this.props &= 0xFFFFFFBF);
    }

    public boolean isHierarchicBody() {
        return (this.props & 0x40000000) != 0;
    }

    public void isHierarchicBody(boolean value) {
        this.props = value ? (this.props |= 0x40000000) : (this.props &= 0xBFFFFFFF);
    }

    public boolean distinct() {
        return (this.props & 0x80) != 0;
    }

    public void distinct(boolean value) {
        this.props = value ? (this.props |= 0x80) : (this.props &= 0xFFFFFF7F);
    }

    public boolean pagedFetch() {
        return (this.props & 0x100) != 0;
    }

    public void pagedFetch(boolean value) {
        this.props = value ? (this.props |= 0x100) : (this.props &= 0xFFFFFEFF);
    }

    public boolean inlineParams() {
        return (this.props & 0x200) != 0;
    }

    public void inlineParams(boolean value) {
        this.props = value ? (this.props |= 0x200) : (this.props &= 0xFFFFFDFF);
    }

    public boolean generateDebugInfo() {
        return (this.props & 0x400) != 0;
    }

    public void generateDebugInfo(boolean value) {
        this.props = value ? (this.props |= 0x400) : (this.props &= 0xFFFFFBFF);
    }

    public boolean excludeOrderBy() {
        return (this.props & 0x800) != 0;
    }

    public void excludeOrderBy(boolean value) {
        this.props = value ? (this.props |= 0x800) : (this.props &= 0xFFFFF7FF);
    }

    public boolean skipOrderBy() {
        return (this.props & 0x1000) != 0;
    }

    public void skipOrderBy(boolean value) {
        this.props = value ? (this.props |= 0x1000) : (this.props &= 0xFFFFEFFF);
    }

    public boolean failedSort() {
        return (this.props & 0x2000) != 0;
    }

    public void failedSort(boolean value) {
        this.props = value ? (this.props |= 0x2000) : (this.props &= 0xFFFFDFFF);
    }

    public boolean selfSortFields() {
        return (this.props & 0x4000) != 0;
    }

    public void selfSortFields(boolean value) {
        this.props = value ? (this.props |= 0x4000) : (this.props &= 0xFFFFBFFF);
    }

    public boolean siblingsSort() {
        return (this.props & 0x8000) != 0;
    }

    public void siblingsSort(boolean value) {
        this.props = value ? (this.props |= 0x8000) : (this.props &= 0xFFFF7FFF);
    }

    public boolean generateFileBlobs() {
        return (this.props & 0x10000) != 0;
    }

    public void generateFileBlobs(boolean value) {
        this.props = value ? (this.props |= 0x10000) : (this.props &= 0xFFFEFFFF);
    }

    public boolean canSelectBlobs() {
        return (this.props & 0x20000) != 0;
    }

    public void canSelectBlobs(boolean value) {
        this.props = value ? (this.props |= 0x20000) : (this.props &= 0xFFFDFFFF);
    }

    public boolean hasBlobFields() {
        return (this.props & 0x40000) != 0;
    }

    public void hasBlobFields(boolean value) {
        this.props = value ? (this.props |= 0x40000) : (this.props &= 0xFFFBFFFF);
    }

    public boolean hasPrimaryKeyExpression() {
        return (this.props & 0x80000) != 0;
    }

    public void hasPrimaryKeyExpression(boolean value) {
        this.props = value ? (this.props |= 0x80000) : (this.props &= 0xFFF7FFFF);
    }

    public boolean hasFieldsSection() {
        return (this.props & 0x100000) != 0;
    }

    public void hasFieldsSection(boolean value) {
        this.props = value ? (this.props |= 0x100000) : (this.props &= 0xFFEFFFFF);
    }

    public boolean generateNullFields() {
        return (this.props & 0x200000) != 0;
    }

    public void generateNullFields(boolean value) {
        this.props = value ? (this.props |= 0x200000) : (this.props &= 0xFFDFFFFF);
    }

    public boolean disabledLockRecords() {
        return (this.props & 0x400000) != 0;
    }

    public void disabledLockRecords(boolean value) {
        this.props = value ? (this.props |= 0x400000) : (this.props &= 0xFFBFFFFF);
    }

    public boolean hasFromSection() {
        return (this.props & 0x800000) != 0;
    }

    public void hasFromSection(boolean value) {
        this.props = value ? (this.props |= 0x800000) : (this.props &= 0xFF7FFFFF);
    }

    public boolean convertFieldExprArgs() {
        return (this.props & 0x1000000) == 0;
    }

    public void convertFieldExprArgs(boolean value) {
        this.props = value ? (this.props &= 0xFEFFFFFF) : (this.props |= 0x1000000);
    }

    public boolean periodicInitialized() {
        return (this.props & 0x2000000) != 0;
    }

    public void periodicInitialized(boolean value) {
        this.props = value ? (this.props |= 0x2000000) : (this.props &= 0xFDFFFFFF);
    }

    public boolean hasDataFilter() {
        return (this.props & 0x4000000) != 0;
    }

    public void hasDataFilter(boolean value) {
        this.props = value ? (this.props |= 0x4000000) : (this.props &= 0xFBFFFFFF);
    }

    public boolean useDataFilterAllFields() {
        return (this.props & 0x8000000) != 0;
    }

    public void useDataFilterAllFields(boolean value) {
        this.props = value ? (this.props |= 0x8000000) : (this.props &= 0xF7FFFFFF);
    }

    public boolean hasRecursionWithSection() {
        return (this.props & 0x10000000) != 0;
    }

    public void hasRecursionWithSection(boolean value) {
        this.props = value ? (this.props |= 0x10000000) : (this.props &= 0xEFFFFFFF);
    }

    public boolean hasOptimizer() {
        return this.parentSearch == null && (this.props & 0x20000000) != 0;
    }

    public void hasOptimizer(boolean value) {
        this.props = value ? (this.props |= 0x20000000) : (this.props &= 0xDFFFFFFF);
    }

    public void setSubjectField(int fieldId, int modificator) {
        this.subjectFieldId = fieldId;
        this.subjectFieldModificator = modificator;
    }

    public void setSubjectField(int fieldId) {
        this.subjectFieldId = fieldId;
        this.subjectFieldModificator = 0;
    }

    public SearchEntry getRootEntry() {
        return this.rootEntry;
    }

    public void beginGenerate(Engine engine) {
        if (this.fields != null) {
            this.fields.beginGenerate();
        }
        if (this.unions != null) {
            for (Search union : this.unions) {
                union.beginGenerate(engine);
            }
        }
    }

    public void endGenerate() {
    }

    public Search getDeepParent() {
        return this.deepParent != null ? this.deepParent : this.parentSearch;
    }

    public Search getDeepSearch() {
        return this.deepSearch != null ? this.deepSearch : this.parentSearch;
    }

    void setSubjectsDeepParent(Search search) {
        if (this.subjectList != null) {
            for (SubjectEntry subject : this.subjectList) {
                subject.inplaceSearch.deepParent = search;
            }
        }
    }

    void setSubjectsDeepParent() {
        this.setSubjectsDeepParent(this);
    }

    public Search throughSearch(int paramId) {
        if (paramId == 0 || this.parentSearch == null || this.parameters == null) {
            return this;
        }
        Parameter parameter = this.parameters.get(paramId);
        if (parameter == null || parameter.getDatasourceBinding() == 0 || parameter.getFieldBinding() == 0) {
            return this.parentSearch;
        }
        return this.parentSearch.throughSearch(parameter.getParamBinding());
    }

    public void initialize(DatabaseCaps caps) {
        this.dataFilterAliasNo = 0;
        if (this.parameters != null) {
            Search parametersSearch = this.parentSearch;
            if (parametersSearch != null && parametersSearch.isUnions() && this.isUnionItem()) {
                parametersSearch = parametersSearch.parentSearch;
            }
            if (parametersSearch != null && parametersSearch.parameters != null) {
                for (Parameter parameter : this.parameters.values()) {
                    Parameter binding;
                    if (parameter.getParamBinding() != 0 && (binding = parametersSearch.parameters.get(parameter.getParamBinding())) != null) {
                        parameter.applyParamBinding(binding);
                    }
                    parameter.compactNulls();
                }
            } else {
                for (Parameter parameter : this.parameters.values()) {
                    parameter.compactNulls();
                }
            }
            this.parameters.checkSettings();
        }
        this.rootEntry.reset();
        this.maxAlias = this.initEntryAlias(this.baseAlias);
        if (this.parentSearch != null || this.isSubject() || this.isNested()) {
            this.skipOrderBy(this.fetchLimit <= 0);
        } else {
            this.skipOrderBy(false);
        }
        this.canSelectBlobs(this.kind == Kind.Standard && !this.isHierarchic() && !this.isUnions());
        if (this.hasDataFilter()) {
            this.dataFilterFields = new ArrayList();
            this.dataFilterOrderBy = null;
        }
        if (this.isSubject() || this.isNested() || this.isHierarchic() && caps.isAnsiHierarchicSyntax()) {
            if (this.where != null) {
                this.where.reset();
            }
            if (this.having != null) {
                this.having.reset();
            }
            if (this.relations != null) {
                this.relations.reset();
            }
            if (this.hierarchyRoot != null) {
                this.hierarchyRoot.reset();
            }
            if (this.hierarchyConnection != null) {
                this.hierarchyConnection.reset();
            }
        }
    }

    int initEntryAlias(int baseAlias) {
        this.baseAlias = baseAlias;
        int alias = this.rootEntry.initEntryAlias(baseAlias);
        alias = this.rootEntry.initCTEAlias(alias);
        if (this.unions != null) {
            for (Search union : this.unions) {
                alias = union.initEntryAlias(alias);
            }
        }
        alias = this.rootEntry.initNestedAlias(alias);
        if (this.subjectList != null) {
            for (SubjectEntry subject : this.subjectList) {
                alias = subject.initNestedAlias(alias);
            }
        }
        if (this.isUnionItem() && this.kind == Kind.Standard && this.rootEntry.isEmpty()) {
            this.rootEntry.initEntryAlias(baseAlias + 1);
        }
        return alias;
    }

    Parameter newParameter(DataType dataType) {
        if (this.parameters == null) {
            this.parameters = new ParametersList();
        }
        return this.parameters.createParameter(dataType);
    }

    void applyUsedFields(IntegerSet usedFields) {
        if (usedFields == null || usedFields.empty()) {
            return;
        }
        if (this.returnedFields == null || this.returnedFields.empty()) {
            this.returnedFields = usedFields;
        } else {
            IntegerSet fields = new IntegerSet();
            for (Cursor.Integer i : this.returnedFields) {
                if (!usedFields.contains(i.value)) continue;
                fields.add(i.value);
            }
            this.returnedFields = fields;
        }
    }

    void fillUsedFields(SearchEntry entry, Condition condition) {
        if (condition != null) {
            condition.fillUsedFields(entry);
        }
    }

    void fillUsedFields(SearchEntry entry) {
        if (this.fields != null) {
            for (SearchField field : this.fields.items) {
                if (field.expression == null) continue;
                field.expression.fillUsedFields(entry);
            }
        }
        this.fillUsedFields(entry, this.where);
        this.fillUsedFields(entry, this.having);
        this.fillUsedFields(entry, this.relations);
        this.fillUsedFields(entry, this.hierarchyRoot);
        this.fillUsedFields(entry, this.hierarchyConnection);
        if (this.rootEntry != null) {
            this.rootEntry.fillUsedFields(entry);
        }
        if (this.sorting != null) {
            this.sorting.fillUsedFields(entry);
        }
    }

    void fillSignificantFields() {
        block4: {
            if (this.rootEntry == null) break block4;
            this.rootEntry.fillSignificantFields();
            this.rootEntry.finishFillSignificantFields();
            if (this.significantFields != null) {
                for (Cursor.Integer i : this.significantFields) {
                    this.rootEntry.addSignificantField(i.value);
                }
            } else {
                TableDescriptor table = this.rootEntry.getTableDescriptor();
                for (FieldDescriptor field : table.getFields()) {
                    this.rootEntry.addSignificantField(field.getId());
                }
            }
        }
    }

    void applyIneffectiveEntry(int entryId) {
        if (this.where != null) {
            this.where.applyIneffectiveEntry(entryId);
        }
        if (this.having != null) {
            this.having.applyIneffectiveEntry(entryId);
        }
        if (this.hierarchyRoot != null) {
            this.hierarchyRoot.applyIneffectiveEntry(entryId);
        }
        if (this.hierarchyConnection != null) {
            this.hierarchyConnection.applyIneffectiveEntry(entryId);
        }
    }

    void applyIneffictiveFields() {
        if (this.returnedFields != null && this.returnedFields.empty()) {
            this.returnedFields = null;
            return;
        }
        if (this.returnedFields == null) {
            return;
        }
        TableDescriptor table = this.rootEntry.getTableDescriptor();
        boolean needUpdateReturnedFields = false;
        for (Object fieldId : this.returnedFields) {
            if (table.getFieldDescriptor(((Cursor.Integer)fieldId).value) != null) continue;
            needUpdateReturnedFields = true;
            break;
        }
        if (needUpdateReturnedFields) {
            IntegerSet fields = this.returnedFields;
            this.returnedFields = null;
            for (Cursor.Integer fieldId : fields) {
                if (table.getFieldDescriptor(fieldId.value) == null) continue;
                if (this.returnedFields == null) {
                    this.returnedFields = new IntegerSet();
                }
                this.returnedFields.add(fieldId.value);
            }
        }
        if (this.returnedFields == null) {
            return;
        }
        for (SearchField field : this.fields.items) {
            if (field.expression != null) {
                SearchEntry entry;
                if (field.mapEntryId != 0) {
                    this.returnedFields.add(field.id);
                }
                if (!this.returnedFields.contains(field.id)) {
                    for (FieldExpression.Item item : field.expression.items) {
                        if (item.kind != FieldExpression.Kind.Field) continue;
                        entry = this.getValidEntry(item.entryId, field.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                        entry.maybeIneffective(true);
                    }
                    field.expression = null;
                    field.function = AggregateFunction.NONE;
                    continue;
                }
                for (FieldExpression.Item item : field.expression.items) {
                    if (item.kind != FieldExpression.Kind.Field) continue;
                    entry = this.getValidEntry(item.entryId, field.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                    entry.setIsNotIneffective();
                }
                continue;
            }
            if (field.function != AggregateFunction.CountEx || this.returnedFields.contains(field.id)) continue;
            field.function = AggregateFunction.NONE;
        }
        this.rootEntry.applyIneffective();
    }

    int nextWithId() {
        if (this.parentSearch != null && !this.isHierarchicBody()) {
            return this.parentSearch.nextWithId();
        }
        int result = ++this.lastWithId;
        this.lastWithId += 6;
        return result;
    }

    void incWithId() {
        if (this.parentSearch != null) {
            this.parentSearch.incWithId();
        } else {
            ++this.lastWithId;
        }
    }

    SearchField newAdditionalFieldId(String rawPrefix, int mapEntryId, int mapFieldId, DataType fieldType, int fieldSize, boolean nullable) {
        SearchField field = this.createAdditionalFieldId(rawPrefix, mapEntryId, mapFieldId, fieldType, fieldSize, nullable);
        this.additionalFields.add(field);
        return field;
    }

    SearchField createAdditionalFieldId(String rawPrefix, int mapEntryId, int mapFieldId, DataType fieldType, int fieldSize, boolean nullable) {
        int i;
        int newFieldId = 0;
        String newFieldName = null;
        for (i = this.lastAdditionalFieldId; i < Integer.MAX_VALUE; ++i) {
            if (!this.additionalFieldIds.add(i)) continue;
            this.lastAdditionalFieldId = newFieldId = i;
            break;
        }
        for (i = this.additionalFields.size(); i < Integer.MAX_VALUE && this.additionalFieldNames.contains(newFieldName = rawPrefix + i); ++i) {
        }
        SearchField field = new SearchField(newFieldId);
        field.mapEntryId = mapEntryId;
        field.mapFieldId = mapFieldId;
        field.proxyField = new FieldDescriptor(newFieldId, newFieldName, fieldType, fieldSize, nullable);
        field.dataType = fieldType;
        return field;
    }

    public static class Exception
    extends InformException {
        public Exception(Search search, String message) {
            super(message);
            search.exceptionDetail(this);
        }

        public Exception(Search search, String message, Throwable cause) {
            super(Exception.text(message, cause), cause);
            this.detail(message);
            search.exceptionDetail(this);
        }

        private static String text(String message, Throwable cause) {
            if (cause == null) {
                return message;
            }
            String result = InformException.getExceptionMessage(cause);
            if (Strings.isVoid(result)) {
                return message;
            }
            return result;
        }
    }

    public static enum Kind {
        Standard(0),
        Advanced(1),
        StoredProcedure(2);

        private final int typeId;
        static final ArrayMap<Kind> kindMap;

        private Kind(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static Kind fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            kindMap = new ArrayMap<Kind>(Kind.values());
        }
    }
}

