/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.taggedio.TaggedReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.sql.engine.SearchSorting;
import inform.agent.db.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchFields {
    public static final String FIELD_NO = "\u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u043b\u044f ";
    private final TableDescriptor tableDescriptor;
    final ArrayList<SearchField> items = new ArrayList();

    public SearchFields(TableDescriptor tableDescriptor, boolean createFields) {
        this.tableDescriptor = tableDescriptor;
        if (createFields && tableDescriptor != null) {
            List<FieldDescriptor> fields = tableDescriptor.getFields();
            for (FieldDescriptor descriptor : fields) {
                SearchField field = new SearchField(descriptor.getId());
                field.proxyField = descriptor;
                field.dataType = descriptor.getType();
                field.source = "\u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f " + field.proxyField.getCaption() + " [" + field.proxyField.getId() + "]";
                field.line = FIELD_NO;
                this.items.add(field);
            }
        }
    }

    public SearchFields(SearchFields fields, boolean aggregateFunction) {
        this.tableDescriptor = null;
        for (SearchField field : fields.items) {
            this.items.add(new SearchField(field, aggregateFunction));
        }
    }

    public SearchField find(int fieldId) {
        for (SearchField field : this.items) {
            if (field.id != fieldId) continue;
            return field;
        }
        return null;
    }

    public SearchField findMapField(int mapEntryId, int mapFieldId) {
        for (SearchField field : this.items) {
            if (field.mapEntryId != mapEntryId || field.mapFieldId != mapFieldId) continue;
            return field;
        }
        return null;
    }

    public void beginGenerate() {
        int index = 0;
        for (SearchField field : this.items) {
            field.generated(false);
            field.lineNo = ++index;
        }
    }

    public void load(TaggedReader in) throws IOException {
        SearchField field = null;
        FieldExpression.Item item = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    item = null;
                    int fieldId = in.getInt();
                    if (this.tableDescriptor == null) {
                        field = new SearchField(fieldId);
                        this.items.add(field);
                        break;
                    }
                    field = this.find(fieldId);
                    if (field != null) break;
                    if (fieldId == -1) {
                        field = new SearchField(fieldId);
                        field.dataType = DataType.PRIMARY_KEY;
                        if (this.tableDescriptor != null) {
                            field.proxyField = this.tableDescriptor.getRecordIdField();
                        }
                        if (field.proxyField == null) {
                            field.proxyField = FieldDescriptor.getInternalPrimaryKeyField();
                        }
                        this.items.add(0, field);
                        break;
                    }
                    FieldDescriptor proxyField = this.tableDescriptor.getFieldDescriptor(fieldId);
                    if (proxyField == null) break;
                    field = new SearchField(fieldId);
                    field.proxyField = proxyField;
                    field.dataType = proxyField.getType();
                    field.source = "\u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f " + proxyField.getCaption() + " [" + proxyField.getId() + "]";
                    field.line = FIELD_NO;
                    this.items.add(field);
                    break;
                }
                case 2: {
                    if (field == null) break;
                    assert (item == null);
                    field.function = AggregateFunction.fromInt(in.getInt());
                    break;
                }
                case 7: {
                    if (field == null) break;
                    if (field.expression == null) {
                        field.expression = new FieldExpression();
                    }
                    item = field.expression.newItem(FieldExpression.Kind.fromInt(in.getInt()));
                    break;
                }
                case 3: {
                    if (field == null) break;
                    if (field.expression == null) {
                        field.expression = new FieldExpression();
                    }
                    if (item == null) {
                        item = field.expression.newItem(FieldExpression.Kind.Field);
                    }
                    item.braceCount = in.getInt();
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    if (field == null) break;
                    field.expression.loadTag(in, item);
                }
            }
        }
    }

    public void addAdditionalFields(DatabaseCaps caps, Search search, Search hiearachyItem, int hierarchicId) {
        if (search.additionalFields == null || search.additionalFields.isEmpty()) {
            return;
        }
        for (SearchField additional : search.additionalFields) {
            this.addAdditionalField(caps, search, hiearachyItem, hierarchicId, additional);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addAdditionalField(DatabaseCaps caps, Search search, Search hiearachyItem, int hierarchicId, SearchField additional) {
        SearchField field = new SearchField(additional, false);
        field.expression = new FieldExpression();
        field.expression.items = new ArrayList();
        if (additional.mapEntryId == -10) {
            if (hiearachyItem.isHierarchicRootSection()) {
                FieldExpression.Item item = new FieldExpression.Item(FieldExpression.Kind.TypedValue);
                item.dataType = DataType.INTEGER;
                item.null_val = false;
                item.int_val = 1;
                field.expression.items.add(item);
            } else {
                if (!hiearachyItem.isHierarchicConditionSection()) return;
                FieldExpression.Item one = field.expression.newItem(FieldExpression.Kind.TypedValue);
                one.dataType = DataType.INTEGER;
                one.null_val = false;
                one.int_val = 1;
                one.braceCount = 1;
                FieldExpression.Item plus = field.expression.newItem(FieldExpression.Kind.Function);
                plus.function = Function.Add;
                FieldExpression.Item level = field.expression.newField(hierarchicId, additional.id);
                level.braceCount = -1;
            }
        } else if (additional.hierarchicSort()) {
            for (SearchSorting.Field sf : search.sorting.fields()) {
                FieldExpression.Item item;
                boolean needBrace;
                SearchField r;
                if (sf.entry.parentEntry != null || (r = this.find(sf.fieldId)) == null || r.expression == null || r.expression.isEmpty()) continue;
                if (!field.expression.isEmpty()) {
                    FieldExpression.Item item2 = field.expression.newItem(FieldExpression.Kind.Function);
                    item2.function = Function.Inline;
                    item2.str_val = ", ";
                }
                boolean bl = needBrace = r.expression.items.size() > 1;
                if (needBrace) {
                    item = field.expression.newItem(FieldExpression.Kind.Function);
                    item.function = Function.Inline;
                    item.str_val = "(";
                }
                field.expression.items.addAll(r.expression.items);
                if (!needBrace) continue;
                item = field.expression.newItem(FieldExpression.Kind.Function);
                item.function = Function.Inline;
                item.str_val = ")";
            }
            if (caps.isPostgreSqlHierarchicSyntax()) {
                FieldExpression.Item item = field.expression.newItem(FieldExpression.Kind.Function);
                item.function = Function.Inline;
                item.str_val = ", row_number() over()";
            }
        } else {
            field.expression.newField(additional.mapEntryId, additional.mapFieldId);
        }
        this.items.add(field);
    }
}

