/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.types;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.DataType;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.Decimal;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.NumericField;
import inform.agent.scripts.StringField;
import inform.agent.scripts.TaggedIOLibrary;
import inform.common.Empty;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;

public class ValueCaster {
    private static final String defaultDateTimeFormat = "yyyy.MM.dd HH:mm:ss";
    private static final double defaultNullNumberValue = 0.0;
    private static Date defaultNullDatetValue = new Date(DateTime.toUnixTime(0.0));
    private static String defaultNullStringValue = "";
    private static Boolean defaultNullBooleanValue = false;

    private static double stringToDouble(String value) {
        double result = 0.0;
        if (value.isEmpty()) {
            return result;
        }
        try {
            result = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static Number toNumber(Object value) throws InformException {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.toNumber(jo);
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof DateTimeInterval) {
            return ((DateTimeInterval)value).getStartDate();
        }
        if (value instanceof Date) {
            return DateTime.fromUnixTime(((Date)value).getTime());
        }
        if (value instanceof String) {
            return ValueCaster.stringToDouble((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof NumericField) {
            return ((NumericField)value).getAsNumber();
        }
        if (value instanceof DirectoryField) {
            return ((DirectoryField)value).getAsNumber();
        }
        if (value instanceof Decimal) {
            return ((Decimal)value).toDouble();
        }
        throw new InformException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043a \u0442\u0438\u043f\u0443 Number");
    }

    public static Date toDate(Object value) throws InformException {
        if (value == null) {
            return defaultNullDatetValue;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.toDate(jo);
        }
        if (value instanceof Number) {
            return new Date(DateTime.toUnixTime(((Number)value).doubleValue()));
        }
        if (value instanceof DateTimeInterval) {
            return new Date(DateTime.toUnixTime(((DateTimeInterval)value).getStartDate()));
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Decimal) {
            return new Date(DateTime.toUnixTime(((Decimal)value).toDouble()));
        }
        throw new InformException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043a \u0442\u0438\u043f\u0443 Date");
    }

    public static String toString(Object value) throws InformException {
        if (value == null) {
            return defaultNullStringValue;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.toString(jo);
        }
        if (value instanceof Double) {
            return NumberConverter.doubleToString((Double)value);
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        if (value instanceof DateTimeInterval) {
            return DateTime.toString(((DateTimeInterval)value).getStartDate());
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(defaultDateTimeFormat).format((Date)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof StringField) {
            return ((StringField)value).getAsString();
        }
        if (value instanceof BlobField) {
            return ((BlobField)value).getAsString();
        }
        if (value instanceof Decimal) {
            return ((Decimal)value).toString();
        }
        return ScriptRuntime.toString(value);
    }

    public static String dateToString(Object value) throws InformException {
        if (value == null) {
            return defaultNullStringValue;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.dateToString(jo);
        }
        if (value instanceof Number) {
            return DateTime.toString(((Number)value).doubleValue());
        }
        if (value instanceof DateTimeInterval) {
            return DateTime.toString(((DateTimeInterval)value).getStartDate());
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(defaultDateTimeFormat).format((Date)value);
        }
        if (value instanceof Decimal) {
            return DateTime.toString(((Decimal)value).toDouble());
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        throw new InformException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043a \u0442\u0438\u043f\u0443 String");
    }

    public static Boolean toBoolean(Object value) throws InformException {
        if (value == null) {
            return defaultNullBooleanValue;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.toBoolean(jo);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value instanceof Decimal) {
            return ((Decimal)value).toDouble() != 0.0;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.equalsIgnoreCase("\u043d\u0435\u0442")) {
                return false;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
            if (s.isEmpty()) {
                return false;
            }
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new InformException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043a \u0442\u0438\u043f\u0443 Boolean");
    }

    public static Object getCastedValue(DataType type, Object value) throws InformException {
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.getCastedValue(type, jo);
        }
        switch (type) {
            case NONE: {
                return null;
            }
            case PRIMARY_KEY: 
            case INTEGER: 
            case FLOAT: 
            case INTERVAL: 
            case DIRECTORY: 
            case METATREE_NODE: 
            case DATE_TIME: {
                return ValueCaster.toNumber(value);
            }
            case STRING: 
            case UNICODE: 
            case BIG_NUMBER: {
                return ValueCaster.toString(value);
            }
            case BOOLEAN: {
                return ValueCaster.toBoolean(value);
            }
            case BLOB: 
            case FILE: {
                return value;
            }
            case VARIANT: {
                return value;
            }
        }
        throw new InformException(String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043a \u0442\u0438\u043f\u0443 %s", type.toString()));
    }

    public static int toInt(Object value) throws InformException {
        if (value == null) {
            return 0;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.toNumber(jo).intValue();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof DateTimeInterval) {
            return (int)((DateTimeInterval)value).getStartDate();
        }
        if (value instanceof Date) {
            return (int)DateTime.fromUnixTime(((Date)value).getTime());
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value, 10);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return 0;
    }

    public static double toDouble(Object value) throws InformException {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof NativeJavaObject) {
            Object jo = ((NativeJavaObject)value).unwrap();
            return ValueCaster.toDouble(jo);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof DateTimeInterval) {
            return ((DateTimeInterval)value).getStartDate();
        }
        if (value instanceof Date) {
            return DateTime.fromUnixTime(((Date)value).getTime());
        }
        if (value instanceof String) {
            return ValueCaster.stringToDouble((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Decimal) {
            return ((Decimal)value).toDouble();
        }
        return 0.0;
    }

    public static byte[] toBytes(Object value) {
        if (value instanceof NativeArray) {
            return TaggedIOLibrary.serializeObject(value);
        }
        if (value instanceof BinaryObject) {
            return ((BinaryObject)value).toByteArray();
        }
        if (value instanceof CharSequence) {
            return value.toString().getBytes(TaggedWriter.ANSI);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return Empty.byteArray;
    }
}

