/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.utils.FieldLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class DirectoriesCollection {
    private ArrayList<ArrayList<FieldLocation>> locations;
    private ServerSideHost ssHost;
    private int no;
    private boolean hasActualPoint;
    private double actualPoint;
    public StringBuilder from;
    public StringBuilder where;

    public DirectoriesCollection(ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.locations = new ArrayList();
        this.no = 0;
        this.hasActualPoint = false;
        this.from = new StringBuilder();
        this.where = new StringBuilder();
    }

    public String newAlias() {
        return "A" + this.no++;
    }

    public void setActualPoint(double actualPoint) {
        this.actualPoint = actualPoint;
        this.hasActualPoint = true;
    }

    public FieldLocation add(ArrayList<FieldLocation> fieldPath) throws IOException, InformException {
        if (!this.locations.isEmpty()) {
            ListIterator<ArrayList<FieldLocation>> lit = this.locations.listIterator(this.locations.size());
            while (lit.hasPrevious()) {
                ArrayList<FieldLocation> r = lit.previous();
                if (fieldPath.size() > r.size()) continue;
                Iterator<FieldLocation> flit = r.iterator();
                int index = -1;
                boolean matching = true;
                Iterator<FieldLocation> fpit = fieldPath.iterator();
                while (fpit.hasNext()) {
                    ++index;
                    FieldLocation fp = fpit.next();
                    FieldLocation fl = flit.next();
                    if (fp.tableId == fl.tableId && fp.fieldId == fl.fieldId) continue;
                    matching = false;
                    break;
                }
                if (!matching) continue;
                if (0 <= index && index < r.size()) {
                    return r.get(index);
                }
                return r.get(r.size() - 1);
            }
        }
        ArrayList<FieldLocation> fp = new ArrayList<FieldLocation>(fieldPath);
        if (!this.locations.isEmpty()) {
            String alias;
            fp.get((int)0).alias = alias = this.locations.get((int)0).get((int)0).alias;
            fieldPath.get((int)0).alias = alias;
        }
        this.locations.add(fp);
        this.addToFrom(fieldPath);
        return fp.get(fp.size() - 1);
    }

    private void addTableToFrom(TableDescriptor tableInfo, FieldLocation loc) throws IOException, TaggedReaderException, InformException {
        if (tableInfo.isHasPeriodicStorage()) {
            ByteArrayOutputStream sqlGeneratorInput = new ByteArrayOutputStream();
            TaggedWriter sqlGeneratorWriter = new TaggedWriter(sqlGeneratorInput);
            sqlGeneratorWriter.putDouble(5, tableInfo.getNodeId());
            sqlGeneratorWriter.putEmpty(30);
            if (this.hasActualPoint) {
                sqlGeneratorWriter.putDouble(33, this.actualPoint);
            }
            ByteArrayOutputStream customization = new ByteArrayOutputStream();
            TaggedWriter customizationWriter = new TaggedWriter(customization);
            customizationWriter.putEmpty(2);
            customizationWriter.flush();
            sqlGeneratorWriter.putRaw(35, customization);
            sqlGeneratorWriter.flush();
            SqlGenerator sqlGenerator = new SqlGenerator(this.ssHost, Core.serverTimeZoneHost);
            sqlGenerator.setTableId(tableInfo.getNodeId());
            GeneratedSql sql = sqlGenerator.getGeneratedSql(SqlGenerator.Method.DEFAULT, -500, sqlGeneratorInput.toByteArray());
            this.from.append('(').append(sql.getSqlText()).append(") ").append(loc.alias);
        } else {
            DatabaseDescriptor db = tableInfo.getDatabaseDescriptor();
            db.appendTableRawName(tableInfo.getRawName(), this.from);
            this.from.append(' ').append(loc.alias);
        }
    }

    private void addToFrom(ArrayList<FieldLocation> fieldPath) throws IOException, TaggedReaderException, InformException {
        Iterator<FieldLocation> it = fieldPath.iterator();
        FieldLocation loc = it.next();
        if (this.from.length() == 0) {
            this.addTableToFrom(TableDescriptor.get(loc.tableId), loc);
        }
        while (it.hasNext()) {
            FieldLocation prev = loc;
            loc = it.next();
            TableDescriptor tableInfo = TableDescriptor.get(loc.tableId);
            this.from.append(',');
            this.addTableToFrom(tableInfo, loc);
            if (this.where.length() > 0) {
                this.where.append(" and ");
            }
            FieldDescriptor primaryKeyField = tableInfo.getRecordIdField();
            this.where.append(loc.alias).append('.').append(primaryKeyField.getRawName());
            tableInfo = TableDescriptor.get(prev.tableId);
            this.where.append('=').append(prev.alias).append('.').append(tableInfo.getFieldDescriptor(prev.fieldId).getRawName());
        }
    }
}

