/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ProcessingTableRowList {
    public final DoubleHash<TableRows> hash = new DoubleHash();
    private final DoubleHash<IntricateRows> intricate = new DoubleHash();
    public final ArrayList<TableRow> tableRows = new ArrayList();
    private IntricateKey tempKey = null;

    private TableRows rowsForTable(double tableNodeId) {
        TableRows d = this.hash.get(tableNodeId);
        if (d == null) {
            d = new TableRows(tableNodeId);
            this.hash.add(d);
        }
        return d;
    }

    public boolean add(double tableNodeId, double rowId) {
        TableRows d = this.rowsForTable(tableNodeId);
        if (!d.add(rowId)) {
            return false;
        }
        this.tableRows.add(new TableRow(tableNodeId, rowId));
        return true;
    }

    public void addAll(double tableNodeId, double[] rowIds) {
        TableRows d = this.rowsForTable(tableNodeId);
        for (double rowId : rowIds) {
            if (!d.add(rowId)) continue;
            this.tableRows.add(new TableRow(tableNodeId, rowId));
        }
    }

    public boolean contains(double tableNodeId, double rowId) {
        TableRows d = this.hash.get(tableNodeId);
        if (d == null) {
            return false;
        }
        return d.contains(rowId);
    }

    public double[] getRows(double tableNodeId) {
        TableRows d = this.hash.get(tableNodeId);
        if (d == null) {
            return null;
        }
        return d.toArray();
    }

    public double[] getTables() {
        double[] t = new double[this.hash.size()];
        int i = 0;
        for (TableRows r : this.hash) {
            t[i++] = r.tableNodeId;
        }
        return t;
    }

    public boolean isEmpty() {
        return this.hash.empty() && this.intricate.empty();
    }

    public boolean hasTables() {
        return !this.hash.empty();
    }

    public boolean hasIntricateTables() {
        return !this.intricate.empty();
    }

    public void clear() {
        this.hash.clear();
        this.intricate.clear();
        this.tableRows.clear();
    }

    public void add(double tableNodeId, byte[] pk) {
        IntricateKey key;
        IntricateRows d = this.intricate.get(tableNodeId);
        if (d == null) {
            d = new IntricateRows(tableNodeId);
            this.intricate.add(d);
        }
        if (!d.containsKey(key = new IntricateKey(pk))) {
            d.put(key, key);
        }
    }

    public boolean contains(double tableNodeId, byte[] pk) {
        IntricateRows d = this.intricate.get(tableNodeId);
        if (d == null) {
            return false;
        }
        if (this.tempKey == null) {
            this.tempKey = new IntricateKey(pk);
        } else {
            this.tempKey.key = pk;
        }
        return d.containsKey(this.tempKey);
    }

    public boolean isIntricateTable(double tableNodeId) {
        return this.intricate.get(tableNodeId) != null;
    }

    public byte[][] getIntricateRows(double tableNodeId) {
        IntricateRows d = this.intricate.get(tableNodeId);
        if (d == null) {
            return null;
        }
        byte[][] r = new byte[d.size()][];
        int index = 0;
        for (IntricateKey key : d.keySet()) {
            r[index++] = key.key;
        }
        return r;
    }

    public double[] getIntricateTables() {
        double[] t = new double[this.intricate.size()];
        int i = 0;
        for (IntricateRows r : this.intricate) {
            t[i++] = r.tableNodeId;
        }
        return t;
    }

    private static class IntricateRows
    extends HashMap<IntricateKey, IntricateKey>
    implements DoubleHash.Entry {
        final double tableNodeId;

        IntricateRows(double tableNodeId) {
            this.tableNodeId = tableNodeId;
        }

        @Override
        public double key() {
            return this.tableNodeId;
        }
    }

    public static class IntricateKey {
        byte[] key;

        public IntricateKey(byte[] key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntricateKey that = (IntricateKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return this.key != null ? Arrays.hashCode(this.key) : 0;
        }
    }

    public static class TableRows
    extends DoubleSet
    implements DoubleHash.Entry {
        public final double tableNodeId;

        TableRows(double tableNodeId) {
            this.tableNodeId = tableNodeId;
        }

        @Override
        public double key() {
            return this.tableNodeId;
        }
    }

    public static class TableRow {
        public final double table;
        public final double row;

        public TableRow(double table, double row) {
            this.table = table;
            this.row = row;
        }
    }
}

