/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.collections.DoubleList;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlBatchParameter;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterValue;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlBatchParamList {
    private SqlBatchParameter[] batchParams;
    private int batchCount = 0;
    private final DoubleList recordIds = new DoubleList(4);

    public boolean isBatchMode() {
        return this.batchCount > 1;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public boolean isEmpty() {
        return this.batchCount == 0;
    }

    public void clear() {
        this.batchCount = 0;
        this.recordIds.clear();
    }

    public void setParamCount(int paramCount) {
        this.clear();
        this.batchParams = new SqlBatchParameter[paramCount];
    }

    public void newParamSet() {
        ++this.batchCount;
    }

    public void setRecordId(double recordId) {
        while (this.recordIds.size() < this.batchCount) {
            this.recordIds.add(0.0);
        }
        while (this.batchCount < this.recordIds.size()) {
            this.recordIds.remove(this.batchCount);
        }
        this.recordIds.set(this.batchCount - 1, recordId);
    }

    double[] getRecordIds() {
        if (this.recordIds.size() == 0) {
            return null;
        }
        return this.recordIds.toArray();
    }

    private SqlParameterValue prepareValue(int index, SqlDataType type) {
        if (this.batchCount == 0) {
            this.batchCount = 1;
        }
        int batchIndex = this.batchCount - 1;
        assert (0 <= index && index < this.batchParams.length);
        SqlBatchParameter param = this.batchParams[index];
        if (param == null) {
            this.batchParams[index] = param = new SqlBatchParameter();
        }
        assert (param.getType() == SqlDataType.UNSUPPORTED || param.getType() == type);
        param.setType(type);
        param.setBatchCount(this.batchCount);
        return param.get(batchIndex);
    }

    public void setNull(int index, SqlDataType type) {
        SqlParameterValue value = this.prepareValue(index, type);
        value.clear();
    }

    public void setNumber(int index, double v, SqlDataType type) {
        SqlParameterValue value = this.prepareValue(index, type);
        value.setNumber(v);
    }

    public void setBoolean(int index, boolean v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.BOOLEAN);
        value.setBoolean(v);
    }

    public void setTimestamp(int index, long v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.TIMESTAMP);
        value.setTimestamp(v);
    }

    public void setInteger(int index, int v) {
        this.setNumber(index, v, SqlDataType.INTEGER);
    }

    public void setDouble(int index, double v) {
        this.setNumber(index, v, SqlDataType.DOUBLE);
    }

    public void setDoubleOrNull(int index, double v) {
        if (v == 0.0) {
            this.setNull(index, SqlDataType.DOUBLE);
        } else {
            this.setNumber(index, v, SqlDataType.DOUBLE);
        }
    }

    public void setDateTime(int index, double v) {
        this.setNumber(index, v, SqlDataType.DATE_TIME);
    }

    public void setString(int index, String v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.STRING);
        value.setString(v);
    }

    public void setFile(int index, String v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.FILE);
        value.setString(v);
    }

    public void setUnicode(int index, String v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.UNICODE);
        value.setString(v);
    }

    public void setBlob(int index, byte[] v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.BLOB);
        value.setBlob(v);
    }

    public void setGeom(int index, Geometry v) {
        SqlParameterValue value = this.prepareValue(index, SqlDataType.GEOMETRY);
        value.setGeom(v);
    }

    public void appendParams(ArrayList<SqlParameter> params) {
        assert (this.batchParams.length == params.size());
        this.newParamSet();
        block9: for (int index = 0; index < params.size(); ++index) {
            SqlParameter p = params.get(index);
            if (p.isNull()) {
                this.setNull(index, p.getType());
                continue;
            }
            switch (p.getType()) {
                case BOOLEAN: {
                    this.setBoolean(index, p.get().bool);
                    continue block9;
                }
                case INTEGER: 
                case DOUBLE: 
                case DATE_TIME: {
                    this.setNumber(index, p.getDouble(), p.getType());
                    continue block9;
                }
                case STRING: {
                    this.setString(index, p.getString());
                    continue block9;
                }
                case UNICODE: {
                    this.setUnicode(index, p.getString());
                    continue block9;
                }
                case BLOB: {
                    this.setBlob(index, p.getBlob());
                    continue block9;
                }
                case GEOMETRY: {
                    this.setGeom(index, p.getGeom());
                    continue block9;
                }
                case FILE: {
                    this.setFile(index, p.getFile());
                }
            }
        }
    }

    public void transferTo(int batchIndex, PreparedStatement statement) throws SQLException {
        for (int index = 0; index < this.batchParams.length; ++index) {
            this.batchParams[index].transferTo(index + 1, batchIndex, statement);
        }
    }

    public void transferTo(PreparedStatement statement) throws SQLException {
        if (this.isEmpty()) {
            return;
        }
        boolean batchMode = this.isBatchMode();
        boolean needAddBatch = false;
        for (int batchIndex = 0; batchIndex < this.batchCount; ++batchIndex) {
            if (needAddBatch) {
                statement.addBatch();
            }
            this.transferTo(batchIndex, statement);
            needAddBatch = batchMode;
        }
        if (needAddBatch) {
            statement.addBatch();
        }
    }

    public SqlParameter transferParam(int index, int batchIndex) {
        return new SqlParameter(this.batchParams[index].getType(), this.batchParams[index].get(batchIndex));
    }

    public void logParamValues(int batchIndex, StringBuilder msg) {
        if (this.batchParams.length == 0) {
            return;
        }
        msg.append(" {");
        String delimiter = "";
        for (int index = 0; index < this.batchParams.length; ++index) {
            msg.append(delimiter);
            msg.append(index + 1);
            msg.append("@");
            this.batchParams[index].logParamValue(batchIndex, msg);
            delimiter = ", ";
        }
        msg.append("}");
    }
}

