/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerList;
import inform.adt.collections.IntegerSet;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlBatchParamList;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.scripts.SSContext;
import inform.common.Exceptions;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlCommandBatch {
    public static final int MAX_BATCH_COUNT = 1000;
    private final boolean strictCheckUpdates;
    private String sqlText;
    private final SqlBatchParamList batchParams = new SqlBatchParamList();
    private TableDescriptor tableDesc = null;
    private final FlushListener flushListener;
    private SSContext currentContext = null;
    private SqlCommandBatch parentBatch = null;
    private DoubleSet deletedRows = null;
    private OrderedIntegerSet modifiedFields = null;

    public SqlCommandBatch() {
        this(null);
    }

    public SqlCommandBatch(FlushListener flushListener) {
        this(flushListener, false);
    }

    public SqlCommandBatch(FlushListener flushListener, boolean strictUpdateCount) {
        this.flushListener = flushListener;
        this.strictCheckUpdates = strictUpdateCount;
    }

    public void setParentBatch(SqlCommandBatch parentBatch) {
        this.parentBatch = parentBatch;
    }

    public void setDeletedRows(DoubleSet deletedRows) {
        this.deletedRows = deletedRows;
    }

    public boolean isEmpty() {
        return this.batchParams.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] execute(DatabaseConnection database, SSContext context) throws SQLException {
        if (this.batchParams.isEmpty()) {
            return null;
        }
        if (this.parentBatch != null) {
            this.parentBatch.flush(database, true, context);
        }
        int[] result = null;
        try (PreparedStatement statement = database.prepareStatement("SqlCommandBatch", this.sqlText);){
            int bc;
            int uc;
            int successfulUpdateCount;
            statement.setQueryTimeout();
            statement.setTableDesc(this.tableDesc);
            if (this.batchParams.isBatchMode()) {
                try {
                    this.batchParams.transferTo(statement);
                    result = statement.executeBatch(context);
                    successfulUpdateCount = statement.getLastBatchUpdateCount();
                }
                catch (SQLException batchException) {
                    database.restoreTransactionAfterException(false);
                    StringBuilder msg = new StringBuilder();
                    this.analyzeBatchException(context, statement, msg);
                    msg.append(statement.getLogMessage());
                    throw new SQLException(batchException.getMessage(), msg.toString(), batchException);
                }
            }
            this.batchParams.transferTo(statement);
            try {
                successfulUpdateCount = statement.executeUpdate(context);
            }
            catch (SQLException ex) {
                database.restoreTransactionAfterException(false);
                StringBuilder msg = new StringBuilder();
                this.analyseUniqueIndexConstraint(context, database, 0, ex, msg);
                msg.append(statement.getLogMessage());
                throw new SQLException(ex.getMessage(), msg.toString(), ex);
            }
            if (this.strictCheckUpdates && (uc = successfulUpdateCount) != (bc = this.batchParams.getBatchCount())) {
                StringBuilder msg = new StringBuilder();
                this.analyzeBatchStrictUpdateCount(context, statement, msg);
                msg.append(statement.getLogMessage());
                throw new InformException("\u0423\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e " + uc + " \u0438\u0437 " + bc + " sql-\u043a\u043e\u043c\u0430\u043d\u0434").detail(msg.toString());
            }
            this.batchParams.clear();
            if (this.modifiedFields != null) {
                this.modifiedFields.clear();
            }
            if (this.flushListener != null) {
                this.flushListener.sqlCommandFlushed(this);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchResult executeBatch(DatabaseConnection database, SSContext context) throws SQLException {
        if (this.batchParams.isEmpty()) {
            return null;
        }
        if (this.parentBatch != null) {
            this.parentBatch.flush(database, true, context);
        }
        BatchResult result = new BatchResult();
        result.batchCount = this.batchParams.getBatchCount();
        result.records = this.batchParams.getRecordIds();
        try (PreparedStatement statement = database.prepareStatement("SqlCommandBatch", this.sqlText);){
            statement.setQueryTimeout();
            statement.setTableDesc(this.tableDesc);
            if (this.batchParams.isBatchMode()) {
                try {
                    this.batchParams.transferTo(statement);
                    result.result = statement.executeBatch(context);
                    result.updateCount = statement.getLastBatchUpdateCount();
                }
                catch (SQLException batchException) {
                    database.restoreTransactionAfterException(false);
                    StringBuilder msg = new StringBuilder();
                    this.analyzeBatchException(context, statement, msg);
                    msg.append(statement.getLogMessage());
                    throw new SQLException(batchException.getMessage(), msg.toString(), batchException);
                }
            }
            this.batchParams.transferTo(statement);
            result.batchCount = 1;
            result.result = new int[1];
            try {
                result.result[0] = result.updateCount = statement.executeUpdate(context);
            }
            catch (SQLException ex) {
                database.restoreTransactionAfterException(false);
                StringBuilder msg = new StringBuilder();
                this.analyseUniqueIndexConstraint(context, database, 0, ex, msg);
                msg.append(statement.getLogMessage());
                throw new SQLException(ex.getMessage(), msg.toString(), ex);
            }
            this.batchParams.clear();
            if (this.modifiedFields != null) {
                this.modifiedFields.clear();
            }
            if (this.flushListener != null) {
                this.flushListener.sqlCommandFlushed(this);
            }
        }
        return result;
    }

    public int getBatchCount() {
        return this.batchParams.getBatchCount();
    }

    public boolean willFlush(SqlCommand command, DatabaseConnection database) {
        if (this.batchParams.isEmpty()) {
            return false;
        }
        String commandSql = command.sqlText.toString();
        return command.avoidBatch || !commandSql.equals(this.sqlText) || this.batchParams.getBatchCount() >= 1000;
    }

    public void add(SqlCommand command, DatabaseConnection database, SSContext context) throws SQLException {
        this.add(command, database, command.rowId, command.recordIdValid, context);
    }

    public void add(SqlCommand command, DatabaseConnection database, double recordId, boolean recordIdValid, SSContext context) throws SQLException {
        String commandSql = command.sqlText.toString();
        if (command.avoidBatch || !commandSql.equals(this.sqlText) || this.batchParams.getBatchCount() >= 1000) {
            if (!this.batchParams.isEmpty()) {
                this.execute(database, this.getCurrentContext(context));
            }
            this.sqlText = commandSql;
            this.batchParams.setParamCount(command.params.size());
        } else if (this.batchParams.isEmpty()) {
            this.batchParams.setParamCount(command.params.size());
        }
        this.currentContext = context;
        this.batchParams.appendParams(command.params);
        if (recordIdValid) {
            this.batchParams.setRecordId(recordId);
        }
        this.addModifiedFields(command.modifiedFields);
        if (command.modifiedFields != null) {
            command.modifiedFields.clear();
        }
    }

    public void setSql(String sql, int paramCount) {
        assert (this.sqlText == null);
        this.sqlText = sql;
        this.batchParams.setParamCount(paramCount);
        if (this.modifiedFields != null) {
            this.modifiedFields.clear();
        }
    }

    public SqlBatchParamList getParameters() {
        return this.batchParams;
    }

    public SqlBatchParamList addBatch(DatabaseConnection database, SSContext context) throws SQLException {
        assert (this.sqlText != null);
        if (this.batchParams.getBatchCount() >= 1000) {
            this.execute(database, this.getCurrentContext(context));
        }
        this.currentContext = context;
        this.batchParams.newParamSet();
        return this.batchParams;
    }

    public boolean flush(DatabaseConnection database, boolean avoidBatch, SSContext context) throws SQLException {
        boolean wasFlushed = false;
        if (avoidBatch || this.batchParams.getBatchCount() >= 1000) {
            this.execute(database, this.getCurrentContext(context));
            wasFlushed = true;
        }
        this.currentContext = context;
        return wasFlushed;
    }

    public TableDescriptor getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDescriptor tableDesc) {
        this.tableDesc = tableDesc;
    }

    void addModifiedFields(OrderedIntegerSet fields) {
        if (fields == null) {
            if (this.modifiedFields != null) {
                this.modifiedFields.clear();
            }
            return;
        }
        if (this.modifiedFields == null) {
            this.modifiedFields = new OrderedIntegerSet();
        }
        this.modifiedFields.isInsert = fields.isInsert;
        for (Cursor.Integer c : fields.integerList) {
            this.modifiedFields.add(c.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectUniqueViolationRecords(SSContext ssContext, DatabaseConnection connection, int batchIndex, IndexDescriptor index, StringBuilder msg) {
        if (index == null) {
            return false;
        }
        FieldDescriptor recordIdField = this.tableDesc.getRecordIdField();
        if (recordIdField == null) {
            return false;
        }
        SqlParameterList existingValues = new SqlParameterList();
        SqlStringBuilder s = new SqlStringBuilder();
        s.append("select");
        int comma = 32;
        ArrayList<FieldDescriptor> ef = new ArrayList<FieldDescriptor>();
        boolean needSelectValue = false;
        for (FieldDescriptor e : index.getFields()) {
            int pi = this.modifiedFields.indexOf(e.getId());
            if (pi >= 0) {
                SqlParameter p = this.batchParams.transferParam(pi, batchIndex);
                p.setId(e.getId());
                existingValues.add(p);
                continue;
            }
            s.append((char)comma).append(e);
            comma = 44;
            ef.add(e);
            needSelectValue = true;
        }
        if (needSelectValue) {
            s.append(" from ").append(this.tableDesc).append(" where ").append(recordIdField).append("=?");
            int recordIdIndex = this.modifiedFields.indexOf(recordIdField.getId());
            if (recordIdIndex < 0) {
                return false;
            }
            SqlParameter p = this.batchParams.transferParam(recordIdIndex, batchIndex);
            try (PreparedStatement statement = connection.prepareStatement("SqlCommandBatch", s.toString());){
                p.applyTo(1, statement);
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    if (fetch.next()) {
                        block23: for (int i = 0; i < ef.size(); ++i) {
                            FieldDescriptor e = (FieldDescriptor)ef.get(i);
                            p = new SqlParameter(e.getType().toSqlDataType());
                            p.setId(e.getId());
                            existingValues.add(p);
                            switch (p.getType()) {
                                case INTEGER: 
                                case DOUBLE: {
                                    p.setDouble(fetch.getAsDouble(i + 1));
                                    continue block23;
                                }
                                case STRING: 
                                case UNICODE: {
                                    p.setString(fetch.getString(i + 1));
                                    continue block23;
                                }
                                case DATE_TIME: 
                                case TIMESTAMP: {
                                    p.setDateTime(fetch.getDateTime(i + 1));
                                    continue block23;
                                }
                                case BOOLEAN: {
                                    p.setBoolean(fetch.getBoolean(i + 1));
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
                return false;
            }
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        SqlParameterList sqlParameters = new SqlParameterList();
        sql.append("select ").append(recordIdField).append(" from ").append(this.tableDesc);
        sql.append(" where ");
        String and = "";
        StringBuilder nulls = new StringBuilder();
        String or = "";
        msg.append("\n\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438:");
        int comma2 = 32;
        for (FieldDescriptor f : index.getFields()) {
            boolean is_null = true;
            msg.append((char)comma2).append("'");
            comma2 = 44;
            f.toLogString(msg);
            msg.append("'=");
            for (SqlParameter p : existingValues) {
                if (p.getId() != f.getId()) continue;
                if (p.isNull()) break;
                is_null = false;
                sql.append(and).append(f).append("=?");
                sqlParameters.add(p);
                and = " and ";
                p.getLogValue(msg);
                break;
            }
            if (!is_null) continue;
            nulls.append(or).append(f).append(" is null");
            or = " or ";
            msg.append("null");
        }
        if (nulls.length() != 0) {
            sql.append(and).append('(').append(nulls).append(')');
            and = " and ";
        }
        DoubleSet ids = new DoubleSet();
        try (PreparedStatement statement = connection.prepareStatement("SqlCommandBatch", sql.toString());){
            statement.setQueryTimeout();
            statement.setTableDesc(this.tableDesc);
            sqlParameters.applyTo(statement);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                while (fetch.next()) {
                    double recordId = fetch.getAsDouble(1);
                    if (this.deletedRows != null && this.deletedRows.contains(recordId)) continue;
                    ids.add(recordId);
                }
            }
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
        }
        comma2 = 32;
        msg.append("\n\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044e\u0449\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438:");
        for (Cursor.Double id : ids) {
            msg.append((char)comma2).append(NumberConverter.doubleToString(id.value));
            comma2 = 44;
        }
        msg.append('\n');
        return !ids.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeBatchStrictUpdateCount(SSContext context, PreparedStatement statement, StringBuilder msg) throws SQLException {
        DatabaseConnection database = statement.connection();
        int batchCount = this.batchParams.getBatchCount();
        double[] rows = this.batchParams.getRecordIds();
        if (rows == null) {
            return;
        }
        int errorCount = 0;
        for (int i = 0; i < batchCount; ++i) {
            try (PreparedStatement singleStatement = null;){
                singleStatement = database.prepareStatement("SqlCommandBatch", this.sqlText);
                singleStatement.setQueryTimeout();
                singleStatement.setTableDesc(this.tableDesc);
                this.batchParams.transferTo(i, singleStatement);
                if (singleStatement.executeUpdate(context) == 1) continue;
                msg.append("\u041d\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c ");
                if (rows != null && i < rows.length) {
                    msg.append(" recordId: ").append(NumberConverter.doubleToString(rows[i]));
                }
                msg.append('\n');
                if (++errorCount <= 10) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeBatchException(SSContext context, PreparedStatement statement, StringBuilder message) throws SQLException {
        DatabaseConnection database = statement.connection();
        int batchCount = this.batchParams.getBatchCount();
        message.append("\nBatch count: ").append(batchCount);
        for (int i = batchCount - 1; i >= 0; --i) {
            try (PreparedStatement singleStatement = null;){
                singleStatement = database.prepareStatement("SqlCommandBatch", this.sqlText);
                singleStatement.setQueryTimeout();
                singleStatement.setTableDesc(this.tableDesc);
                this.batchParams.transferTo(i, singleStatement);
                singleStatement.execute(context);
                continue;
            }
        }
    }

    private boolean analyseUniqueIndexConstraint(SSContext context, DatabaseConnection database, int batchIndex, SQLException ex, StringBuilder msg) {
        if (this.tableDesc == null || !this.tableDesc.hasStandartPrimaryKey()) {
            return false;
        }
        if (this.modifiedFields != null && !this.modifiedFields.integerList.empty()) {
            SQLException uix = database.tryGetUniqueIndexConstraintException(ex);
            if (uix == null) {
                return false;
            }
            IndexDescriptor indexDescriptor = null;
            for (Throwable t : uix) {
                if (t instanceof SQLException && (indexDescriptor = this.tableDesc.extractIndexFromMessage(t.getMessage())) != null) break;
            }
            if (indexDescriptor == null) {
                return false;
            }
            StringBuilder detailing = new StringBuilder();
            StringBuilder callstack = new StringBuilder();
            Exceptions.toString(ex, detailing, callstack);
            msg.append("\n\u0418\u043d\u0434\u0435\u043a\u0441: ").append(indexDescriptor.getName()).append('[').append(indexDescriptor.getRawName()).append(']');
            try {
                return this.selectUniqueViolationRecords(context, database, batchIndex, indexDescriptor, msg);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
        }
        return false;
    }

    private SSContext getCurrentContext(SSContext context) {
        if (this.currentContext == null) {
            return context;
        }
        return this.currentContext;
    }

    static class OrderedIntegerSet {
        final IntegerSet integerSet = new IntegerSet();
        final IntegerList integerList = new IntegerList(4);
        boolean isInsert = false;

        OrderedIntegerSet() {
        }

        void add(int value) {
            if (this.integerSet.add(value)) {
                this.integerList.add(value);
            }
        }

        void clear() {
            this.integerSet.clear();
            this.integerList.clear();
            this.isInsert = false;
        }

        int indexOf(int value) {
            if (this.integerSet.contains(value)) {
                int index = 0;
                for (Cursor.Integer c : this.integerList) {
                    if (c.value == value) {
                        return index;
                    }
                    ++index;
                }
            }
            return -1;
        }
    }

    public static class BatchResult {
        public int[] result = null;
        public int updateCount = 0;
        public int batchCount = 0;
        public double[] records = null;
    }

    public static interface FlushListener {
        public void sqlCommandFlushed(SqlCommandBatch var1);
    }
}

