/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.commit.AuditInfo;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameterValue;
import java.sql.SQLException;
import java.sql.Timestamp;

public class SqlParameter {
    private int id = 0;
    private SqlDataType type;
    private SqlParameterValue value;
    private FieldDescriptor.BlobRawType blobRawType = FieldDescriptor.BlobRawType.BINARY;

    public SqlParameter(SqlDataType type) {
        this.type = type;
        this.value = new SqlParameterValue();
    }

    public int getId() {
        return this.id;
    }

    public SqlParameter setId(int id) {
        this.id = id;
        return this;
    }

    public FieldDescriptor.BlobRawType getBlobRawType() {
        return this.blobRawType;
    }

    public void setBlobRawType(FieldDescriptor.BlobRawType blobRawType) {
        this.blobRawType = blobRawType;
    }

    public void prepare(FieldDescriptor fieldDescriptor) {
        this.blobRawType = fieldDescriptor.getBlobRawType();
    }

    public SqlParameter() {
        this(SqlDataType.UNSUPPORTED);
    }

    private SqlParameter(SqlParameter p) {
        this.type = p.type;
        this.value = new SqlParameterValue(p.value);
    }

    public SqlParameter(SqlDataType type, SqlParameterValue value) {
        this.type = type;
        this.value = new SqlParameterValue(value);
    }

    public SqlParameter clone() {
        return new SqlParameter(this);
    }

    public boolean isNull() {
        return this.value.isNull();
    }

    public SqlParameter setNull() {
        this.value.setNull();
        return this;
    }

    public SqlParameter setNull(SqlDataType type) {
        this.type = type;
        this.value.setNull();
        return this;
    }

    public SqlDataType getType() {
        return this.type;
    }

    public SqlParameterValue get() {
        return this.value;
    }

    public int getInteger() {
        return (int)this.value.getNumber();
    }

    public boolean getBoolean() {
        return this.value.getBoolean();
    }

    public boolean getAsBoolean() {
        if (this.isNull()) {
            return false;
        }
        switch (this.type) {
            case INTEGER: 
            case DOUBLE: {
                return this.value.getNumber() != 0.0;
            }
            case BOOLEAN: {
                return this.value.getBoolean();
            }
        }
        return false;
    }

    public double getDouble() {
        return this.value.getNumber();
    }

    public String getString() {
        return this.value.getString();
    }

    public String getFile() {
        return this.value.getString();
    }

    public byte[] getBlob() {
        return this.value.getBlob();
    }

    public Geometry getGeom() {
        return this.value.getGeom();
    }

    public double getDateTime() {
        if (this.type == SqlDataType.TIMESTAMP) {
            return DateTime.fromUnixTime(this.value.msecs);
        }
        return this.value.getNumber();
    }

    public Timestamp getTimestamp() {
        return new Timestamp(this.value.msecs);
    }

    public long getMSecs() {
        return this.value.msecs;
    }

    public SqlParameter setInteger(int v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.INTEGER;
        }
        assert (this.type == SqlDataType.INTEGER || this.type == SqlDataType.DOUBLE);
        this.value.setNumber(v);
        return this;
    }

    public SqlParameter setBoolean(boolean v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.BOOLEAN;
        }
        assert (this.type == SqlDataType.BOOLEAN);
        this.value.setBoolean(v);
        return this;
    }

    public SqlParameter setDouble(double v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.DOUBLE;
        }
        assert (this.type == SqlDataType.INTEGER || this.type == SqlDataType.DOUBLE);
        this.value.setNumber(v);
        return this;
    }

    public SqlParameter setDateTime(double v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.DATE_TIME;
        }
        assert (this.type == SqlDataType.DATE_TIME);
        this.value.setNumber(v);
        return this;
    }

    public SqlParameter setTimestamp(long v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.TIMESTAMP;
        }
        assert (this.type == SqlDataType.TIMESTAMP);
        this.value.setTimestamp(v);
        return this;
    }

    public SqlParameter setString(String v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.STRING;
        }
        assert (this.type == SqlDataType.STRING || this.type == SqlDataType.UNICODE);
        this.value.setString(v);
        return this;
    }

    public SqlParameter setUnicode(String v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.UNICODE;
        }
        assert (this.type == SqlDataType.STRING || this.type == SqlDataType.UNICODE);
        this.value.setString(v);
        return this;
    }

    public SqlParameter setFile(String v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.FILE;
        }
        assert (this.type == SqlDataType.FILE);
        this.value.setString(v);
        return this;
    }

    public SqlParameter setBlob(byte[] v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.BLOB;
        }
        assert (this.type == SqlDataType.BLOB || this.type == SqlDataType.FILE);
        this.value.setBlob(v);
        return this;
    }

    public SqlParameter setGeom(Geometry v) {
        if (this.type == SqlDataType.UNSUPPORTED) {
            this.type = SqlDataType.GEOMETRY;
        }
        assert (this.type == SqlDataType.GEOMETRY);
        this.value.setGeom(v);
        return this;
    }

    public boolean isBlobEmpty() {
        return this.type == SqlDataType.BLOB && this.value.isBlobEmpty();
    }

    public void applyTo(int paramIndex, PreparedStatement statement) throws SQLException {
        if (this.isNull()) {
            statement.setNull(paramIndex, this.getType());
        } else {
            switch (this.getType()) {
                case INTEGER: {
                    statement.setInt(paramIndex, this.getInteger());
                    break;
                }
                case BOOLEAN: {
                    statement.setBoolean(paramIndex, this.getBoolean());
                    break;
                }
                case DOUBLE: {
                    statement.setDouble(paramIndex, this.getDouble());
                    break;
                }
                case STRING: {
                    statement.setString(paramIndex, this.getString());
                    break;
                }
                case UNICODE: {
                    statement.setNString(paramIndex, this.getString());
                    break;
                }
                case DATE_TIME: {
                    statement.setDateTime(paramIndex, this.getDouble());
                    break;
                }
                case BLOB: {
                    byte[] blobValue = this.getBlob();
                    if (blobValue != null) {
                        statement.setBlob(paramIndex, blobValue);
                        break;
                    }
                    statement.setNull(paramIndex, this.getType());
                    break;
                }
                case FILE: {
                    statement.setString(paramIndex, this.getFile());
                    break;
                }
                case TIMESTAMP: {
                    statement.setTimestamp(paramIndex, this.getTimestamp());
                    break;
                }
                case GEOMETRY: {
                    statement.setGeometry(paramIndex, this.getGeom());
                }
            }
        }
    }

    public void applyTo(int paramIndex, AuditInfo auditInfo, FieldDescriptor fd) throws SQLException {
        if (this.isNull()) {
            auditInfo.setField(fd).setNull();
        } else {
            switch (this.getType()) {
                case INTEGER: {
                    auditInfo.setField(fd).setNumber(this.getInteger());
                    break;
                }
                case BOOLEAN: {
                    auditInfo.setField(fd).setNumber(this.getBoolean() ? 1.0 : 0.0);
                    break;
                }
                case DOUBLE: {
                    auditInfo.setField(fd).setNumber(this.getDouble());
                    break;
                }
                case STRING: {
                    auditInfo.setField(fd).setString(this.getString());
                    break;
                }
                case UNICODE: {
                    auditInfo.setField(fd).setUnicode(this.getString());
                    break;
                }
                case DATE_TIME: {
                    auditInfo.setField(fd).setDateTime(this.getDateTime());
                    break;
                }
                case BLOB: {
                    auditInfo.setField(fd).setBlob(this.getBlob());
                    break;
                }
            }
        }
    }

    public void assign(SqlParameter p) {
        this.type = p.type;
        this.value = new SqlParameterValue(p.value);
    }

    public boolean isEqualValue(SqlParameter l) {
        if (this.isNull()) {
            return l.isNull();
        }
        if (l.isNull()) {
            return false;
        }
        switch (this.type) {
            case BOOLEAN: {
                return this.getBoolean() == l.getBoolean();
            }
            case INTEGER: {
                return this.getInteger() == l.getInteger();
            }
            case DOUBLE: {
                return this.getDouble() == l.getDouble();
            }
            case STRING: 
            case UNICODE: {
                return this.getString().equals(l.getString());
            }
            case DATE_TIME: {
                return this.getDateTime() == l.getDateTime();
            }
            case TIMESTAMP: {
                return this.getMSecs() == l.getMSecs();
            }
        }
        return false;
    }

    public void getLogValue(StringBuilder msg) {
        if (this.isNull()) {
            msg.append("null");
        } else {
            switch (this.getType()) {
                case INTEGER: {
                    msg.append(this.getInteger());
                    break;
                }
                case BOOLEAN: {
                    msg.append(this.getBoolean());
                    break;
                }
                case DOUBLE: {
                    msg.append(NumberConverter.doubleToString(this.getDouble()));
                    break;
                }
                case STRING: {
                    msg.append(this.getString());
                    break;
                }
                case UNICODE: {
                    msg.append(this.getString());
                    break;
                }
                case DATE_TIME: {
                    msg.append(DateTime.toString(this.getDouble()));
                    break;
                }
                case BLOB: {
                    msg.append("[blob]");
                    break;
                }
                case FILE: {
                    msg.append("[file]");
                    break;
                }
                case TIMESTAMP: {
                    msg.append(this.getTimestamp());
                    break;
                }
                case GEOMETRY: {
                    msg.append("[geometry]");
                    break;
                }
                default: {
                    msg.append("[unknown]");
                }
            }
        }
    }
}

