/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.NumberConverter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;

public class SqlStringBuilder {
    private final StringBuilder b = new StringBuilder();

    public StringBuilder getBuilder() {
        return this.b;
    }

    public SqlStringBuilder append(String str) {
        this.b.append(str);
        return this;
    }

    public SqlStringBuilder append(CharSequence sb) {
        this.b.append(sb);
        return this;
    }

    public SqlStringBuilder append(SqlStringBuilder sb) {
        this.b.append((CharSequence)sb.b);
        return this;
    }

    public SqlStringBuilder append(char c) {
        this.b.append(c);
        return this;
    }

    public SqlStringBuilder append(int c) {
        this.b.append(c);
        return this;
    }

    public SqlStringBuilder append(long c) {
        this.b.append(c);
        return this;
    }

    public SqlStringBuilder append(double c) {
        this.b.append(NumberConverter.doubleToString(c));
        return this;
    }

    public SqlStringBuilder append(FieldDescriptor c) {
        this.b.append(c.getRawName());
        return this;
    }

    public SqlStringBuilder append(TableDescriptor c) {
        return this.appendFull(c);
    }

    public SqlStringBuilder appendFull(TableDescriptor c) {
        c.getDatabaseDescriptor().appendTableRawName(c.getRawName(), this.b);
        return this;
    }

    public String toString() {
        return this.b.toString();
    }

    public int length() {
        return this.b.length();
    }

    public void setChatAt(int index, char c) {
        this.b.setCharAt(index, c);
    }
}

