/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.document;

import inform.agent.document.CustomItem;
import inform.agent.document.Data;
import inform.agent.document.TextItem;

public class CellData
extends Data {
    public int rowSpan = 1;
    public int colSpan = 1;
    public int bestWidth = 0;
    public int bestHeight = 0;
    public int color = 0x1FFFFFFF;
    public int borderColor = 0x1FFFFFFF;
    public boolean borderLeftVisible = true;
    public boolean borderRightVisible = true;
    public boolean borderTopVisible = true;
    public boolean borderBottomVisible = true;

    public CellData() {
        TextItem item = new TextItem();
        item.setStyleNo(0);
        item.paraNo = 0;
        item.setItemText("");
        this.itemList.add(item);
    }

    public void assignAttributesFrom(CellData source, boolean includeSize, int divColSpan, int divRowSpan) {
        this.color = source.color;
        this.borderColor = source.borderColor;
        this.borderLeftVisible = source.borderLeftVisible;
        this.borderRightVisible = source.borderRightVisible;
        this.borderTopVisible = source.borderTopVisible;
        this.borderBottomVisible = source.borderBottomVisible;
        if (includeSize) {
            this.bestWidth = source.bestWidth / divColSpan;
            this.bestHeight = source.bestHeight / divRowSpan;
        }
    }

    public boolean hasContent(boolean checkStyles) {
        if (this.itemList.size() > 1) {
            return true;
        }
        if (this.itemList.size() == 1) {
            CustomItem item = (CustomItem)this.itemList.get(0);
            if (checkStyles) {
                return item.styleNo() != 0 || item.paraNo != 0 || !((TextItem)item).itemText().isEmpty();
            }
            return item.styleNo() < 0 || !((TextItem)item).itemText().isEmpty();
        }
        return false;
    }
}

