/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.document;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.document.CustomItem;
import inform.agent.document.TextItem;
import java.util.ArrayList;

public class Data {
    public ArrayList<CustomItem> itemList = new ArrayList();

    public void store(TaggedWriter out, int tag) throws Throwable {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter sout = new TaggedWriter(os);
        for (CustomItem item : this.itemList) {
            if (item.pageBreakBefore()) {
                sout.putEmpty(8);
            }
            item.store(sout);
        }
        sout.flush();
        if (os.size() > 0) {
            out.putEmpty(tag);
            out.putRaw(202, os);
        }
    }

    public void addItem(CustomItem item) {
        this.itemList.add(item);
    }

    public void addEmptyText() {
        TextItem item = new TextItem();
        this.addItem(item);
    }

    public void moveFrom(Data source) {
        if (source == null) {
            return;
        }
        for (CustomItem item : source.itemList) {
            this.addItem(item);
        }
        source.itemList.clear();
    }
}

