/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.document;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.document.UsedStyleFinder;
import inform.agent.web.utils.ClientFont;
import java.util.ArrayList;

public class Style {
    public static final String DEFAULT_FONT_NAME = "Times New Roman";
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final int STD_TEXT_STYLE_HEADER = 1;
    public static final int STD_TEXT_STYLE_SUBHEADER = 2;
    public static final int STD_TEXT_STYLE_LINK = 4;
    public ArrayList<Text> textStyles = new ArrayList();
    public ArrayList<Paragraph> paraStyles = new ArrayList();
    public ArrayList<List> listStyles = new ArrayList();

    public Style() {
        this.init();
    }

    private void init() {
        Text f1 = new Text();
        f1.standart = true;
        f1.size = 13;
        this.textStyles.add(f1);
        Text f2 = new Text();
        f2.standart = true;
        f2.size = 14;
        f2.style = 1;
        this.textStyles.add(f2);
        Text f3 = new Text();
        f3.standart = true;
        f3.size = 13;
        f3.style = 1;
        this.textStyles.add(f3);
        Text f4 = new Text();
        f4.standart = true;
        f4.size = 12;
        f4.style = 2;
        f4.color = 128;
        this.textStyles.add(f4);
        Text f5 = new Text();
        f5.standart = true;
        f5.size = 12;
        f5.style = 4;
        f5.color = 32768;
        f5.jump = true;
        this.textStyles.add(f5);
        ListLevel ll1 = new ListLevel();
        ll1.formatString = "- ";
        ll1.fontSize = 12;
        List l1 = new List();
        l1.styleName = "\u041c\u0430\u0440\u043a\u0435\u0440\u044b";
        l1.levels.add(ll1);
        this.listStyles.add(l1);
        ListLevel ll2 = new ListLevel();
        ll2.formatString = "%s. ";
        ll2.fontSize = 12;
        ll2.type = 3;
        List l2 = new List();
        l2.styleName = "\u041d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u044f";
        l2.levels.add(ll2);
        this.listStyles.add(l2);
        Paragraph p = new Paragraph();
        p.standart = true;
        this.paraStyles.add(p);
    }

    public void store(TaggedWriter out, UsedStyleFinder finder) throws Throwable {
        int i;
        ByteArrayOutputStream oss = new ByteArrayOutputStream();
        TaggedWriter ssout = new TaggedWriter(oss);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter sout = new TaggedWriter(os);
        for (i = 0; i < this.textStyles.size(); ++i) {
            if (finder != null && !finder.usedTextStyles.contains(i)) continue;
            Text f = this.textStyles.get(i);
            sout.putInt32(4, i);
            ClientFont.store(sout, 1, f.name, f.size, f.style, f.color);
            if (f.background != 0x1FFFFFFF) {
                sout.putInt32(2, f.background);
            }
            if (!f.jump) continue;
            sout.putEmpty(7);
        }
        sout.flush();
        if (os.size() > 0) {
            ssout.putRaw(1, os);
        }
        os = new ByteArrayOutputStream();
        sout = new TaggedWriter(os);
        for (i = 0; i < this.paraStyles.size(); ++i) {
            if (finder != null && !finder.usedParaStyles.contains(i)) continue;
            Paragraph p = this.paraStyles.get(i);
            sout.putInt32(9, i);
            sout.putInt32(1, p.align);
            if (p.leftIndent != 0) {
                sout.putInt32(2, p.leftIndent);
            }
            if (p.rightIndent != 0) {
                sout.putInt32(3, p.rightIndent);
            }
            if (p.firstIndent != 0) {
                sout.putInt32(6, p.firstIndent);
            }
            if (p.lineSpacingType != 0) {
                sout.putInt32(8, p.lineSpacingType);
            }
            if (p.lineSpacing == 100) continue;
            sout.putInt32(7, p.lineSpacing);
        }
        sout.flush();
        if (os.size() > 0) {
            ssout.putRaw(2, os);
        }
        os = new ByteArrayOutputStream();
        sout = new TaggedWriter(os);
        for (i = 0; i < this.listStyles.size(); ++i) {
            if (finder != null && !finder.usedListStyles.contains(i)) continue;
            List l = this.listStyles.get(i);
            sout.putInt32(1, i);
            if (!Strings.isVoid(l.styleName)) {
                sout.putAnsi(2, l.styleName);
            }
            if (l.standart) {
                sout.putEmpty(4);
            }
            ByteArrayOutputStream los = null;
            TaggedWriter lout = null;
            for (ListLevel ll : l.levels) {
                los = new ByteArrayOutputStream();
                lout = new TaggedWriter(los);
                lout.putInt32(1, ll.type);
                lout.putAnsi(2, ll.formatString);
                ClientFont.store(lout, 3, ll.fontName, ll.fontSize, ll.fontStyle, ll.fontColor);
                if (ll.startFrom != 0) {
                    lout.putInt32(4, ll.startFrom);
                }
                if (ll.markerIndent != 0) {
                    lout.putInt32(5, ll.markerIndent);
                }
                if (ll.leftIndent != 0) {
                    lout.putInt32(6, ll.leftIndent);
                }
                lout.flush();
                if (los.size() <= 0) continue;
                sout.putRaw(3, los);
            }
        }
        sout.flush();
        if (os.size() > 0) {
            ssout.putRaw(3, os);
        }
        ssout.flush();
        if (oss.size() > 0) {
            out.putEmpty(2);
            out.putRaw(202, oss);
        }
    }

    public static class ListLevel {
        int markerAlign = 0;
        int startFrom = 1;
        int markerIndent = 0;
        int firstIndent = 10;
        int leftIndent = 0;
        int type = 0;
        String formatString;
        String fontName = "Times New Roman";
        int fontSize = 10;
        int fontColor = 0;
        int fontStyle = 0;

        public boolean equal(ListLevel ll) {
            return this.markerAlign == ll.markerAlign && this.startFrom == ll.startFrom && this.markerIndent == ll.markerIndent && this.firstIndent == ll.firstIndent && this.leftIndent == ll.leftIndent && this.type == ll.type && Strings.equals(this.formatString, ll.formatString) && Strings.equals(this.fontName, ll.fontName) && this.fontSize == ll.fontSize && this.fontColor == ll.fontColor && this.fontStyle == ll.fontStyle;
        }
    }

    public static class List {
        ArrayList<ListLevel> levels = new ArrayList();
        boolean standart = false;
        String styleName;
    }

    public static class Paragraph {
        int align = 0;
        int lineSpacing = 100;
        int firstIndent = 0;
        int leftIndent = 0;
        int rightIndent = 0;
        int lineSpacingType = 0;
        boolean standart = false;

        public void assign(Paragraph p) {
            this.align = p.align;
            this.lineSpacing = p.lineSpacing;
            this.firstIndent = p.firstIndent;
            this.leftIndent = p.leftIndent;
            this.rightIndent = p.rightIndent;
            this.lineSpacingType = p.lineSpacingType;
            this.standart = p.standart;
        }

        public boolean equal(Paragraph p) {
            return this.align == p.align && this.lineSpacing == p.lineSpacing && this.firstIndent == p.firstIndent && this.leftIndent == p.leftIndent && this.rightIndent == p.rightIndent && this.lineSpacingType == p.lineSpacingType && this.standart == p.standart;
        }
    }

    public static class Text {
        String name = "Times New Roman";
        int size = 10;
        int color = 0;
        int style = 0;
        int background = 0x1FFFFFFF;
        boolean jump = false;
        boolean standart = false;

        public void assign(Text f) {
            this.name = f.name;
            this.size = f.size;
            this.color = f.color;
            this.style = f.style;
            this.background = f.background;
            this.jump = f.jump;
            this.standart = f.standart;
        }

        public boolean equal(Text f) {
            return Strings.equals(this.name, f.name) && this.size == f.size && this.color == f.color && this.style == f.style && this.background == f.background && this.jump == f.jump && this.standart == f.standart;
        }
    }
}

