/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.document;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.document.CellData;
import inform.agent.document.CustomItem;
import inform.agent.document.Data;
import inform.agent.document.TableRow;
import java.util.ArrayList;

public class Table
extends CustomItem {
    private ArrayList<TableRow> rows = new ArrayList();
    public int color = 0xFFFFFF;
    public int cellBorderColor = 0;
    public int bestWidth = 0;
    public int borderWidth = 0;
    public int cellHPadding = 1;
    public int cellVPadding = 1;
    public int cellHSpacing = -1;
    public int cellVSpacing = -1;
    public boolean borderLeftVisible = true;
    public boolean borderRightVisible = true;
    public boolean borderTopVisible = true;
    public boolean borderBottomVisible = true;

    @Override
    public int styleNo() {
        return -60;
    }

    public void init(int rowCount, int colCount, Data data) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow(colCount);
        }
    }

    public TableRow addRow(int colCount) {
        TableRow tr = new TableRow();
        tr.init(colCount);
        this.rows.add(tr);
        return tr;
    }

    private TableRow insertRow(int index, int colCount) {
        TableRow tr = new TableRow();
        tr.init(colCount);
        this.rows.add(index, tr);
        return tr;
    }

    public void insertRows(int index, int count) {
        for (int i = 0; i < count; ++i) {
            this.insertRow(index, this.colCount());
        }
    }

    public void insertCols(int index, int count) {
        for (int r = 0; r < this.rows.size(); ++r) {
            for (int c = 0; c < count; ++c) {
                this.rows.get(r).insert(index);
            }
        }
    }

    public void reset(int rowCount, int colCount) {
        this.rows.clear();
        for (int i = 0; i < rowCount; ++i) {
            this.addRow(colCount);
        }
    }

    public TableRow getRow(int index) {
        return this.rows.get(index);
    }

    public int rowCount() {
        return this.rows.size();
    }

    public int colCount() {
        if (this.rows.size() > 0) {
            return this.rows.get(0).count();
        }
        return 0;
    }

    public CellData cells(int r, int c) {
        return this.rows.get(r).get(c);
    }

    @Override
    public void store(TaggedWriter out) throws Throwable {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter sout = new TaggedWriter(os);
        sout.putInt32(1, this.rows.size());
        sout.putInt32(2, this.rows.get(0).count());
        sout.putInt32(11, this.color);
        sout.putInt32(12, this.cellBorderColor);
        if (this.bestWidth != 0) {
            sout.putInt32(13, this.bestWidth);
        }
        if (this.borderWidth != 0) {
            sout.putInt32(14, this.borderWidth);
        }
        if (this.cellHSpacing != -1) {
            sout.putInt32(15, this.cellHSpacing);
        }
        if (this.cellVSpacing != -1) {
            sout.putInt32(16, this.cellVSpacing);
        }
        if (this.cellHPadding != 1) {
            sout.putInt32(17, this.cellHPadding);
        }
        if (this.cellVPadding != 1) {
            sout.putInt32(18, this.cellVPadding);
        }
        if (!(this.borderLeftVisible && this.borderRightVisible && this.borderTopVisible && this.borderBottomVisible)) {
            int borders = 0;
            if (!this.borderLeftVisible) {
                borders |= 0xFF;
            }
            if (!this.borderRightVisible) {
                borders |= 0xFF00;
            }
            if (!this.borderTopVisible) {
                borders |= 0xFF0000;
            }
            if (!this.borderBottomVisible) {
                borders |= 0xFF000000;
            }
            sout.putInt32(19, borders);
        }
        this.storeTableCells(sout);
        if (!this.sameAsPrev()) {
            sout.putEmpty(5);
        }
        sout.putInt32(6, this.paraNo);
        sout.flush();
        if (os.size() > 0) {
            out.putEmpty(5);
            out.putRaw(202, os);
        }
    }

    public void storeTableCells(TaggedWriter out) throws Throwable {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter sout = new TaggedWriter(os);
        for (int i = 0; i < this.rowCount(); ++i) {
            for (int j = 0; j < this.colCount(); ++j) {
                CellData cell = this.cells(i, j);
                if (cell == null) continue;
                sout.putEmpty(1);
                sout.putInt32(3, i);
                sout.putInt32(4, j);
                sout.putInt32(5, cell.bestWidth);
                sout.putInt32(6, cell.bestHeight);
                if (cell.rowSpan != 1) {
                    sout.putInt32(7, cell.rowSpan);
                }
                if (cell.colSpan != 1) {
                    sout.putInt32(8, cell.colSpan);
                }
                if (cell.color != this.color) {
                    sout.putInt32(11, cell.color);
                }
                if (cell.borderColor != this.cellBorderColor) {
                    sout.putInt32(12, cell.borderColor);
                }
                int borders = 0;
                if (cell.borderLeftVisible) {
                    borders |= 0xFF;
                }
                if (cell.borderRightVisible) {
                    borders |= 0xFF00;
                }
                if (cell.borderTopVisible) {
                    borders |= 0xFF0000;
                }
                if (cell.borderBottomVisible) {
                    borders |= 0xFF000000;
                }
                sout.putInt32(9, borders);
                cell.store(sout, 10);
                sout.putEmpty(2);
            }
        }
        sout.flush();
        out.putEmpty(4);
        out.putRaw(202, os);
    }

    public MergeResult getMainCell(int ar, int ac) {
        MergeResult result = new MergeResult();
        result.r = ar;
        result.c = ac;
        if (this.cells(result.r, result.c) != null) {
            result.data = this.cells(result.r, result.c);
            return result;
        }
        while (true) {
            TableRow row = this.rows.get(result.r);
            while (row.get(result.c) == null && result.c > 0) {
                --result.c;
            }
            if (row.get(result.c) != null && row.get((int)result.c).colSpan > ac - result.c && row.get((int)result.c).rowSpan > ar - result.r) {
                result.data = row.get(result.c);
                return result;
            }
            result.c = ac;
            --result.r;
        }
    }

    private MergeResult startMergeCells(int topRow, int leftCol, int outColSpan, Integer outRowSpan) {
        MergeResult result = new MergeResult();
        result.r = outRowSpan;
        result.c = outColSpan;
        result.value = false;
        if (topRow + result.r > this.rows.size()) {
            result.r = this.rows.size() - topRow;
        }
        if (leftCol + result.c > this.rows.get(topRow).count()) {
            result.c = this.rows.get(topRow).count() - leftCol;
        }
        if (result.r < 2 && result.c < 2) {
            return result;
        }
        if (result.r < 1 || result.c < 1) {
            throw new InformException("Error in startMergeCells: rowSpan or colSpan less one.");
        }
        CellData cd = this.cells(topRow, leftCol);
        result.value = cd != null && (cd.rowSpan < result.r || cd.colSpan < result.c);
        return result;
    }

    private boolean canMergeCells(int topRow, int leftCol, int colSpan, int rowSpan) {
        Integer ics = colSpan;
        Integer irs = rowSpan;
        MergeResult mResult = this.startMergeCells(topRow, leftCol, ics, irs);
        if (!mResult.value) {
            return false;
        }
        Boolean flag = false;
        mResult = this.getMainCell(topRow, leftCol);
        CellData mainCell = mResult.data;
        for (int r = topRow; r < topRow + rowSpan; ++r) {
            for (int c = leftCol; c < leftCol + colSpan; ++c) {
                CellData cell = null;
                if (this.cells(r, c) != null) {
                    cell = this.cells(r, c);
                    mResult.r = r;
                    mResult.c = c;
                } else {
                    mResult = this.getMainCell(r, c);
                    cell = mResult.data;
                }
                if (mResult.r < topRow || mResult.c < leftCol || mResult.r + cell.rowSpan > topRow + rowSpan || mResult.c + cell.colSpan > leftCol + colSpan) {
                    return false;
                }
                if (cell == mainCell) continue;
                flag = true;
            }
        }
        return flag;
    }

    private int getBestWidth(int topRow, int leftCol, int colSpan, int rowSpan) {
        int result = 0;
        for (int r = topRow; r < topRow + rowSpan; ++r) {
            int bw = 0;
            for (int c = leftCol; c < leftCol + colSpan; ++c) {
                CellData cell = this.cells(r, c);
                if (cell == null) continue;
                if (cell.bestWidth > 0) {
                    if (bw < 0) continue;
                    bw += cell.bestWidth;
                    continue;
                }
                if (cell.bestWidth >= 0) continue;
                if (bw > 0) {
                    bw = 0;
                }
                bw += cell.bestWidth;
            }
            if ((result < 0 || bw >= 0 && bw <= result) && (result >= 0 || bw >= result)) continue;
            result = bw;
        }
        return result;
    }

    private void doMergeCells(int row, int col, int colSpan, int rowSpan, boolean changeBestWidth) {
        CellData vampire = this.cells(row, col);
        if (changeBestWidth) {
            vampire.bestWidth = this.getBestWidth(row, col, colSpan, rowSpan);
        }
        for (int r = row; r < row + rowSpan; ++r) {
            for (int c = col; c < col + colSpan; ++c) {
                CellData victim = this.cells(r, c);
                if (victim == null || victim == vampire) continue;
                if (victim.hasContent(false)) {
                    vampire.moveFrom(victim);
                }
                this.rows.get(r).releaseCell(c);
            }
        }
        vampire.colSpan = colSpan;
        vampire.rowSpan = rowSpan;
    }

    public void mergeCells(int topRow, int leftCol, int colSpan, int rowSpan, boolean changeBestWidth) {
        Integer ics = colSpan;
        Integer irs = rowSpan;
        MergeResult mResult = this.startMergeCells(topRow, leftCol, ics, irs);
        if (!mResult.value) {
            return;
        }
        if (!this.canMergeCells(topRow, leftCol, colSpan, rowSpan)) {
            return;
        }
        this.doMergeCells(topRow, leftCol, colSpan, rowSpan, changeBestWidth);
    }

    public static class MergeResult {
        int r;
        int c;
        CellData data;
        boolean value;
    }
}

