/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ServerSideHost;
import inform.agent.db.types.DataType;
import inform.agent.exchange.ConstEntry;
import inform.agent.exchange.Constant;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

public class ConstantsSet
extends ArrayList<Constant> {
    private static final int CONST_NODE_ID = 3;
    private long lastContentTime = 0L;
    private static final String ERROR_LOADING_CONSTANT_VALUES = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u043d\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439";
    private static long cachedConstantDescriptorsTime = 0L;
    private static Hashtable<Integer, ConstEntry> cachedConstantDescriptors = null;

    private void load(TaggedReader in) throws IOException {
        Constant c = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 10: {
                    int[] header = LittleEndian.toIntArray(in.getRaw());
                    c = new Constant();
                    this.add(c);
                    if (header.length <= 1) break;
                    c.constEntry().id = header[0];
                    c.constEntry().data_type = DataType.getDataTypeById(header[1]);
                    break;
                }
                case 11: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().name = in.getAnsi();
                    break;
                }
                case 12: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().caption = in.getAnsi();
                    break;
                }
                case 32: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    in.skip();
                    c.constEntry().associateForm = in.getRaw(202);
                    break;
                }
                case 30: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().comment = in.getAnsi();
                    break;
                }
                case 35: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().access = in.getInt();
                    break;
                }
                case 13: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type == DataType.BOOLEAN) {
                        c.constEntry().value = in.getInt() != 0 ? 1 : 0;
                        break;
                    }
                    if (c.constEntry().data_type != DataType.INTEGER) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().value = in.getInt();
                    break;
                }
                case 14: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.FLOAT && c.constEntry().data_type != DataType.INTERVAL && c.constEntry().data_type != DataType.METATREE_NODE) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().value = in.getDouble();
                    break;
                }
                case 16: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.DATE_TIME) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().value = in.getDouble();
                    break;
                }
                case 15: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.STRING) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().value = in.getAnsi();
                    break;
                }
                case 34: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.UNICODE) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().value = in.getUnicode();
                    break;
                }
                case 17: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().isNull = true;
                    break;
                }
                case 24: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    in.skip();
                    c.constEntry().value_sel_ref = in.getDouble(151);
                    break;
                }
                case 25: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().value_sel_fld = in.getInt();
                    break;
                }
                case 22: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.DIRECTORY) break;
                    c.constEntry().ref_rec = in.getDouble();
                    c.constEntry().ref_field = in.getInt();
                    c.constEntry().ref_node = in.getDouble(151);
                    break;
                }
                case 26: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().ignore = true;
                    break;
                }
                case 27: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().func = in.getInt();
                    break;
                }
                case 28: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.PRIMARY_KEY) break;
                    c.constEntry().ref_rec = in.getDouble();
                    c.constEntry().ref_field = -1;
                    c.constEntry().ref_node = in.getDouble(29);
                    break;
                }
                case 33: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    in.skip();
                    break;
                }
                case 29: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    if (c.constEntry().data_type != DataType.PRIMARY_KEY) break;
                    c.constEntry().ref_node = in.getDouble();
                    break;
                }
                case 36: {
                    if (c == null) {
                        throw new InformException(ERROR_LOADING_CONSTANT_VALUES);
                    }
                    c.constEntry().formatId = in.getInt();
                }
            }
        }
    }

    public void save(TaggedWriter out) throws IOException {
        for (int i = 0; i < this.size(); ++i) {
            ((Constant)this.get(i)).save(out);
        }
        out.flush();
    }

    public Constant findById(int constId) {
        for (int i = 0; i < this.size(); ++i) {
            if (((Constant)this.get(i)).id() != constId) continue;
            return (Constant)this.get(i);
        }
        return null;
    }

    public void merge(ConstantsSet set) {
        for (int i = 0; i < set.size(); ++i) {
            Constant c = (Constant)set.get(i);
            Constant target = this.findById(c.id());
            if (target == null) {
                target = new Constant();
                target.assign(c.constEntry());
                this.add(target);
                continue;
            }
            target.constEntry().data_type = c.constEntry().data_type;
            target.constEntry().name = c.constEntry().name;
            target.constEntry().caption = c.constEntry().caption;
            target.constEntry().comment = c.constEntry().comment;
            target.constEntry().ref_node = c.constEntry().ref_node;
            target.constEntry().ref_field = c.constEntry().ref_field;
            target.constEntry().func = c.constEntry().func;
            target.constEntry().value_sel_ref = c.constEntry().value_sel_ref;
            target.constEntry().value_sel_fld = c.constEntry().value_sel_fld;
            target.constEntry().associateForm = c.constEntry().associateForm;
            target.constEntry().access = c.constEntry().access;
        }
    }

    public void open(byte[] content) throws IOException {
        if (content != null) {
            TaggedReader reader = new TaggedReader(content);
            this.load(reader);
        }
    }

    public boolean open() throws IOException {
        BasicNode node = MtdEngine.getValidNode(3.0).getRealNode();
        if (node == null) {
            return false;
        }
        BasicNode.NodeContent nodeContent = node.getNodeContent(0.0, true);
        this.lastContentTime = nodeContent.lastContentTime;
        TaggedReader reader = new TaggedReader(nodeContent.content);
        this.load(reader);
        return true;
    }

    public void setContent(SSContext context, ServerSideHost host, byte[] content, String dslContent) throws InformException, SQLException {
        if (content.length == 0) {
            return;
        }
        MtdEngine.setNodeContent(context, host, 3.0, this.lastContentTime, content, dslContent, host.getUserID(), host.getSessionID(), host.security());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    public static synchronized Hashtable<Integer, ConstEntry> getConstantDescriptors() {
        BasicNode node = MtdEngine.getValidNode(3.0).getRealNode();
        BasicNode.NodeContent nodeContent = node.getNodeContent(0.0, true);
        if (cachedConstantDescriptors == null || nodeContent.lastContentTime != cachedConstantDescriptorsTime) {
            cachedConstantDescriptorsTime = nodeContent.lastContentTime;
            cachedConstantDescriptors = new Hashtable();
            try {
                ConstantsSet constants = new ConstantsSet();
                constants.load(new TaggedReader(nodeContent.content));
                for (Constant constant : constants) {
                    cachedConstantDescriptors.put(constant.id(), constant.constEntry());
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }
        return cachedConstantDescriptors;
    }
}

