/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import inform.agent.scripts.Constant;
import java.io.IOException;

public class ConstantTerm
extends Term {
    protected int constId;
    protected Constant constant = null;

    public ConstantTerm(Expression expr) {
        super(expr);
    }

    @Override
    public final Term createClone(Expression e) {
        ConstantTerm o = new ConstantTerm(e);
        o.constId = this.constId;
        o.constant = this.constant;
        return o;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.OPERAND;
    }

    @Override
    public Expression.Token getToken() {
        return Expression.Token.globalConst;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 10: {
                this.constId = in.getInt();
            }
        }
        super.loadTag(in);
    }

    @Override
    public void afterLoad() {
        this.constant = this.expression.getConstants().get(this.constId);
    }

    public int getConstId() {
        return this.constId;
    }

    public Constant getConstant() {
        return this.constant;
    }

    public void setConstant(Constant constant) {
        this.constant = constant;
    }
}

